/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.util.Util;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class InternalReference
extends InternalReferenceObject {
    public static final InternalReference NULL = new InternalReference(null, null){};
    private List<LinkKey> originalKeys;
    private BrokenStatus broken = BrokenStatus.IGNORED;
    protected String referenceType;
    private Map<String, String> parameters;
    private TextRange fragmentLocation;
    protected final Record record = new Record(this);
    private Reference tempNextReference;

    public InternalReference(ILink link, String referenceType) {
        this.record.dirty = true;
        this.referenceType = referenceType;
        this.markLoaded();
        if (link != null && referenceType != null) {
            Assert.isNotNull((Object)link, (String)Messages.InternalReference_0);
            Assert.isNotNull((Object)referenceType, (String)Messages.InternalReference_1);
            Assert.isLegal((link.getId() != -1 ? 1 : 0) != 0, (String)Messages.InternalReference_2);
            this.record.linkId = link.getId();
        }
    }

    public TextRange getFragmentLocation() {
        this.loadData();
        return this.fragmentLocation;
    }

    public TextRange getAbsoluteFragmentLocation() {
        this.loadData();
        TextRange absRange = new TextRange(this.fragmentLocation.getOffset() + this.getSource().getLinkLocation().getOffset(), this.fragmentLocation.getLength(), this.fragmentLocation.getLinenumber());
        return absRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFragmentLocation(TextRange fragmentLocation) {
        ILink source = this.getSource();
        if (source == null) {
            Assert.isNotNull((Object)source, (String)Messages.InternalReference_3);
            return;
        }
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (fragmentLocation == null) {
                String link;
                try {
                    link = source.toString();
                    link = source.getContextText();
                }
                catch (Exception exception) {
                    link = "null";
                }
                Assert.isNotNull((Object)fragmentLocation, (String)NLS.bind((String)Messages.errorMsg_fragment_can_not_be_null_link_X, (Object)link));
                return;
            }
            TextRange absRange = new TextRange(fragmentLocation.getOffset() + source.getLinkLocation().getOffset(), fragmentLocation.getLength(), fragmentLocation.getLinenumber());
            if (!source.getLinkLocation().contains(absRange)) {
                String link = source.toString();
                try {
                    link = source.getContextText();
                }
                catch (Exception exception) {
                    link = "null";
                }
                String error = NLS.bind((String)Messages.errorMsg_link_range_X_does_not_contain_Y_link_Z, (Object[])new String[]{source.getLinkLocation().toString(), fragmentLocation.toString(), link});
                Assert.isLegal((boolean)false, (String)error);
            }
            this.fragmentLocation = fragmentLocation;
        }
    }

    @Override
    public int getId() {
        return super.getId();
    }

    protected void copyFrom(InternalReference other) {
        this.loadData();
        Assert.isNotNull((Object)other.getSource(), (String)Messages.errorMsg_reference_source_can_not_be_null);
        if (!Util.isEqualOrBothNull(this.record.linkId, other.record.linkId)) {
            this.record.linkId = other.record.linkId;
            this.record.dirty = true;
        }
        if (!Util.isEqualOrBothNull(this.referenceType, other.referenceType)) {
            this.referenceType = other.referenceType;
            this.record.dirty = true;
        }
        if (!Util.isEqualOrBothNull(this.parameters, other.parameters)) {
            this.parameters = other.parameters;
            this.record.dirty = true;
        }
        this.setNextReference(other.getNextReference());
    }

    @Override
    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.REFERENCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextReference(Reference nextReference) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (!Util.isEqualOrBothNull(this.getNextReference(), nextReference)) {
                this.saveOriginal();
                if (nextReference == null) {
                    this.record.nextReferenceId = -1;
                    this.tempNextReference = null;
                } else if (nextReference.getId() >= 0) {
                    this.record.nextReferenceId = nextReference.getId();
                } else {
                    this.tempNextReference = nextReference;
                }
                this.record.dirty = true;
            }
        }
    }

    protected String getCachingKey() {
        this.loadData();
        StringBuilder b = new StringBuilder();
        b.append(this.getReferenceType());
        b.append(":");
        Map<String, String> params = this.getParameters();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            b.append(key);
            b.append(val);
        }
        ILink s = this.getSource();
        if (s != null) {
            b.append(s.getName());
            Map<String, String> params2 = ((Link)s).getParameters();
            if (params2 != null) {
                for (Map.Entry<String, String> entry : params2.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    b.append(key);
                    b.append(val);
                }
            }
        }
        return b.toString();
    }

    public Reference getNextReference() {
        this.loadData();
        if (this.tempNextReference != null) {
            Assert.isTrue((boolean)this.record.dirty, (String)Messages.InternalReference_5);
            return this.tempNextReference;
        }
        if (this.record.nextReferenceId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.record.nextReferenceId, Reference.class);
        }
        return null;
    }

    public ILink getSource() {
        this.loadData();
        if (this.record.linkId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.record.linkId, ILink.class);
        }
        return null;
    }

    public String getReferenceType() {
        this.loadData();
        return this.referenceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String key, String value) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            this.saveOriginal();
            this.parameters.put(key, value);
            this.record.dirty = true;
        }
    }

    public String getParameter(String key) {
        this.loadData();
        if (this.parameters != null) {
            return this.parameters.get(key);
        }
        return null;
    }

    @Override
    public InternalReferenceRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        if (InternalAPI.LOAD_DATA_FOR_TO_STRING) {
            this.loadData();
        }
        if (this.record.isFullyLoaded()) {
            String s = String.valueOf(this.getElementType().name()) + super.toString() + " TYPE: " + this.getReferenceType();
            s = String.valueOf(s) + " source: ";
            s = String.valueOf(s) + "NR " + this.record.linkId;
            s = String.valueOf(s) + " next: ";
            s = String.valueOf(s) + "NR " + this.record.nextReferenceId;
            if (this.parameters != null) {
                s = String.valueOf(s) + " " + this.parameters.size() + " Parameters: ";
                for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                    s = String.valueOf(s) + "[" + entry.getKey() + "]=[" + entry.getValue() + "], ";
                }
            }
            return s;
        }
        String s = String.valueOf(this.getElementType().name()) + " Proxy object: " + super.toString();
        return s;
    }

    @Override
    public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
        Reference nextReference;
        this.loadData();
        if (graph.contains(this)) {
            return;
        }
        ILink source = this.getSource();
        if (source != null) {
            ((InternalReferenceObject)((Object)source)).getObjectGraph(graph, objMarkers);
            graph.add((InternalReferenceObject)((Object)source));
        }
        if ((nextReference = this.getNextReference()) != null) {
            ((InternalReferenceObject)nextReference).getObjectGraph(graph, objMarkers);
            graph.add(nextReference);
        }
    }

    @Override
    protected void assignedId(int id) {
        if (this.tempNextReference != null) {
            Assert.isTrue((boolean)this.record.isDirty(), (String)Messages.InternalReference_6);
            Assert.isTrue((this.tempNextReference.getId() != -1 ? 1 : 0) != 0, (String)Messages.InternalReference_7);
            this.record.nextReferenceId = this.tempNextReference.getId();
        }
    }

    private void saveOriginal() {
        this.loadData();
        if (this.frozen && this.originalKeys == null) {
            this.originalKeys = IndexManager.getKeys(this);
        }
    }

    public Set<IResolvedReference> resolve() {
        SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.getId()), IndexConstants.BY_REFERENCE_ID, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        SearchScope scope = SearchEngine.createWorkspaceScope();
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, req, null);
        return req.getMatches();
    }

    @Override
    protected List<LinkKey> getOriginalKeys() {
        return this.originalKeys;
    }

    public BrokenStatus getBrokenStatus() {
        this.loadData();
        return this.broken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokenStatus(BrokenStatus status) {
        Record record = this.record;
        synchronized (record) {
            this.loadData();
            if (this.broken != status) {
                this.saveOriginal();
                this.broken = status;
                this.record.dirty = true;
            }
        }
    }

    public String getFragmentText() {
        this.loadData();
        ILink source = this.getSource();
        if (source == null) {
            Status status = new Status(4, "com.ibm.etools.references", "The link for this reference could not be found. (Deleted?)");
            throw new ReferenceException((IStatus)status);
        }
        int offset = this.getFragmentLocation().getOffset();
        int length = this.getFragmentLocation().getLength();
        if (length == 0) {
            return "";
        }
        if (source.getLinkText() == null) {
            return "";
        }
        return source.getLinkText().substring(offset, offset + length);
    }

    public Map<String, String> getParameters() {
        this.loadData();
        if (this.parameters != null) {
            return Collections.unmodifiableMap(this.parameters);
        }
        return Collections.emptyMap();
    }

    @Override
    protected void clearOriginalKeys() {
        this.originalKeys = null;
    }

    static class Record
    extends InternalReferenceRecord {
        private final InternalReference reference;
        public boolean dirty;
        int linkId = -1;
        int nextReferenceId = -1;

        public Record(InternalReference reference) {
            super(IReferenceElement.ElementType.REFERENCE.ordinal());
            this.reference = reference;
        }

        @Override
        public void doReadRecord(PooledByteBuffer bytes) {
            this.linkId = ByteUtils.bytesToInt(bytes.buffer);
            this.reference.broken = BrokenStatus.values()[ByteUtils.bytesToUnsignedShort(bytes.buffer)];
            this.reference.fragmentLocation = new TextRange(0, 0, 0);
            this.reference.fragmentLocation.readRecord(new PooledByteBuffer(bytes.buffer));
            this.nextReferenceId = ByteUtils.bytesToInt(bytes.buffer);
            int refType = ByteUtils.bytesToInt(bytes.buffer);
            this.reference.referenceType = ReferenceGeneratorService.getInstance().getReferenceType(refType);
            int parameterSize = ByteUtils.bytesToInt(bytes.buffer);
            this.reference.parameters = new HashMap(parameterSize);
            int i = 0;
            while (i < parameterSize) {
                String e = ByteUtils.bytesToString(bytes.buffer);
                String v = ByteUtils.bytesToString(bytes.buffer);
                this.reference.parameters.put(e, v);
                ++i;
            }
            this.reference.providerId = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            bytes.returnBuffer();
            this.clean();
            this.reference.freeze();
        }

        @Override
        public PooledByteBuffer doWriteRecord() {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            Assert.isTrue((this.linkId != -1 ? 1 : 0) != 0);
            buffers.add(ByteUtils.intToBytes(this.linkId));
            buffers.add(ByteUtils.unsignedShortToBytes(this.reference.broken.ordinal()));
            PooledByteBuffer buffer = this.reference.fragmentLocation.writeRecord();
            buffers.add(buffer.copy());
            buffer.returnBuffer();
            if (this.reference.tempNextReference != null) {
                this.nextReferenceId = this.reference.tempNextReference.getId();
                this.reference.tempNextReference = null;
            }
            buffers.add(ByteUtils.intToBytes(this.nextReferenceId));
            buffers.add(ByteUtils.intToBytes(ReferenceGeneratorService.getInstance().getReferenceTypeId(this.reference.referenceType)));
            if (this.reference.parameters != null) {
                buffers.add(ByteUtils.intToBytes(this.reference.parameters.size()));
                for (Map.Entry entry : this.reference.parameters.entrySet()) {
                    buffers.add(ByteUtils.stringToBytes((String)entry.getKey()));
                    buffers.add(ByteUtils.stringToBytes((String)entry.getValue()));
                }
            } else {
                buffers.add(ByteUtils.intToBytes(0));
            }
            buffers.add(ByteUtils.unsignedShortToBytes(this.reference.providerId));
            int size = 0;
            for (ByteBuffer byteBuffer : buffers) {
                size += byteBuffer.limit();
            }
            PooledByteBuffer payload = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
            for (ByteBuffer byteBuffer : buffers) {
                payload.buffer.put(byteBuffer);
            }
            payload.buffer.rewind();
            return payload;
        }

        @Override
        public int getSize() {
            int size = 30;
            if (this.reference.parameters != null) {
                for (Map.Entry entry : this.reference.parameters.entrySet()) {
                    size += ByteUtils.storageSize((String)entry.getKey());
                    size += ByteUtils.storageSize((String)entry.getValue());
                }
            }
            return size;
        }

        @Override
        protected void clean() {
            this.dirty = false;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        protected InternalReferenceObject getLinkArtifact() {
            return this.reference;
        }

        @Override
        protected Collection<? extends IReferenceElement> getDeleteCascade() {
            SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.reference.getId()), IndexConstants.BY_REFERENCE_ID, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
            SearchScope scope = SearchEngine.createWorkspaceScope();
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            new SearchEngine().search(pattern, scope, req, null);
            return req.getMatches();
        }
    }
}

