/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class InternalLinkNode<E extends IResource>
implements IReferenceElement,
IAdaptable {
    private boolean parseLinksOnly;
    protected final E resource;

    protected InternalLinkNode(E resource) {
        this.resource = resource;
        this.parseLinksOnly = false;
    }

    public void setParseLinksOnly(boolean parseLinksOnly) {
        this.parseLinksOnly = parseLinksOnly;
    }

    public boolean isParseLinksOnly() {
        return this.parseLinksOnly;
    }

    @Override
    public int getId() {
        return -1;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.NODE;
    }

    @Deprecated
    public Collection<ILink> getLinks(IProgressMonitor monitor) throws ReferenceException {
        return this.getLinks(null, SpecializedType.Depth.ZERO, monitor);
    }

    public Collection<ILink> getLinks(SpecializedType linkType, SpecializedType.Depth depth, IProgressMonitor monitor) throws ReferenceException {
        Assert.isNotNull((Object)((Object)depth), (String)Messages.LinkNode_0);
        if (depth != SpecializedType.Depth.ZERO && depth != SpecializedType.Depth.INFINITE) {
            throw new UnsupportedOperationException("Depth: " + (Object)((Object)depth) + " is not implemented");
        }
        SearchPattern pattern = null;
        pattern = linkType == null ? SearchPattern.createWildcardPattern() : InternalSearchPattern.createPattern(linkType.getId(), IndexConstants.BY_LINKTYPE, IReferenceElement.ElementType.LINK, 0);
        if (pattern != null) {
            SearchScope scope = null;
            if (depth == SpecializedType.Depth.ZERO) {
                scope = this.getResource().getType() == 4 ? SearchEngine.createSearchScope(this.getResource().getFullPath()) : SearchEngine.createSearchScope(new IResource[]{this.getResource()});
            } else if (depth == SpecializedType.Depth.INFINITE) {
                scope = SearchEngine.createSearchScope(new IResource[]{this.getResource()});
            }
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            new SearchEngine().search(pattern, scope, req, monitor);
            return req.getMatches();
        }
        return Collections.emptyList();
    }

    public Collection<ILink> getIncomingLinks(IProgressMonitor monitor) throws ReferenceException {
        return this.getIncomingLinks(monitor, SearchEngine.createWorkspaceScope());
    }

    public Collection<ILink> getIncomingLinks(IProgressMonitor monitor, SearchScope scope) throws ReferenceException {
        return this.getIncomingLinks(monitor, SpecializedType.Depth.ZERO, scope);
    }

    public Collection<ILink> getIncomingLinks(IProgressMonitor monitor, SpecializedType.Depth depth, SearchScope scope) throws ReferenceException {
        ArrayList<ILink> incoming = new ArrayList<ILink>();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.beginTask("", 2);
        Collection<ILink> links = this.getLinks(null, depth, (IProgressMonitor)mon.newChild(1));
        SubMonitor resolveMonitor = mon.newChild(1);
        resolveMonitor.beginTask("", links.size());
        for (ILink link : links) {
            Collection<IResolvedReference> references = link.resolveIncomingReference(null, scope, (IProgressMonitor)resolveMonitor.newChild(1));
            for (IResolvedReference resolvedReference : references) {
                incoming.add(resolvedReference.getSource());
            }
        }
        mon.done();
        return incoming;
    }

    public E getResource() {
        return this.resource;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalLinkNode other = (InternalLinkNode)obj;
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

