/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.InternalReferencesJob;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.management.ReferenceManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public final class EventNotification
implements Runnable {
    private final ConcurrentLinkedQueue<EventInfo> queue;
    private final AtomicInteger integer = new AtomicInteger();
    private final InternalReferencesJob lastExecution = new InternalReferencesJob(this);

    EventNotification() {
        this.queue = new ConcurrentLinkedQueue();
    }

    public void addEvents(EventInfo events) {
        this.queue.add(events);
        this.integer.addAndGet(events.getSize());
    }

    public void doSchedule(long delay) {
        this.lastExecution.schedule(delay, TimeUnit.MILLISECONDS);
    }

    public void executeNow() {
        this.lastExecution.cancel();
        this.lastExecution.schedule(0L, TimeUnit.NANOSECONDS);
        this.lastExecution.get();
    }

    @Override
    public void run() {
        this.run(null);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        EventInfo info = this.queue.poll();
        while (info != null) {
            mon.setWorkRemaining(this.integer.get());
            final List<ReferenceEvent> events = info.events;
            for (final IReferenceListener referenceListener : info.listeners) {
                SafeRun.run(false, referenceListener, new SafeRun.IRunnableWithResult<Object>(){

                    @Override
                    public Object run() throws Exception {
                        referenceListener.handleReferenceEvents(events);
                        return null;
                    }
                });
                mon.worked(1);
                this.integer.decrementAndGet();
            }
            info = this.queue.poll();
        }
        if (monitor != null) {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void fireEvents(List<ReferenceEvent> events) {
        if (!events.isEmpty()) {
            List<IReferenceListener> listeners = ReferenceManager.getReferenceManager().getListeners();
            EventInfo info = new EventInfo();
            info.listeners = Collections.unmodifiableList(listeners);
            info.events = Collections.unmodifiableList(events);
            this.addEvents(info);
            this.doSchedule(0L);
        }
    }

    public void notifyEvents(List<ReferenceEvent> events) {
        if (!events.isEmpty()) {
            List<IReferenceListener> listeners = ReferenceManager.getReferenceManager().getListeners();
            EventInfo info = new EventInfo();
            info.listeners = Collections.unmodifiableList(listeners);
            info.events = Collections.unmodifiableList(events);
            this.addEvents(info);
            this.executeNow();
        }
    }

    public static class EventInfo {
        public List<ReferenceEvent> events;
        public List<IReferenceListener> listeners;

        public int getSize() {
            int size = 0;
            if (this.events != null) {
                size += this.events.size();
            }
            if (this.listeners != null) {
                size += this.listeners.size();
            }
            return size;
        }
    }
}

