/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.IErrorListener;
import com.ibm.etools.references.internal.ReferencesPreferencesAccess;
import com.ibm.etools.references.internal.management.ErrorRecovery;
import com.ibm.etools.references.internal.management.IRunnableJob;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.ReferenceManager;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;

public class ErrorRecoveryJob
extends Job
implements IRunnableJob {
    private volatile String ignoredPath;
    private volatile int faults = 0;

    public ErrorRecoveryJob() {
        super(Messages.indexerErrorRecovery);
        this.setSystem(true);
    }

    public void setFaults(int faults) {
        this.faults = faults;
    }

    public void setIgnoredPath(String ignoredPath) {
        this.ignoredPath = ignoredPath;
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        String thePath = this.ignoredPath;
        if (this.faults == 1) {
            List<IErrorListener> listeners = ReferenceManager.getReferenceManager().getErrorListeners();
            for (IErrorListener errorListener : listeners) {
                errorListener.handleErrorRecovery(this.faults, thePath);
            }
            ReferenceManager.getReferenceManager().requestRebuildIndex(monitor);
        } else {
            List<IErrorListener> listeners = ReferenceManager.getReferenceManager().getErrorListeners();
            boolean proceed = true;
            if (!listeners.isEmpty()) {
                IErrorListener errorListener = listeners.get(0);
                proceed = errorListener.handleErrorRecovery(this.faults, thePath);
            }
            if (proceed) {
                String path = thePath == null ? "" : thePath;
                Status interactive = new Status(1, "com.ibm.etools.references", NLS.bind((String)Messages.userChoseToIgnoreXandReindex, (Object)TextProcessor.process((String)path)));
                Logger.log(Logger.Category.REFERENCE_MANAGER, Logger.Severity.INFO, Logger.Mode.USER, (IStatus)interactive);
                if (thePath != null) {
                    ReferencesPreferencesAccess.INSTANCE.addIgnoredResource(Collections.singletonList(thePath));
                }
                ErrorRecovery.clearFaultCount();
                ReferenceManager.getReferenceManager().requestRebuildIndex(monitor);
            } else {
                Status interactive = new Status(1, "com.ibm.etools.references", Messages.userChoseToKeepIndexerDisabled);
                Logger.log(Logger.Category.REFERENCE_MANAGER, Logger.Severity.INFO, Logger.Mode.USER, (IStatus)interactive);
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public Object getSync() {
        return null;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public boolean isStarted() {
        return false;
    }
}

