/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.ReferencesPreferencesAccess;
import com.ibm.etools.references.internal.ThreadPriorityPolicy;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.ReferenceProcessor;
import com.ibm.etools.references.internal.management.WorkItemComparator;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class CreateOrUpdateMarkersJob
extends Job
implements IReferenceListener {
    private final boolean DISABLED = false;
    private final PriorityQueue<WorkItem> itemQueue = new PriorityQueue<WorkItem>(11, new WorkItemComparator());
    private int mySize = 0;
    private final ReentrantLock SYNC = new ReentrantLock();
    private volatile boolean shutdown;
    private final ReferenceProcessor processor;
    private final Set<ILink> removedLinks = new HashSet<ILink>();
    private final Set<ILink> changedLinks = new HashSet<ILink>();
    private final Set<IProject> whichProjects = Collections.synchronizedSet(new HashSet());

    public CreateOrUpdateMarkersJob(ReferenceProcessor processor) {
        super(Messages.update_broken_link_problems);
        this.processor = processor;
        ((Object)((Object)this.processor)).equals(null);
        this.setSystem(true);
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        this.setRule((ISchedulingRule)rule);
    }

    private void addItem(WorkItem item) {
        this.addItems(Collections.singleton(item));
    }

    private void addItems(Collection<WorkItem> item) {
        try {
            this.SYNC.lock();
            this.mySize += item.size();
            if (Logger.SHOULD_TRACE_MARKERS && item.size() > 0) {
                Logger.trace(Logger.Category.MARKERS, "Add items", new Throwable[0]);
                for (WorkItem workItem : item) {
                    Logger.trace(Logger.Category.MARKERS, workItem.toString(), new Throwable[0]);
                }
            }
            this.itemQueue.addAll(item);
        }
        finally {
            this.SYNC.unlock();
        }
    }

    private WorkItem getNextChange() {
        try {
            this.SYNC.lock();
            WorkItem item = this.itemQueue.poll();
            if (item != null) {
                --this.mySize;
            }
            WorkItem workItem = item;
            return workItem;
        }
        finally {
            this.SYNC.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<IProject> set = this.whichProjects;
        synchronized (set) {
            this.whichProjects.clear();
        }
        this.cancel();
        try {
            this.SYNC.lock();
            this.itemQueue.clear();
            this.mySize = 0;
            this.addItem(new WorkItem(2));
        }
        finally {
            this.SYNC.unlock();
        }
        this.doScheduleNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReferenceEvents(List<ReferenceEvent> events) {
        Set<ILink> set = this.changedLinks;
        synchronized (set) {
            for (ReferenceEvent referenceEvent : events) {
                if (referenceEvent.getKind() == ReferenceEvent.Kind.FATAL_ERROR) {
                    this.changedLinks.clear();
                    this.removedLinks.clear();
                    this.clear();
                    this.createDisabledProcessorMarker();
                    break;
                }
                if (referenceEvent.getKind() == ReferenceEvent.Kind.RESET) {
                    this.clear();
                    continue;
                }
                if (referenceEvent.getReferenceElement().getElementType() == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                    IResolvedReference resolvedReference = (IResolvedReference)referenceEvent.getReferenceElement();
                    try {
                        ILink link = resolvedReference.getSource();
                        if (link == null) continue;
                        this.changedLinks.add(link);
                    }
                    catch (RuntimeException runtimeException) {}
                    continue;
                }
                if (referenceEvent.getReferenceElement().getElementType() != IReferenceElement.ElementType.LINK || referenceEvent.getKind() != ReferenceEvent.Kind.REMOVE) continue;
                ILink link = (ILink)referenceEvent.getReferenceElement();
                this.changedLinks.add(link);
            }
        }
        if (!(this.changedLinks.isEmpty() && this.removedLinks.isEmpty() || this.processor.getActiveThread() != null)) {
            this.doSchedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushEvents() {
        Set<ILink> set = this.changedLinks;
        synchronized (set) {
            this.removedLinks.removeAll(this.changedLinks);
            if (!this.removedLinks.isEmpty() || !this.changedLinks.isEmpty()) {
                this.addLinks(this.changedLinks, this.removedLinks);
            }
            this.changedLinks.clear();
            this.removedLinks.clear();
        }
    }

    private void addLinks(Collection<ILink> changed, Set<ILink> removed) {
        WorkItem item;
        ArrayList<WorkItem> items = new ArrayList<WorkItem>(changed.size() + removed.size());
        for (ILink link : removed) {
            item = new WorkItem(10);
            item.link = link;
            item.checkProjects = true;
            items.add(item);
        }
        for (ILink link : changed) {
            item = new WorkItem(11);
            item.link = link;
            item.checkProjects = true;
            items.add(item);
        }
        this.addItems(items);
    }

    void doSchedule() {
        if (this.getState() == 0) {
            this.schedule(InternalAPI.Tweaks.MARKERS_SCHEDULE_DELAY);
        }
    }

    private void doScheduleNow() {
        if (this.getState() == 0) {
            this.schedule(0L);
        }
    }

    public boolean belongsTo(Object family) {
        return family == ReferenceManager.class || family == InternalAPI.MARKERS_FAMILY;
    }

    protected IStatus run(IProgressMonitor monitor) {
        final IStatus[] status = new IStatus[]{Status.CANCEL_STATUS};
        IWorkspace space = ResourcesPlugin.getWorkspace();
        if (space != null) {
            try {
                space.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        status[0] = CreateOrUpdateMarkersJob.this.runInWorkspace(monitor);
                    }
                }, this.getRule(), 1, monitor);
            }
            catch (CoreException e) {
                status[0] = e.getStatus();
            }
        }
        return status[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        HashSet<IProject> localWhichProjects;
        if (this.shutdown) {
            return Status.OK_STATUS;
        }
        if (Logger.SHOULD_TRACE_MARKERS) {
            Logger.trace(Logger.Category.MARKERS, "Markers job running", new Throwable[0]);
        }
        this.flushEvents();
        SubMonitor root = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.updating, (int)(this.mySize + 1));
        int maxMarkers = ReferencesPreferencesAccess.INSTANCE.getMaxProblems();
        int severity = ReferenceManager.getReferenceManager().getBrokenLinkSeverity();
        Set<IProject> set = this.whichProjects;
        synchronized (set) {
            localWhichProjects = new HashSet<IProject>(this.whichProjects);
        }
        ArrayList<WorkItem> putBack = new ArrayList<WorkItem>();
        MarkerCount count = null;
        try {
            try {
                count = new MarkerCount((IProgressMonitor)root.newChild(1));
                ThreadPriorityPolicy.setMinimumPriority(this.getThread());
                SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
                WorkItem item = this.getNextChange();
                while (item != null) {
                    block56: {
                        try {
                            root.setWorkRemaining(this.mySize);
                            String path = "";
                            if (item.link != null) {
                                if (item.type != 5 && item.type != 4 && item.type != 10 && item.type != 11 && !item.link.isValid()) break block56;
                                try {
                                    path = item.link.getPath().toString();
                                }
                                catch (RuntimeException runtimeException) {
                                    break block56;
                                }
                            }
                            root.subTask(path);
                            boolean skip = false;
                            if (item.checkProjects && item.type == 11) {
                                if (item.brokenreference != null) {
                                    if (item.brokenreference.getSource() != null && item.brokenreference.getSource().isValid() && item.brokenreference.getResource() != null && !localWhichProjects.contains(item.brokenreference.getResource().getProject())) {
                                        if (Logger.SHOULD_TRACE_MARKERS) {
                                            Logger.trace(Logger.Category.MARKERS, "Skip: " + item, new Throwable[0]);
                                        }
                                        putBack.add(item);
                                        skip = true;
                                    }
                                } else if (item.link != null) {
                                    if (item.link.isValid() && item.link.getContainer() != null && !localWhichProjects.contains(item.link.getContainer().getResource().getProject())) {
                                        if (Logger.SHOULD_TRACE_MARKERS) {
                                            Logger.trace(Logger.Category.MARKERS, "Skip: " + item, new Throwable[0]);
                                        }
                                        putBack.add(item);
                                        skip = true;
                                    }
                                } else if (item.resource != null && !localWhichProjects.contains(item.resource.getProject())) {
                                    if (Logger.SHOULD_TRACE_MARKERS) {
                                        Logger.trace(Logger.Category.MARKERS, "Skip: " + item, new Throwable[0]);
                                    }
                                    putBack.add(item);
                                    skip = true;
                                }
                            }
                            if (!skip) {
                                this.processItem(item, count, maxMarkers, severity, (IProgressMonitor)root.newChild(1));
                            }
                            if (root.isCanceled()) {
                                break;
                            }
                        }
                        catch (RuntimeException e) {
                            InternalAPI.handleContributionException(Messages.errorMsg_error_while_updating_link_problem_markers, "com.ibm.etools.references", e, EnumSet.of(ErrorEvent.PresentationHints.LOG));
                        }
                    }
                    item = this.getNextChange();
                }
                if (!putBack.isEmpty()) {
                    this.addItems(putBack);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                if (!localWhichProjects.isEmpty()) {
                    boolean hasChanges = this.hasChanges();
                    if (hasChanges) {
                        if (this.processor.getActiveThread() == null) {
                            this.schedule(InternalAPI.Tweaks.MARKERS_SCHEDULE_DELAY);
                        }
                    } else if (this.processor.getActiveThread() == null) {
                        Set<IProject> set2 = this.whichProjects;
                        synchronized (set2) {
                            this.whichProjects.removeAll(localWhichProjects);
                        }
                    }
                }
                if (count != null) {
                    count.save();
                }
                SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
                root.done();
                return iStatus;
            }
        }
        catch (Throwable throwable) {
            if (!localWhichProjects.isEmpty()) {
                boolean hasChanges = this.hasChanges();
                if (hasChanges) {
                    if (this.processor.getActiveThread() == null) {
                        this.schedule(InternalAPI.Tweaks.MARKERS_SCHEDULE_DELAY);
                    }
                } else if (this.processor.getActiveThread() == null) {
                    Set<IProject> set3 = this.whichProjects;
                    synchronized (set3) {
                        this.whichProjects.removeAll(localWhichProjects);
                    }
                }
            }
            if (count != null) {
                count.save();
            }
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            root.done();
            throw throwable;
        }
        if (!localWhichProjects.isEmpty()) {
            boolean hasChanges = this.hasChanges();
            if (hasChanges) {
                if (this.processor.getActiveThread() == null) {
                    this.schedule(InternalAPI.Tweaks.MARKERS_SCHEDULE_DELAY);
                }
            } else if (this.processor.getActiveThread() == null) {
                Set<IProject> set4 = this.whichProjects;
                synchronized (set4) {
                    this.whichProjects.removeAll(localWhichProjects);
                }
            }
        }
        if (count != null) {
            count.save();
        }
        SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        root.done();
        return Status.OK_STATUS;
    }

    private void processItem(WorkItem item, MarkerCount count, int maxMarkers, int severity, IProgressMonitor monitor) throws CoreException {
        block42: {
            ILink link;
            SubMonitor mon;
            SubMonitor root;
            block43: {
                block44: {
                    block45: {
                        boolean createMarkers;
                        if (Logger.SHOULD_TRACE_MARKERS) {
                            Logger.trace(Logger.Category.MARKERS, "Processing: " + item, new Throwable[0]);
                        }
                        root = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                        root.beginTask("", 1);
                        mon = root.newChild(1, 7);
                        link = item.link;
                        if (item.type != 11) break block43;
                        if (ReferenceManager.getReferenceManager().hasFatalError()) {
                            return;
                        }
                        InternalAPI.AnnotationModelDocumentPair model = null;
                        if (link.getContainer() == null) {
                            return;
                        }
                        if (link.getContainer().getResource().getType() == 1) {
                            InternalAPI.AbstractAnnotationModelDocumentProvider listener = ReferenceManager.getReferenceManager().getAnnotationModelDocumentProvider();
                            model = listener.getAnnotationModel((IFile)link.getContainer().getResource());
                        }
                        boolean bl = model == null ? true : (createMarkers = !model.getBuffer().isDirty());
                        if (!createMarkers) break block44;
                        mon.beginTask("", 3);
                        count.decrement(this.deleteMarkerFor(link, (IProgressMonitor)mon.newChild(1)));
                        if (!link.isValid()) break block45;
                        try {
                            Collection<BrokenReference> refs = link.findBrokenReferences((IProgressMonitor)mon.newChild(1));
                            if (Logger.SHOULD_TRACE_MARKERS && refs.isEmpty()) {
                                Logger.trace(Logger.Category.MARKERS, "No broken refs: " + link, new Throwable[0]);
                            }
                            SubMonitor create = mon.newChild(1);
                            create.beginTask("", refs.size());
                            for (BrokenReference ref : refs) {
                                IMarker marker2;
                                if ((maxMarkers < 0 || count.getCount() < maxMarkers) && (marker2 = this.createMarker(ref, severity)) != null) {
                                    count.increment(1);
                                }
                                create.worked(1);
                            }
                            break block42;
                        }
                        catch (ReferenceException referenceException) {}
                        break block42;
                    }
                    if (!Logger.SHOULD_TRACE_MARKERS) break block42;
                    Logger.trace(Logger.Category.MARKERS, "Link not valid, skipping create new markers: " + ((InternalReferenceObject)((Object)link)).getRecord(), new Throwable[0]);
                    break block42;
                }
                if (Logger.SHOULD_TRACE_MARKERS) {
                    Logger.trace(Logger.Category.MARKERS, "Model is dirty, not creating new markers: " + link, new Throwable[0]);
                }
                mon.worked(1);
                break block42;
            }
            if (item.type == 10) {
                boolean createMarkers;
                if (ReferenceManager.getReferenceManager().hasFatalError()) {
                    return;
                }
                InternalAPI.AnnotationModelDocumentPair model = null;
                if (link.getContainer() == null) {
                    return;
                }
                if (link.getContainer() != null && link.getContainer().getResource().getType() == 1) {
                    InternalAPI.AbstractAnnotationModelDocumentProvider listener = ReferenceManager.getReferenceManager().getAnnotationModelDocumentProvider();
                    model = listener.getAnnotationModel((IFile)link.getContainer().getResource());
                }
                boolean bl = model == null ? true : (createMarkers = !model.getBuffer().isDirty());
                if (createMarkers) {
                    count.decrement(this.deleteMarkerFor(link, (IProgressMonitor)mon));
                } else {
                    mon.worked(1);
                }
            } else if (item.type == 4) {
                count.decrement(this.deleteMarkerFor(item.resource, (IProgressMonitor)mon));
            } else if (item.type == 5) {
                BrokenReference reference = item.brokenreference;
                if (reference == null) {
                    count.decrement(this.deleteMarkerFor(item.link, (IProgressMonitor)mon));
                } else {
                    count.decrement(this.deleteMarkerFor(reference.getSource(), (IProgressMonitor)mon));
                }
            } else if (item.type == 6) {
                IMarker marker;
                if (ReferenceManager.getReferenceManager().hasFatalError()) {
                    return;
                }
                BrokenReference reference = item.brokenreference;
                if ((maxMarkers < 0 || count.getCount() < maxMarkers) && (marker = this.createMarker(reference, severity)) != null) {
                    count.increment(1);
                }
            } else if (item.type == 1) {
                this.whichProjects.clear();
                IMarker marker = null;
                try {
                    String DISABLED = "disabled_framework_marker";
                    IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
                    IMarker[] markers = resource.findMarkers("com.ibm.etools.references.linkmarker", false, 0);
                    boolean found = false;
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int marker2 = 0;
                    while (marker2 < n) {
                        IMarker m = iMarkerArray[marker2];
                        if (m.getAttribute(DISABLED) != null) {
                            found = true;
                            break;
                        }
                        ++marker2;
                    }
                    if (!found) {
                        String completeBrokenText = Messages.errorMsg_Links_indexer_diabled_marker_text;
                        marker = resource.createMarker("com.ibm.etools.references.linkmarker");
                        marker.setAttribute(DISABLED, true);
                        marker.setAttribute("message", (Object)completeBrokenText);
                        marker.setAttribute("severity", 2);
                        count.increment(1);
                    }
                }
                catch (CoreException coreException) {}
            } else if (item.type == 2) {
                this.whichProjects.clear();
                count.set(0);
                this.removeAll((IProgressMonitor)mon);
            } else if (item.type == 12) {
                this.whichProjects.clear();
                count.set(0);
                root.subTask(Messages.CreateOrUpdateMarkersJob_AllMarkersBroken);
                mon.beginTask("", 3);
                this.removeAll((IProgressMonitor)mon.newChild(1));
                if (ReferenceManager.getReferenceManager().hasFatalError()) {
                    this.createDisabledProcessorMarker();
                    return;
                }
                SearchEngine engine = new SearchEngine();
                SearchScope scope = SearchEngine.createWorkspaceScope();
                SearchPattern pattern = SearchPattern.createWildcardPattern();
                DefaultSearchRequestor req = new DefaultSearchRequestor();
                engine.search(pattern, scope, req, (IProgressMonitor)mon.newChild(1));
                Set matches = req.getMatches();
                SubMonitor create = mon.newChild(1);
                create.beginTask("", matches.size());
                for (ILink match : matches) {
                    try {
                        if (!match.isValid()) continue;
                        Collection<BrokenReference> refs = match.findBrokenReferences((IProgressMonitor)create.newChild(1));
                        for (BrokenReference ref : refs) {
                            IMarker marker;
                            if (maxMarkers >= 0 && count.getCount() >= maxMarkers || (marker = this.createMarker(ref, severity)) == null) continue;
                            count.increment(1);
                        }
                    }
                    catch (ReferenceException referenceException) {}
                }
            }
        }
    }

    public void createMarkersFor(List<BrokenReference> references) {
        HashSet<IResource> resources = new HashSet<IResource>();
        ArrayList<WorkItem> items = new ArrayList<WorkItem>();
        for (BrokenReference brokenReference : references) {
            resources.add(brokenReference.getResource());
            WorkItem item = new WorkItem(6);
            item.checkProjects = true;
            item.brokenreference = brokenReference;
            items.add(item);
        }
        if (!items.isEmpty()) {
            try {
                this.SYNC.lock();
                this.itemQueue.addAll(items);
                this.mySize += items.size();
            }
            finally {
                this.SYNC.unlock();
            }
            this.doSchedule();
        }
    }

    public void removeMarkersFor(IFile file) {
        WorkItem item = new WorkItem(4);
        item.resource = file;
        item.checkProjects = true;
        this.addItem(item);
    }

    public void removeMarkersForLinks(List<ILink> links) {
        ArrayList<WorkItem> items = new ArrayList<WorkItem>();
        for (ILink link : links) {
            WorkItem item = new WorkItem(5);
            item.link = link;
            item.checkProjects = true;
            items.add(item);
        }
        this.addItems(items);
    }

    public void removeMarkersFor(List<BrokenReference> references) {
        ArrayList<WorkItem> items = new ArrayList<WorkItem>();
        for (BrokenReference brokenReference : references) {
            WorkItem item = new WorkItem(5);
            item.checkProjects = true;
            item.brokenreference = brokenReference;
            items.add(item);
        }
        this.addItems(items);
    }

    private IMarker[] removeAll(IProgressMonitor monitor) throws CoreException {
        IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.etools.references.linkmarker", false, 2);
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.delete(marker);
            mon.worked(1);
            ++n2;
        }
        return markers;
    }

    private void delete(IMarker marker) {
        if (Logger.SHOULD_TRACE_MARKERS) {
            String out = "";
            try {
                Map map = marker.getAttributes();
                for (Map.Entry entry : map.entrySet()) {
                    out = String.valueOf(out) + entry.getKey();
                    out = String.valueOf(out) + "=";
                    out = String.valueOf(out) + entry.getValue();
                    out = String.valueOf(out) + ",";
                }
            }
            catch (CoreException e) {
                out = String.valueOf(out) + e.getMessage();
            }
            Logger.trace(Logger.Category.MARKERS, "Delete marker: " + out, new Throwable[0]);
        }
        try {
            marker.delete();
        }
        catch (CoreException coreException) {}
    }

    private int deleteMarkerFor(ILink link, IProgressMonitor monitor) {
        int count = 0;
        try {
            if (link == null || link.getContainer() == null) {
                return count;
            }
            IMarker[] markers = link.getContainer().getResource().findMarkers("com.ibm.etools.references.linkmarker", false, 0);
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)markers.length);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                try {
                    Integer integer = (Integer)marker.getAttribute("refId");
                    if (integer != null && integer.intValue() == link.getId()) {
                        this.delete(marker);
                        ++count;
                    }
                }
                catch (CoreException coreException) {}
                mon.worked(1);
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return count;
    }

    private int deleteMarkerFor(IResource resource, IProgressMonitor monitor) {
        int count = 0;
        try {
            IMarker[] markers = resource.findMarkers("com.ibm.etools.references.linkmarker", false, 0);
            count = markers.length;
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)markers.length);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                this.delete(marker);
                mon.worked(1);
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return count;
    }

    private IMarker createMarker(BrokenReference ref, int severity) {
        IResource resource;
        IMarker marker = null;
        if (ref.getSource().isValid() && !ref.getSource().getSpecializedType().isInternal() && severity != 0 && (resource = ref.getResource()).exists()) {
            try {
                String completeBrokenText = NLS.bind((String)Messages.errorMsg_broken_link_x_marker_text, (Object)ref.getDescription());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("message", completeBrokenText);
                map.put("lineNumber", ref.getBrokenReferenceRange().getLinenumber());
                map.put("charStart", ref.getBrokenReferenceRange().getOffset());
                map.put("charEnd", ref.getBrokenReferenceRange().getOffset() + ref.getBrokenReferenceRange().getLength());
                map.put("severity", severity);
                map.put("refId", ref.getSource().getId());
                map.put("brokenResolvedReferenceId", ref.getBrokenResolvedReferenceId());
                map.put("brokenText", ref.getBrokenText());
                StringBuilder builder = new StringBuilder();
                List<IResolvedReference> refs = ref.getPotentialTargets();
                Iterator<IResolvedReference> iterator = refs.iterator();
                while (iterator.hasNext()) {
                    IResolvedReference rr = iterator.next();
                    if (!(rr instanceof InternalReferenceObject)) continue;
                    int providerId = ((InternalReferenceObject)((Object)rr)).getProviderId();
                    builder.append(providerId);
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
                map.put("providerIds", builder.toString());
                marker = resource.createMarker("com.ibm.etools.references.linkmarker");
                if (Logger.SHOULD_TRACE_MARKERS) {
                    String out = "";
                    for (Map.Entry entry : map.entrySet()) {
                        out = String.valueOf(out) + entry.getKey();
                        out = String.valueOf(out) + "=";
                        out = String.valueOf(out) + entry.getValue();
                        out = String.valueOf(out) + ",";
                    }
                    Logger.trace(Logger.Category.MARKERS, "Created marker: " + out, new Throwable[0]);
                }
                marker.setAttributes(map);
            }
            catch (CoreException coreException) {
            }
            catch (RuntimeException e) {
                Logger.logException(Messages.CreateOrUpdateMarkersJob_11, e);
            }
        }
        return marker;
    }

    public boolean shouldRun() {
        return this.hasWork();
    }

    public boolean shouldSchedule() {
        return this.hasWork();
    }

    private boolean hasWork() {
        return !this.shutdown && (this.hasChanges() || !this.whichProjects.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasChanges() {
        boolean hasPendingChanges;
        int s;
        try {
            this.SYNC.lock();
            s = this.mySize;
        }
        finally {
            this.SYNC.unlock();
        }
        if (s > 0) {
            return true;
        }
        Set<ILink> set = this.changedLinks;
        synchronized (set) {
            hasPendingChanges = !this.changedLinks.isEmpty() || !this.removedLinks.isEmpty();
        }
        return hasPendingChanges;
    }

    public void shutdown() {
        this.shutdown = true;
        this.cancel();
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void rebuildAllMarkers() {
        WorkItem item = new WorkItem(12);
        this.addItem(item);
        this.doScheduleNow();
    }

    public void createDisabledProcessorMarker() {
        WorkItem item = new WorkItem(1);
        this.addItem(item);
        this.doScheduleNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePendingMarkersForProject(IProject project) {
        if (Logger.SHOULD_TRACE_MARKERS) {
            Logger.trace(Logger.Category.MARKERS, "Release pending markers for: " + project, new Throwable[0]);
        }
        Set<IProject> set = this.whichProjects;
        synchronized (set) {
            this.whichProjects.add(project);
        }
        this.schedule(0L);
    }

    private class MarkerCount {
        int count;

        public MarkerCount(IProgressMonitor monitor) {
            try {
                this.count = Integer.parseInt(ReferenceDatabase.getDefault().readValue("marker", "count", monitor));
            }
            catch (Exception exception) {
                this.count = 0;
            }
        }

        public void save() {
            try {
                ReferenceDatabase.getDefault().storeValue("marker", "count", Integer.toString(this.count));
            }
            catch (Exception e) {
                Logger.logException(Messages.CreateOrUpdateMarkersJob_10, e);
            }
        }

        public int increment(int number) {
            this.count += number;
            return this.count;
        }

        public int decrement(int number) {
            this.count -= number;
            return this.count;
        }

        public int getCount() {
            return this.count;
        }

        public void set(int i) {
            this.count = i;
        }
    }

    static class WorkItem
    implements IAdaptable {
        public static final int CREATED_DISABLED_MARKER = 1;
        public static final int REMOVE_ALL = 2;
        public static final int UPDATE_ALL = 12;
        public static final int REMOVE_FILE_MARKERS = 4;
        public static final int REMOVE_MARKER = 5;
        public static final int CREATE_MARKER = 6;
        public static final int REMOVED = 10;
        public static final int CHANGED = 11;
        public ILink link;
        public int type;
        public BrokenReference brokenreference;
        public IResource resource;
        public boolean checkProjects = false;

        public WorkItem(int type) {
            this.type = type;
        }

        public String toString() {
            String string = "";
            if (this.type == 1) {
                string = String.valueOf(string) + "CREATED_DISABLED_MARKER";
            } else if (this.type == 2) {
                string = String.valueOf(string) + "REMOVE_ALL";
            } else if (this.type == 12) {
                string = String.valueOf(string) + "UPDATE_ALL";
            } else if (this.type == 5) {
                string = String.valueOf(string) + "REMOVE_MARKER";
            } else if (this.type == 4) {
                string = String.valueOf(string) + "REMOVE_FILE_MARKERS";
            } else if (this.type == 6) {
                string = String.valueOf(string) + "CREATE_MARKER";
            } else if (this.type == 10) {
                string = String.valueOf(string) + "REMOVED";
            } else if (this.type == 11) {
                string = String.valueOf(string) + "CHANGED";
            }
            string = String.valueOf(string) + " Link: " + this.link + " Resource: " + this.resource;
            return string;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.brokenreference == null ? 0 : this.brokenreference.hashCode());
            result = 31 * result + (this.link == null ? 0 : this.link.hashCode());
            result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WorkItem other = (WorkItem)obj;
            if (this.brokenreference == null ? other.brokenreference != null : !this.brokenreference.equals(other.brokenreference)) {
                return false;
            }
            if (this.link == null ? other.link != null : !this.link.equals(other.link)) {
                return false;
            }
            if (this.resource == null ? other.resource != null : !this.resource.equals((Object)other.resource)) {
                return false;
            }
            return this.type == other.type;
        }

        public Object getAdapter(Class adapter) {
            try {
                if (adapter == IResource.class) {
                    LinkNode<IResource> node;
                    if (this.resource != null) {
                        return this.resource;
                    }
                    if (this.link != null && (node = this.link.getContainer()) != null) {
                        return node.getResource();
                    }
                }
                return null;
            }
            catch (RuntimeException e) {
                Logger.logException("Exception retrieving adapter: " + adapter.getCanonicalName() + " for " + this.link, e);
                return null;
            }
        }
    }
}

