/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index.keys;

import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.index.keys.StringIntPairComparatorForLinkKey;
import com.ibm.etools.references.management.IReferenceElement;
import java.nio.ByteBuffer;
import java.util.Comparator;

public class StringIntLinkKey
extends LinkKey
implements Cloneable {
    protected String stringValue;
    protected int intValue;

    StringIntLinkKey(IndexConstants keyType, IReferenceElement.ElementType linkType) {
        super(keyType, linkType);
    }

    public void setStringIntValue(String stringValue, int intValue) {
        this.stringValue = stringValue;
        this.intValue = intValue;
    }

    @Override
    public LinkKey getMaximumValueKey() {
        try {
            StringIntLinkKey key = (StringIntLinkKey)this.clone();
            key.stringValue = this.stringValue;
            key.intValue = Integer.MAX_VALUE;
            return key;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LinkKey getMaximumPrefixKey() {
        try {
            if (this.stringValue != null) {
                StringIntLinkKey key = (StringIntLinkKey)this.clone();
                StringBuilder b = new StringBuilder();
                b.append(this.stringValue);
                b.append('\uffff');
                key.stringValue = b.toString();
                key.intValue = Integer.MAX_VALUE;
                return key;
            }
            return this;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getMatchableValue() {
        return this.stringValue;
    }

    @Override
    public void readKeyData(PooledByteBuffer buffer) {
        this.stringValue = ByteUtils.bytesToString(buffer.buffer);
        this.intValue = ByteUtils.bytesToInt(buffer.buffer);
        buffer.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeKeyData() {
        ByteBuffer buffer = ByteUtils.stringToBytes(this.stringValue);
        buffer.rewind();
        PooledByteBuffer buf = PooledByteBuffer.INSTANCE.leaseByteBuffer(buffer.limit() + 4);
        buf.buffer.put(buffer);
        buf.buffer.put(ByteUtils.intToBytes(this.intValue));
        buf.buffer.rewind();
        return buf;
    }

    public int compareTo(Key o) {
        if (this == o) {
            return 0;
        }
        StringIntLinkKey other = (StringIntLinkKey)o;
        if (this.stringValue == null && other.stringValue != null) {
            return -1;
        }
        if (this.stringValue == null && other.stringValue == null) {
            return 0;
        }
        if (this.stringValue != null && other.stringValue == null) {
            return 1;
        }
        int compareto = this.stringValue.compareTo(other.stringValue);
        if (compareto == 0) {
            if (this.intValue == -1 && other.intValue != -1) {
                return -1;
            }
            if (this.intValue == -1 && other.intValue == -1) {
                return 0;
            }
            if (this.intValue != -1 && other.intValue == -1) {
                return 1;
            }
            compareto = this.intValue - other.intValue;
        }
        return compareto;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " S[ " + this.stringValue + " ] I[ " + this.intValue + " ]";
    }

    public void setIntValue(int newValue) {
        this.intValue = newValue;
    }

    @Override
    public Comparator<LinkKey> defaultComparator() {
        return new StringIntPairComparatorForLinkKey();
    }
}

