/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index.keys;

import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.index.keys.StringIntPairComparatorForLinkKey;
import com.ibm.etools.references.management.IReferenceElement;
import java.nio.ByteBuffer;
import java.util.Comparator;

public class StringIntIntKey
extends LinkKey {
    String stringValue;
    int id1;
    int id2;

    public StringIntIntKey(IndexConstants keyType, IReferenceElement.ElementType linkType) {
        super(keyType, linkType);
    }

    public StringIntIntKey(String indexName) {
        super(indexName);
    }

    public void setStringIntInt(String stringValue, int id1, int id2) {
        this.stringValue = stringValue;
        this.id1 = id1;
        this.id2 = id2;
    }

    @Override
    public LinkKey getMaximumValueKey() {
        if (this.stringValue != null && this.stringValue.endsWith("/")) {
            StringIntIntKey key = new StringIntIntKey(this.getIndexName());
            StringBuilder b = new StringBuilder();
            b.append(this.stringValue);
            b.append('\uffff');
            key.stringValue = b.toString();
            key.id1 = Integer.MAX_VALUE;
            key.id2 = Integer.MAX_VALUE;
            return key;
        }
        return this.getMaximumPrefixKey();
    }

    @Override
    public LinkKey getMaximumPrefixKey() {
        StringIntIntKey key = new StringIntIntKey(this.getIndexName());
        StringBuilder b = new StringBuilder();
        b.append(this.stringValue);
        key.stringValue = b.toString();
        key.id1 = Integer.MAX_VALUE;
        key.id2 = Integer.MAX_VALUE;
        return key;
    }

    public String getString() {
        return this.stringValue;
    }

    public int getInt1() {
        return this.id1;
    }

    public int getInt2() {
        return this.id2;
    }

    @Override
    public Object getMatchableValue() {
        return this.id1;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "S[ " + this.stringValue + "] I1[ " + this.id1 + " ]  I2[ " + this.id2 + " ]";
    }

    @Override
    public void readKeyData(PooledByteBuffer buffer) {
        this.stringValue = ByteUtils.bytesToString(buffer.buffer);
        this.id1 = ByteUtils.bytesToInt(buffer.buffer);
        this.id2 = ByteUtils.bytesToInt(buffer.buffer);
        buffer.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeKeyData() {
        ByteBuffer s = ByteUtils.stringToBytes(this.stringValue);
        PooledByteBuffer buffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(8 + s.limit());
        buffer.buffer.put(s);
        buffer.buffer.put(ByteUtils.intToBytes(this.id1));
        buffer.buffer.put(ByteUtils.intToBytes(this.id2));
        buffer.buffer.rewind();
        return buffer;
    }

    @Override
    public Comparator<LinkKey> defaultComparator() {
        return new StringIntPairComparatorForLinkKey();
    }
}

