/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index.keys;

import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.keys.IntStringIntComparatorForLinkKey;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.management.IReferenceElement;
import java.nio.ByteBuffer;
import java.util.Comparator;

public class IntStringIntKey
extends LinkKey {
    int id1;
    String stringValue;
    int id2;

    public IntStringIntKey(IndexConstants keyType, IReferenceElement.ElementType linkType) {
        super(keyType, linkType);
    }

    public IntStringIntKey(String indexName) {
        super(indexName);
    }

    public void setIntStringInt(int id1, String stringValue, int id2) {
        this.id1 = id1;
        this.stringValue = stringValue;
        this.id2 = id2;
    }

    @Override
    public LinkKey getMaximumValueKey() {
        return this.getMaximumPrefixKey();
    }

    @Override
    public LinkKey getMaximumPrefixKey() {
        String s = null;
        if (this.stringValue != null && this.stringValue.endsWith("/")) {
            StringBuilder b = new StringBuilder();
            b.append(this.stringValue);
            b.append('\uffff');
            s = b.toString();
        } else {
            s = this.stringValue;
        }
        IntStringIntKey key = new IntStringIntKey(this.getIndexName());
        key.id1 = this.id1;
        key.stringValue = s;
        key.id2 = Integer.MAX_VALUE;
        return key;
    }

    public int getInt1() {
        return this.id1;
    }

    public String getString() {
        return this.stringValue;
    }

    public int getInt2() {
        return this.id2;
    }

    @Override
    public Object getMatchableValue() {
        return this.id1;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getIndexName()) + " I1[ " + this.id1 + " ] S[ " + this.stringValue + "] I2[ " + this.id2 + " ]";
    }

    @Override
    public void readKeyData(PooledByteBuffer buffer) {
        this.id1 = ByteUtils.bytesToInt(buffer.buffer);
        this.stringValue = ByteUtils.bytesToString(buffer.buffer);
        this.id2 = ByteUtils.bytesToInt(buffer.buffer);
        buffer.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeKeyData() {
        ByteBuffer s = ByteUtils.stringToBytes(this.stringValue);
        PooledByteBuffer buffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(8 + s.limit());
        buffer.buffer.put(ByteUtils.intToBytes(this.id1));
        buffer.buffer.put(s);
        buffer.buffer.put(ByteUtils.intToBytes(this.id2));
        buffer.buffer.rewind();
        return buffer;
    }

    @Override
    public Comparator<LinkKey> defaultComparator() {
        return new IntStringIntComparatorForLinkKey();
    }
}

