/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index.keys;

import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.KeyInfo;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Comparator;

public class IntStringIntComparator
implements Comparator<KeyInfo> {
    @Override
    public int compare(KeyInfo k1info, KeyInfo k2info) {
        int k2size;
        int k1size;
        ByteBuffer key2;
        ByteBuffer key1 = k1info.getActual();
        int compareTo = this.compareInts(key1, key2 = k2info.getActual());
        if (compareTo == 0 && (compareTo = this.compareStrings(key1, k1size = ByteUtils.bytesToUnsignedShort(key1), key2, k2size = ByteUtils.bytesToUnsignedShort(key2))) == 0) {
            compareTo = this.compareInts(key1, k1size, 4, key2, k2size, 4);
        }
        return compareTo;
    }

    public int compareStrings(ByteBuffer key1, int k1size, ByteBuffer key2, int k2size) {
        int lim = Math.min(k1size, k2size);
        CharBuffer k1buf = key1.asCharBuffer();
        CharBuffer k2buf = key2.asCharBuffer();
        int k = 0;
        while (k < lim) {
            char k2c;
            char k1c = k1buf.get();
            if (k1c != (k2c = k2buf.get())) {
                return k1c - k2c;
            }
            ++k;
        }
        return k1size - k2size;
    }

    public int compareInts(ByteBuffer key1, int k1size, int k1offset, ByteBuffer key2, int k2size, int k2offset) {
        key1.position(2 + Math.max(0, k1size * 2) + k1offset);
        key2.position(2 + Math.max(0, k2size * 2) + k2offset);
        return this.compareInts(key1, key2);
    }

    public int compareInts(ByteBuffer key1, ByteBuffer key2) {
        int k1int = key1.getInt();
        int k2int = key2.getInt();
        if (k1int == -1 && k2int != -1) {
            return -1;
        }
        if (k1int == -1 && k2int == -1) {
            return 0;
        }
        if (k1int != -1 && k2int == -1) {
            return 1;
        }
        return k1int < k2int ? -1 : (k1int == k2int ? 0 : 1);
    }
}

