/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.DBRecordFactory;
import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.IntFileHeader;
import com.ibm.etools.references.internal.index.EventCollector;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.PropertyStore;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.ConvertIndexesJob;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.management.SavedLinkNodes;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.InternalSearchEngine;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ReferenceDatabase {
    private static final int MEM_INDEX_MIN_THRESHOLD = InternalAPI.Tweaks.INDEX_MIN_THRESHOLD;
    private static final int MEM_INDEX_MAX_THRESHOLD = InternalAPI.Tweaks.INDEX_MAX_THRESHOLD;
    private static final int MEM_DB_SIZE_THRESHOLD = InternalAPI.Tweaks.INDEX_MAX_DBSIZE_THRESHOLD;
    private static ReferenceDatabase INSTANCE = new ReferenceDatabase();
    public static final CountDownLatch READY_LATCH = new CountDownLatch(1);
    private ExtentManager db = null;
    private ReferenceRecordFactory referenceFactory = null;
    private final List<FileHeader> headers;
    private final ConvertIndexesJob convertIndexesJob = new ConvertIndexesJob(this);
    private final Future<?> init;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock write = this.rwlock.writeLock();
    private final ReentrantReadWriteLock.ReadLock read = this.rwlock.readLock();
    private int lastSize;

    public static ReferenceDatabase getDefault() {
        return INSTANCE;
    }

    private ReferenceDatabase() throws FatalIOException {
        this.headers = this.createHeaders();
        this.init = InternalAPI.getExecutor().submit(new Init(), null);
    }

    private void init() {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                this.init.get();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new RuntimeException(t);
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void loadHeaders(List<FileHeader> headers) {
    }

    private void saveHeaders() {
    }

    private int getSavedInfoId() {
        return ((IntFileHeader)this.headers.get(0)).getHeaderValue();
    }

    private int getPropertyStoreId() {
        return ((IntFileHeader)this.headers.get(1)).getHeaderValue();
    }

    private int getRefDBSize() {
        return ((IntFileHeader)this.headers.get(2)).getHeaderValue();
    }

    private List<FileHeader> createHeaders() {
        IntFileHeader header = new IntFileHeader("RefDB saved link nodes id", 65535);
        IntFileHeader propStoreId = new IntFileHeader("RefDB property store id", 65535);
        IntFileHeader size = new IntFileHeader("RefDB size", 0);
        ArrayList<FileHeader> headers = new ArrayList<FileHeader>();
        Collections.addAll(headers, header, propStoreId, size);
        return headers;
    }

    private void initHeaders() {
        ((IntFileHeader)this.headers.get(0)).reset();
        ((IntFileHeader)this.headers.get(1)).reset();
        ((IntFileHeader)this.headers.get(2)).reset();
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream stream) {
        this.init();
        try {
            this.read.lock();
            stream.println("=== Dumping sorted list of all artifacts");
            List<Integer> integers = this.db.debugGetRecIds();
            Collections.sort(integers);
            for (Integer id : integers) {
                InternalReferenceRecord element = this.getInternalReferenceRecord(id);
                if (element != null) {
                    stream.println(element.toString());
                    continue;
                }
                stream.println("Could not find element with id: " + id);
            }
            stream.println("=== Dumping low level extent store");
            this.db.debugPrintRecords(stream);
        }
        finally {
            this.read.unlock();
        }
    }

    public void addOrUpdateArtifact(IReferenceElement artifact, EventCollector collector) throws ReferenceException {
        InternalReferenceObject refObject;
        this.init();
        if (artifact instanceof InternalReferenceObject && (refObject = (InternalReferenceObject)artifact).getRecord().isDirty()) {
            IdentityHashMap<Object, Object> markers = new IdentityHashMap<Object, Object>();
            IdentityLinkedSet<InternalReferenceObject> graph = new IdentityLinkedSet<InternalReferenceObject>();
            refObject.getObjectGraph(graph, markers);
            try {
                this.write.lock();
                this.assignAndUpdate(collector, refObject, graph.getList());
            }
            finally {
                this.write.unlock();
            }
        }
    }

    private void assignAndUpdate(EventCollector collector, InternalReferenceObject refObject, List<InternalReferenceObject> objList) {
        IdentityHashMap<InternalReferenceObject, ReferenceEvent> events = new IdentityHashMap<InternalReferenceObject, ReferenceEvent>();
        if (!refObject.getRecord().isDeleted()) {
            for (InternalReferenceObject graphObject : objList) {
                this.dbAssignIds(graphObject, events);
            }
            for (InternalReferenceObject graphObject : objList) {
                this.dbUpdateRecord(graphObject, collector, events);
            }
        }
    }

    private void dbAssignIds(InternalReferenceObject graphObject, IdentityHashMap<InternalReferenceObject, ReferenceEvent> events) throws ReferenceException {
        this.init();
        ReferenceEvent event = null;
        if (graphObject.getRecord().getId() == -1) {
            event = new ReferenceEvent(graphObject, ReferenceEvent.Kind.ADD);
            try {
                this.db.assignId(graphObject.getRecord());
            }
            catch (RuntimeException e) {
                IStatus status = this.createStatus("Could not assign id to new record: ", graphObject, e);
                throw new ReferenceException(status);
            }
        } else {
            event = new ReferenceEvent(graphObject, ReferenceEvent.Kind.CHANGE);
        }
        events.put(graphObject, event);
    }

    private IStatus createStatus(String errorString, InternalReferenceObject graphObject, RuntimeException e) {
        String eString = String.valueOf(errorString) + (graphObject == null ? "" : graphObject.getRecord());
        Status status = new Status(4, "com.ibm.etools.references", eString, (Throwable)e);
        return status;
    }

    private void dbUpdateRecord(IReferenceElement artifact, EventCollector collector, IdentityHashMap<InternalReferenceObject, ReferenceEvent> events) throws ReferenceException {
        this.init();
        ReferenceEvent event = events.get(artifact);
        InternalReferenceRecord record = ((InternalReferenceObject)artifact).getRecord();
        List<LinkKey> originalKeys = ((InternalReferenceObject)artifact).getOriginalKeys();
        try {
            try {
                this.write.lock();
                if (originalKeys != null) {
                    Assert.isTrue((event.getKind() == ReferenceEvent.Kind.CHANGE ? 1 : 0) != 0, (String)"Contract violation: getOriginalKeys() returned keys when the object was not added to the db yet.");
                    collector.addEvent(event);
                    IndexManager.updateFromIndexes(originalKeys, (InternalReferenceObject)artifact);
                } else if (event.getKind() == ReferenceEvent.Kind.ADD) {
                    this.incSize();
                    this.db.update(record);
                    collector.addEvent(event);
                    IndexManager.addToIndexes((InternalReferenceObject)artifact);
                }
                ((InternalReferenceObject)artifact).clearOriginalKeys();
            }
            catch (RuntimeException e) {
                if (e instanceof ReferenceException) {
                    throw e;
                }
                IStatus status = this.createStatus(Messages.errorMsg_could_not_update, (InternalReferenceObject)artifact, e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public InternalReferenceRecord getInternalReferenceRecord(int id) throws ReferenceException {
        this.init();
        try {
            DBRecord o;
            this.read.lock();
            if (id != -1 && (o = this.db.readRecord(id)) instanceof InternalReferenceRecord) {
                InternalReferenceRecord internalReferenceRecord = (InternalReferenceRecord)o;
                return internalReferenceRecord;
            }
            return null;
        }
        catch (RuntimeException e) {
            IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_while_reading_X, (Object)id), null, e);
            throw new ReferenceException(status);
        }
        finally {
            this.read.unlock();
        }
    }

    public IReferenceElement getReferenceElement(int id) throws ReferenceException {
        InternalReferenceRecord record = this.getInternalReferenceRecord(id);
        if (record != null) {
            return record.getLinkArtifact();
        }
        return null;
    }

    public <T extends IReferenceElement> T getReferenceElement(int id, Class<T> clazz) throws ReferenceException {
        InternalReferenceRecord record = this.getInternalReferenceRecord(id);
        if (record != null) {
            try {
                return (T)((IReferenceElement)clazz.cast(record.getLinkArtifact()));
            }
            catch (ClassCastException classCastException) {}
        }
        return null;
    }

    public void removeReferenceElement(IReferenceElement artifact, EventCollector collector) throws ReferenceException {
        this.removeReferenceElements(Collections.singleton(artifact), collector);
    }

    public void removeReferenceElements(Collection<? extends IReferenceElement> artifacts, EventCollector collector) throws ReferenceException {
        if (artifacts.isEmpty()) {
            return;
        }
        this.init();
        LinkedHashSet<? extends IReferenceElement> toBeDeleted = new LinkedHashSet<IReferenceElement>();
        toBeDeleted.addAll(artifacts);
        for (IReferenceElement iReferenceElement : artifacts) {
            if (iReferenceElement.getId() == -1) continue;
            InternalReferenceRecord record = ((InternalReferenceObject)iReferenceElement).getRecord();
            LinkedHashSet<? extends IReferenceElement> cascade = new LinkedHashSet<IReferenceElement>(record.getDeleteCascade());
            while (!cascade.isEmpty()) {
                cascade.removeAll(toBeDeleted);
                Iterator itr = cascade.iterator();
                if (!itr.hasNext()) continue;
                IReferenceElement c = (IReferenceElement)itr.next();
                itr.remove();
                cascade.addAll(((InternalReferenceObject)c).getRecord().getDeleteCascade());
                toBeDeleted.add(c);
            }
        }
        HashSet<LinkKey> hashSet = new HashSet<LinkKey>();
        for (IReferenceElement iReferenceElement : toBeDeleted) {
            hashSet.addAll(IndexManager.getKeys((InternalReferenceObject)iReferenceElement));
        }
        try {
            this.write.lock();
            IndexManager.deleteKeys(hashSet);
            for (IReferenceElement iReferenceElement : toBeDeleted) {
                if (iReferenceElement.getId() == -1) continue;
                InternalReferenceRecord record = ((InternalReferenceObject)iReferenceElement).getRecord();
                try {
                    try {
                        this.decSize();
                        this.db.delete(record);
                    }
                    catch (RuntimeException e) {
                        IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_while_removing_x, (Object)iReferenceElement.toString()), null, e);
                        throw new ReferenceException(status);
                    }
                }
                finally {
                    collector.addEvent(new ReferenceEvent(iReferenceElement, ReferenceEvent.Kind.REMOVE));
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void reset() throws FatalIOException {
        if (!this.init.isDone()) {
            return;
        }
        try {
            this.write.lock();
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            try {
                this.db.recreate();
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
            InternalSearchEngine.removeCache();
            this.initHeaders();
            this.loadHeaders(this.headers);
            exceptions.addAll(IndexManager.recreateIndexes());
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.etools.references", 4, Messages.errorMsg_error_during_reset, null);
                int count = 1;
                for (Exception exception : exceptions) {
                    Status status = new Status(4, "com.ibm.etools.references", NLS.bind((String)Messages.errorMsg_nested_exception_x_y, (Object)count, (Object)exception.getClass().getSimpleName()), (Throwable)exception);
                    multi.add((IStatus)status);
                    ++count;
                }
                throw new ReferenceException((IStatus)multi);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void clearCache() {
        this.init();
        this.write.lock();
        try {
            this.db.clearCache();
        }
        finally {
            this.write.unlock();
        }
    }

    public void drainCache(boolean immediate) {
        this.init();
        this.write.lock();
        try {
            this.db.drainCache(immediate);
        }
        finally {
            this.write.unlock();
        }
    }

    public void sync() {
        this.write.lock();
        try {
            this.drainCache(false);
        }
        finally {
            this.write.unlock();
        }
        this.db.sync();
    }

    private ReferenceException convertMultipleExceptions(String msg, List<Exception> exceptions) {
        if (!exceptions.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(stream, true);
            writer.println(msg);
            int count = 1;
            for (Exception exception : exceptions) {
                writer.println(NLS.bind((String)Messages.errorMsg_exception_x, (Object)count));
                exception.printStackTrace(writer);
                ++count;
            }
            Status status = new Status(4, "com.ibm.etools.references", stream.toString(), null);
            return new ReferenceException((IStatus)status);
        }
        return null;
    }

    public void shutdown() {
        this.init();
        this.sync();
        try {
            this.write.lock();
            List<Exception> resetExceptions = this.resetIndexes(true);
            ReferenceException resetExcept = this.convertMultipleExceptions(Messages.ReferenceDatabase_IgnoringErrorsDuringReset, resetExceptions);
            if (resetExcept != null) {
                Logger.logException("", resetExcept);
            }
            this.saveHeaders();
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            try {
                this.db.close(true);
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
            InternalSearchEngine.removeCache();
            exceptions.addAll(IndexManager.closeIndexes());
            ReferenceException e = this.convertMultipleExceptions(Messages.errorMsg_errors_during_close, exceptions);
            if (e != null) {
                throw e;
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void reload() throws FatalIOException {
        this.init();
        this.write.lock();
        try {
            this.db.reload();
            this.loadHeaders(this.headers);
        }
        finally {
            this.write.unlock();
        }
    }

    public SavedLinkNodes createSavedLinkNodes() {
        return (SavedLinkNodes)this.referenceFactory.createRecord(100, null);
    }

    public SavedLinkNodes getSavedLinkNodes() throws FatalIOException {
        this.init();
        int id = this.getSavedInfoId();
        if (id == 65535) {
            return this.createSavedLinkNodes();
        }
        SavedLinkNodes nodes = null;
        try {
            this.read.lock();
            nodes = (SavedLinkNodes)this.db.readRecord(id);
        }
        finally {
            this.read.unlock();
        }
        return nodes;
    }

    public void updateSavedLinkNodes(SavedLinkNodes nodes) throws FatalIOException {
        this.init();
        try {
            this.write.lock();
            boolean refreshId = false;
            if (nodes.getId() == -1) {
                refreshId = true;
            }
            this.db.update(nodes);
            if (refreshId) {
                ((IntFileHeader)this.headers.get(0)).setHeaderValue(nodes.getId());
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public int getSize() {
        this.init();
        this.read.lock();
        try {
            int n = this.getRefDBSize();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    public void incSize() {
        this.init();
        try {
            this.write.lock();
            ((IntFileHeader)this.headers.get(2)).setHeaderValue(((IntFileHeader)this.headers.get(2)).getHeaderValue() + 1);
        }
        finally {
            this.write.unlock();
        }
    }

    public void decSize() {
        this.init();
        try {
            this.write.lock();
            ((IntFileHeader)this.headers.get(2)).setHeaderValue(((IntFileHeader)this.headers.get(2)).getHeaderValue() - 1);
        }
        finally {
            this.write.unlock();
        }
    }

    public boolean convertIndexes(boolean toHeap, IProgressMonitor progressMonitor) {
        this.init();
        try {
            this.write.lock();
            boolean bl = IndexManager.convertIndexes(toHeap, progressMonitor);
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    public PropertyStore getPropertyStore() throws FatalIOException {
        this.init();
        int id = 65535;
        try {
            this.write.lock();
            id = this.getPropertyStoreId();
            if (id == 65535) {
                PropertyStore propertyStore = (PropertyStore)this.referenceFactory.createRecord(101, null);
                return propertyStore;
            }
            PropertyStore nodes = null;
            DBRecord r = this.db.readRecord(id);
            if (r instanceof PropertyStore) {
                nodes = (PropertyStore)r;
            }
            PropertyStore propertyStore = nodes;
            return propertyStore;
        }
        catch (FatalIOException e) {
            if (e.getCode() == 1) {
                return null;
            }
            throw e;
        }
        finally {
            this.write.unlock();
        }
    }

    public void storeValue(String nameSpace, String key, String value) {
        this.init();
        try {
            this.write.lock();
            PropertyStore store = this.getPropertyStore();
            if (store != null) {
                store.writeValue(nameSpace, key, value);
                this.db.update(store);
                ((IntFileHeader)this.headers.get(1)).setHeaderValue(store.getId());
            } else {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Store property after db is closed");
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void clearValue(String nameSpace, String key) {
        this.init();
        try {
            this.write.lock();
            PropertyStore store = this.getPropertyStore();
            if (store != null) {
                store.removeValue(nameSpace, key);
                this.db.update(store);
                ((IntFileHeader)this.headers.get(1)).setHeaderValue(store.getId());
            } else {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Clear property after db is closed");
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public String readValue(String nameSpace, String key, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", 1);
        this.init();
        boolean gotLock = false;
        try {
            while (!gotLock) {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                gotLock = this.write.tryLock(250L, TimeUnit.MILLISECONDS);
            }
            PropertyStore store = this.getPropertyStore();
            if (store != null) {
                String string = store.readValue(nameSpace, key);
                return string;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        finally {
            if (gotLock) {
                this.write.unlock();
            }
        }
    }

    public void convertIndexes(int size, boolean toHeap) {
        int current = this.getSize();
        int delta = current - this.lastSize;
        this.lastSize = current;
        if (toHeap) {
            if (current >= MEM_DB_SIZE_THRESHOLD && this.convertIndexesJob.isUsingHeapIndex()) {
                this.convertIndexesJob.setConvertStyle(false);
            } else if (size > MEM_INDEX_MIN_THRESHOLD && size < MEM_INDEX_MAX_THRESHOLD && current < MEM_DB_SIZE_THRESHOLD && delta > 0) {
                this.convertIndexesJob.setConvertStyle(true);
            }
        } else {
            this.convertIndexesJob.setConvertStyle(false);
        }
    }

    private List<Exception> resetIndexes(boolean ensureDisk) {
        this.convertIndexesJob.setConvertStyle(false, true);
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                this.convertIndexesJob.join();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return IndexManager.syncIndexes(ensureDisk);
    }

    public void cancelConvertIndexes() {
        if (this.convertIndexesJob.getState() == 4) {
            this.convertIndexesJob.cancel();
        }
    }

    public void printCacheStats(PrintStream out) {
        this.read.lock();
        try {
            out.println("Reference Database");
            out.print("\t");
            this.db.printCacheStats(out);
        }
        finally {
            this.read.unlock();
        }
    }

    public void resetStats() {
        this.write.lock();
        try {
            this.db.resetStats();
        }
        finally {
            this.write.unlock();
        }
    }

    public Link createNewLink() {
        Link link = new Link();
        link.init(this.db);
        link.markLoaded();
        return link;
    }

    public ExtentManager getExtentManager() {
        return this.db;
    }

    public ResolvedReference createNewResolvedReference() {
        ResolvedReference reference = new ResolvedReference();
        reference.init(this.db);
        reference.markLoaded();
        return reference;
    }

    private class Init
    implements Runnable {
        private Init() {
        }

        @Override
        public void run() {
            boolean interrupted = Thread.interrupted();
            while (true) {
                try {
                    READY_LATCH.await();
                    File databaseFile = new File(Activator.getDatabaseDirectory(), "database.db");
                    ReferenceDatabase.this.referenceFactory = new ReferenceRecordFactory(ReferenceDatabase.this);
                    ReferenceDatabase.this.initHeaders();
                    ReferenceDatabase.this.db = new ExtentManager(InternalAPI.Tweaks.DB_CACHE_SIZE, databaseFile, ReferenceDatabase.this.referenceFactory, 512000, ReferenceDatabase.this.headers, 1.0f, false, ReferenceDatabase.this.rwlock);
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public class ReferenceRecordFactory
    extends DBRecordFactory {
        public ReferenceRecordFactory(ReferenceDatabase refDB) {
        }

        @Override
        public DBRecord createRecord(int recordType, ExtentManager manager) {
            if (recordType == 100) {
                return new SavedLinkNodes(100, ReferenceManager.getReferenceManager());
            }
            if (recordType == 101) {
                return new PropertyStore(101);
            }
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            InternalReferenceRecord result = null;
            if (elementType == IReferenceElement.ElementType.LINK) {
                Assert.isNotNull((Object)manager, (String)Messages.ReferenceRecordFactory_ManageCannotBeNull);
                Link o = new Link();
                o.init(manager);
                result = ((InternalReferenceObject)o).getRecord();
            } else if (elementType == IReferenceElement.ElementType.REFERENCE) {
                Assert.isNotNull((Object)manager, (String)Messages.ReferenceRecordFactory_ManageCannotBeNull);
                Reference o = new Reference(null, null);
                o.init(manager);
                result = ((InternalReferenceObject)o).getRecord();
            } else if (elementType == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                Assert.isNotNull((Object)manager, (String)Messages.ReferenceRecordFactory_ManageCannotBeNull);
                ResolvedReference o = new ResolvedReference();
                o.init(manager);
                result = ((InternalReferenceObject)o).getRecord();
            }
            return result;
        }

        @Override
        public boolean shouldProxyLoad(int recordType) {
            if (recordType > IReferenceElement.ElementType.values().length) {
                return false;
            }
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            if (elementType == IReferenceElement.ElementType.LINK) {
                return true;
            }
            if (elementType == IReferenceElement.ElementType.REFERENCE) {
                return true;
            }
            if (elementType == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                return true;
            }
            return super.shouldProxyLoad(recordType);
        }

        @Override
        public int getAverageSize(int recordType) {
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            if (elementType == IReferenceElement.ElementType.LINK) {
                return 40;
            }
            if (elementType == IReferenceElement.ElementType.REFERENCE) {
                return 36;
            }
            if (elementType != IReferenceElement.ElementType.RESOLVED_REFERENCE && recordType == 102) {
                return 84;
            }
            return 128;
        }

        @Override
        public int getSize(int recordType) {
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            if (elementType == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                return 25;
            }
            return -1;
        }

        @Override
        public int[] recordTypes() {
            return new int[]{IReferenceElement.ElementType.RESOLVED_REFERENCE.ordinal(), IReferenceElement.ElementType.REFERENCE.ordinal(), IReferenceElement.ElementType.LINK.ordinal()};
        }
    }
}

