/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PropertyStore
extends InternalReferenceRecord {
    private final Map<String, Map<String, String>> nameSpaceToKeyValueMap = new HashMap<String, Map<String, String>>();

    public PropertyStore(int dataType) {
        super(dataType);
    }

    @Override
    public void doReadRecord(PooledByteBuffer input) {
        this.nameSpaceToKeyValueMap.clear();
        int namespaces = ByteUtils.bytesToInt(input.buffer);
        int i = 0;
        while (i < namespaces) {
            String namespace = ByteUtils.bytesToString(input.buffer);
            int kvSize = ByteUtils.bytesToInt(input.buffer);
            HashMap<String, String> kvMap = new HashMap<String, String>();
            int j = 0;
            while (j < kvSize) {
                String key = ByteUtils.bytesToString(input.buffer);
                String value = ByteUtils.bytesToString(input.buffer);
                kvMap.put(key, value);
                ++j;
            }
            if (kvSize > 0) {
                this.nameSpaceToKeyValueMap.put(namespace, kvMap);
            }
            ++i;
        }
        input.returnBuffer();
    }

    @Override
    public PooledByteBuffer doWriteRecord() {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        Set<Map.Entry<String, Map<String, String>>> entrySet = this.nameSpaceToKeyValueMap.entrySet();
        buffers.add(ByteUtils.intToBytes(entrySet.size()));
        for (Map.Entry<String, Map<String, String>> entry : entrySet) {
            String nameSpace = entry.getKey();
            Map<String, String> keyValueMap = entry.getValue();
            buffers.add(ByteUtils.stringToBytes(nameSpace));
            buffers.add(ByteUtils.intToBytes(keyValueMap.size()));
            Set<Map.Entry<String, String>> keyValueSet = keyValueMap.entrySet();
            for (Map.Entry<String, String> kvEntry : keyValueSet) {
                buffers.add(ByteUtils.stringToBytes(kvEntry.getKey()));
                buffers.add(ByteUtils.stringToBytes(kvEntry.getValue()));
            }
        }
        int size = 0;
        for (ByteBuffer byteBuffer : buffers) {
            size += byteBuffer.limit();
        }
        PooledByteBuffer result = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
        for (ByteBuffer byteBuffer : buffers) {
            result.buffer.put(byteBuffer);
        }
        result.buffer.rewind();
        return result;
    }

    public void writeValue(String nameSpace, String key, String value) {
        Map<String, String> keyValue = this.nameSpaceToKeyValueMap.get(nameSpace);
        if (keyValue == null) {
            keyValue = new HashMap<String, String>();
            this.nameSpaceToKeyValueMap.put(nameSpace, keyValue);
        }
        keyValue.put(key, value);
    }

    public void removeValue(String nameSpace, String key) {
        Map<String, String> keyValue = this.nameSpaceToKeyValueMap.get(nameSpace);
        if (keyValue == null) {
            return;
        }
        keyValue.remove(key);
    }

    public String readValue(String nameSpace, String key) {
        Map<String, String> keyValue = this.nameSpaceToKeyValueMap.get(nameSpace);
        if (keyValue == null) {
            return null;
        }
        return keyValue.get(key);
    }

    @Override
    protected InternalReferenceObject getLinkArtifact() {
        return null;
    }

    @Override
    public String toString() {
        int[] ints = ByteUtils.intToUnsignedShorts(this.getId());
        String s = "PROPERTYSTORE [ID: " + ints[1] + ":" + ints[0] + " (" + this.getId() + ")]\n";
        for (Map.Entry<String, Map<String, String>> namespaces : this.nameSpaceToKeyValueMap.entrySet()) {
            s = String.valueOf(s) + "\tNamespace: " + namespaces.getKey() + "\n";
            for (Map.Entry<String, String> properties : namespaces.getValue().entrySet()) {
                s = String.valueOf(s) + "\t\t" + properties.getKey() + "=" + properties.getValue() + ", ";
            }
        }
        return s;
    }
}

