/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.management.IReferenceElement;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public abstract class InternalReferenceRecord
extends DBRecord {
    private static Deflater deflater;
    private static Inflater inflater;

    static {
        if (InternalAPI.Tweaks.USE_COMPRESSION) {
            deflater = new Deflater(9, true);
            inflater = new Inflater(true);
        }
    }

    public InternalReferenceRecord(int dataType) {
        super(dataType);
    }

    @Override
    public boolean isDirty() {
        return super.isDirty();
    }

    protected abstract InternalReferenceObject getLinkArtifact();

    protected Collection<? extends IReferenceElement> getDeleteCascade() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PooledByteBuffer writeRecord() {
        if (InternalAPI.Tweaks.USE_COMPRESSION) {
            int actual = 0;
            PooledByteBuffer buf = this.doWriteRecord();
            Deflater deflater = InternalReferenceRecord.deflater;
            synchronized (deflater) {
                InternalReferenceRecord.deflater.reset();
                byte[] bytes = buf.buffer.array();
                InternalReferenceRecord.deflater.setInput(bytes);
                InternalReferenceRecord.deflater.finish();
                byte[] compressed = new byte[bytes.length + 8];
                actual = InternalReferenceRecord.deflater.deflate(compressed, 0, compressed.length);
                buf.buffer.rewind();
                buf.buffer.put(compressed, 0, actual);
                buf.buffer.rewind();
            }
            buf.buffer.limit(actual);
            PooledByteBuffer compressed = PooledByteBuffer.INSTANCE.leaseByteBuffer(actual + 4);
            compressed.buffer.putInt(actual);
            compressed.buffer.put(buf.buffer);
            compressed.buffer.rewind();
            return compressed;
        }
        return this.doWriteRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void readRecord(PooledByteBuffer record) {
        if (InternalAPI.Tweaks.USE_COMPRESSION) {
            int length = record.buffer.getInt();
            byte[] input = new byte[length + 1];
            record.buffer.get(input, 0, length);
            byte[] decompressedData = null;
            Inflater inflater = InternalReferenceRecord.inflater;
            synchronized (inflater) {
                ByteArrayOutputStream bos;
                block9: {
                    InternalReferenceRecord.inflater.reset();
                    InternalReferenceRecord.inflater.setInput(input);
                    bos = new ByteArrayOutputStream();
                    do {
                        byte[] buf = new byte[1024];
                        int numDecompressed = 0;
                        try {
                            while ((numDecompressed = InternalReferenceRecord.inflater.inflate(buf, 0, buf.length)) != 0) {
                                bos.write(buf, 0, numDecompressed);
                            }
                        }
                        catch (DataFormatException e) {
                            throw new RuntimeException(e);
                        }
                        if (InternalReferenceRecord.inflater.finished()) break block9;
                        if (!InternalReferenceRecord.inflater.needsDictionary()) continue;
                        throw new RuntimeException("Need dict");
                    } while (!InternalReferenceRecord.inflater.needsInput());
                    throw new RuntimeException("Need more input");
                }
                decompressedData = bos.toByteArray();
            }
            PooledByteBuffer uncompressed = new PooledByteBuffer(ByteBuffer.wrap(decompressedData));
            this.doReadRecord(uncompressed);
        } else {
            this.doReadRecord(record);
        }
    }

    public abstract PooledByteBuffer doWriteRecord();

    public abstract void doReadRecord(PooledByteBuffer var1);

    @Override
    protected boolean isValid() {
        return super.isValid();
    }

    @Override
    public String toString() {
        InternalReferenceObject o = this.getLinkArtifact();
        if (o != null) {
            return String.valueOf(super.toString()) + "[[ " + o.toString() + " ]]";
        }
        return super.toString();
    }
}

