/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.bplustree.tree.BPTree;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.KeyInfo;
import com.ibm.etools.references.internal.index.DiskBasedReferenceIndex;
import com.ibm.etools.references.internal.index.HeapBasedReferenceIndex;
import com.ibm.etools.references.internal.index.IReferenceIndex;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.IndexKeyFactory;
import com.ibm.etools.references.internal.index.keys.IntPairComparator;
import com.ibm.etools.references.internal.index.keys.IntStringIntComparator;
import com.ibm.etools.references.internal.index.keys.LinkByLinkNameKey;
import com.ibm.etools.references.internal.index.keys.LinkByLinkTextKey;
import com.ibm.etools.references.internal.index.keys.LinkByLinkTypeKey;
import com.ibm.etools.references.internal.index.keys.LinkBySourcePathKey;
import com.ibm.etools.references.internal.index.keys.LinkByTypeBySourcePathKey;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.index.keys.ReferenceByLinkIdKey;
import com.ibm.etools.references.internal.index.keys.ReferenceByTypeKey;
import com.ibm.etools.references.internal.index.keys.ResolvedReferenceByModelInstanceRefKey;
import com.ibm.etools.references.internal.index.keys.ResolvedReferenceByReferenceIdKey;
import com.ibm.etools.references.internal.index.keys.ResolvedReferenceBySourceLinkId;
import com.ibm.etools.references.internal.index.keys.ResolvedReferenceBySourcePathKey;
import com.ibm.etools.references.internal.index.keys.ResolvedReferenceByTargetLinkId;
import com.ibm.etools.references.internal.index.keys.ResolvedReferenceByTargetPathKey;
import com.ibm.etools.references.internal.index.keys.StringIntPairComparator;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public final class IndexManager {
    private static Map<String, IReferenceIndex> INDEXES;
    private static Map<String, DiskBasedReferenceIndex> DISK;
    private static final Map<String, IndexKeyFactory> FILETOKEY;
    private static final Future<?> INIT;
    private static final ReadWriteLock RW_LOCK;
    private static LinkByLinkTypeKey ALL_LINKS_KEY;

    static {
        FILETOKEY = new HashMap<String, IndexKeyFactory>();
        RW_LOCK = new ReentrantReadWriteLock();
        INIT = InternalAPI.getExecutor().submit(new Init(), null);
    }

    private IndexManager() {
    }

    static IndexKeyFactory createFactory(KeyConfig config) {
        return new IndexKeyFactory(config.clazz, config.comparator, config.averagesize, config.size);
    }

    private static Collection<LinkKey> createKey(IndexConstants type, InternalReferenceObject artifact) {
        InternalReferenceObject original = artifact;
        int artId = artifact.getId();
        if (original.getElementType() == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
            ResolvedReference resolvedReference = (ResolvedReference)original;
            if (type != IndexConstants.BY_LINKTEXT && type != IndexConstants.BY_LINKTYPE) {
                if (type == IndexConstants.BY_SOURCEPATH) {
                    ILink source = resolvedReference.getSource();
                    if (source != null && source.getPath() != null) {
                        String path = source.getPath().toPortableString();
                        return IndexManager.createKey(type, original.getElementType(), path, artId);
                    }
                } else if (type == IndexConstants.BY_TARGETPATH) {
                    ILink target = resolvedReference.getTarget();
                    if (target != null && target.getPath() != null) {
                        String path = target.getPath().toPortableString();
                        return IndexManager.createKey(type, original.getElementType(), path, artId);
                    }
                } else {
                    if (type == IndexConstants.BY_MODELINSTANCEID_REF) {
                        if (resolvedReference.getModelInstanceIdReference() == null) {
                            return Collections.emptyList();
                        }
                        return IndexManager.createKey(type, original.getElementType(), resolvedReference.getModelInstanceIdReference(), artId);
                    }
                    if (type == IndexConstants.BY_REFERENCE_ID) {
                        Reference reference = resolvedReference.getReference();
                        if (reference != null) {
                            return IndexManager.createKey(type, original.getElementType(), reference.getId(), artId);
                        }
                    } else if (type == IndexConstants.BY_SOURCELINKID) {
                        Reference reference = resolvedReference.getReference();
                        if (reference != null && reference.getSource() != null) {
                            return IndexManager.createKey(type, original.getElementType(), reference.getSource().getId(), artId);
                        }
                    } else if (type == IndexConstants.BY_TARGETLINKID) {
                        int id;
                        ILink target = resolvedReference.getTarget();
                        int n = id = target == null ? -1 : target.getId();
                        if (target != null) {
                            return IndexManager.createKey(type, original.getElementType(), id, artId);
                        }
                    }
                }
            }
        } else if (original.getElementType() == IReferenceElement.ElementType.REFERENCE) {
            if (type != IndexConstants.BY_LINKTEXT && type != IndexConstants.BY_LINKTYPE && type != IndexConstants.BY_SOURCEPATH) {
                ILink source;
                if (type == IndexConstants.BY_REFERENCETYPE) {
                    return IndexManager.createKey(type, original.getElementType(), ((Reference)original).getReferenceType(), artId);
                }
                if (type == IndexConstants.BY_SOURCELINKID && (source = ((Reference)original).getSource()) != null) {
                    return IndexManager.createKey(type, original.getElementType(), source.getId(), artId);
                }
            }
        } else if (original.getElementType() == IReferenceElement.ElementType.LINK) {
            Link link = (Link)original;
            if (type == IndexConstants.BY_LINKTEXT) {
                if (link.getLinkText() != null && link.getLinkText().length() != 0) {
                    return IndexManager.createKey(type, original.getElementType(), IndexManager.trimQuotes(link.getLinkText()), link.getId());
                }
            } else if (type == IndexConstants.BY_LINKNAME) {
                if (link.getName() != null) {
                    return IndexManager.createKey(type, original.getElementType(), link.getName(), link.getId());
                }
            } else {
                if (type == IndexConstants.BY_LINKTYPE) {
                    ArrayList<LinkKey> keys = new ArrayList<LinkKey>(2);
                    keys.addAll(IndexManager.createKey(type, original.getElementType(), link.getSpecializedType().getId(), link.getId()));
                    LinkByTypeBySourcePathKey key = new LinkByTypeBySourcePathKey();
                    key.setIntStringInt(link.getSpecializedType().getTypeid(), link.getPath().toString(), link.getId());
                    keys.add(key);
                    return keys;
                }
                if (type == IndexConstants.BY_SOURCEPATH) {
                    return IndexManager.createKey(type, original.getElementType(), link.getPath().toPortableString(), link.getId());
                }
            }
        }
        return null;
    }

    private static Collection<LinkKey> createKey(IndexConstants searchType, IReferenceElement.ElementType limitTo, String searchPath, int id) {
        if (limitTo == IReferenceElement.ElementType.LINK) {
            if (searchType == IndexConstants.BY_SOURCEPATH) {
                LinkBySourcePathKey key = new LinkBySourcePathKey();
                String path = searchPath;
                if (path != null && !path.endsWith("/") || path == null) {
                    path = String.valueOf(path);
                }
                key.setStringIntValue(path, id);
                return Collections.singleton(key);
            }
            if (searchType == IndexConstants.BY_LINKTEXT) {
                LinkByLinkTextKey key = new LinkByLinkTextKey();
                key.setStringIntValue(searchPath, id);
                return Collections.singleton(key);
            }
            if (searchType == IndexConstants.BY_LINKNAME) {
                LinkByLinkNameKey key = new LinkByLinkNameKey();
                key.setStringIntValue(searchPath, id);
                return Collections.singleton(key);
            }
            if (searchType == IndexConstants.BY_LINKTYPE) {
                int typeId;
                LinkByLinkTypeKey key = new LinkByLinkTypeKey();
                try {
                    SpecializedType linkType = LinkTypeRegistry.getInstance().getLinkType(searchPath);
                    typeId = linkType.getTypeid();
                }
                catch (Exception exception) {
                    typeId = -1;
                }
                key.setIntPair(typeId, id);
                return Collections.singleton(key);
            }
        } else if (limitTo == IReferenceElement.ElementType.REFERENCE) {
            if (searchType == IndexConstants.BY_REFERENCETYPE) {
                ReferenceByTypeKey key = new ReferenceByTypeKey();
                int refId = ReferenceGeneratorService.getInstance().getReferenceTypeId(searchPath);
                key.setIntPair(refId, id);
                return Collections.singleton(key);
            }
        } else if (limitTo == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
            if (searchType == IndexConstants.BY_TARGETPATH) {
                ResolvedReferenceByTargetPathKey key = new ResolvedReferenceByTargetPathKey();
                String path = searchPath;
                if (path != null && !path.endsWith("/") || path == null) {
                    path = String.valueOf(path);
                }
                key.setStringIntValue(path, id);
                return Collections.singleton(key);
            }
            if (searchType == IndexConstants.BY_SOURCEPATH) {
                ResolvedReferenceBySourcePathKey key = new ResolvedReferenceBySourcePathKey();
                String path = searchPath;
                if (path != null && !path.endsWith("/") || path == null) {
                    path = String.valueOf(path);
                }
                key.setStringIntValue(path, id);
                return Collections.singleton(key);
            }
            if (searchType == IndexConstants.BY_MODELINSTANCEID_REF) {
                ResolvedReferenceByModelInstanceRefKey key = new ResolvedReferenceByModelInstanceRefKey();
                key.setStringIntValue(searchPath, id);
                return Collections.singleton(key);
            }
        }
        return null;
    }

    public static Collection<LinkKey> createKey(IndexConstants searchType, IReferenceElement.ElementType limitTo, int id, int id2) {
        if (limitTo == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
            if (searchType != IndexConstants.BY_LINKTEXT && searchType != IndexConstants.BY_TARGETPATH && searchType != IndexConstants.BY_LINKTYPE && searchType != IndexConstants.BY_SOURCEPATH && searchType != IndexConstants.BY_MODELINSTANCEID_REF) {
                if (searchType == IndexConstants.BY_REFERENCE_ID) {
                    int linkId = id;
                    int refId = id2;
                    ResolvedReferenceByReferenceIdKey key = new ResolvedReferenceByReferenceIdKey();
                    key.setIntPair(linkId, refId);
                    return Collections.singleton(key);
                }
                if (searchType == IndexConstants.BY_SOURCELINKID) {
                    int linkId = id;
                    int refId = id2;
                    ResolvedReferenceBySourceLinkId key = new ResolvedReferenceBySourceLinkId();
                    key.setIntPair(linkId, refId);
                    return Collections.singleton(key);
                }
                if (searchType == IndexConstants.BY_TARGETLINKID) {
                    int linkId = id;
                    int refId = id2;
                    ResolvedReferenceByTargetLinkId key = new ResolvedReferenceByTargetLinkId();
                    key.setIntPair(linkId, refId);
                    return Collections.singleton(key);
                }
            }
        } else if (limitTo == IReferenceElement.ElementType.REFERENCE) {
            if (searchType != IndexConstants.BY_LINKTEXT && searchType != IndexConstants.BY_LINKTYPE && searchType != IndexConstants.BY_SOURCEPATH && searchType != IndexConstants.BY_REFERENCETYPE && searchType == IndexConstants.BY_SOURCELINKID) {
                int linkId = id;
                int refId = id2;
                ReferenceByLinkIdKey key = new ReferenceByLinkIdKey();
                key.setIntPair(linkId, refId);
                return Collections.singleton(key);
            }
        }
        return null;
    }

    public static Collection<LinkKey> createKey(IndexConstants searchType, IReferenceElement.ElementType limitTo, String pattern) {
        int index = pattern.indexOf("!&!");
        String[] ids = null;
        if (index >= 0) {
            String part1 = pattern.substring(0, index);
            String part2 = pattern.substring(index + "!&!".length(), pattern.length());
            ids = new String[]{part1, part2};
        } else {
            ids = new String[]{pattern};
        }
        Collection<LinkKey> keys = null;
        if (ids.length > 1) {
            int id2 = -1;
            if (!"-1".equals(ids[1])) {
                id2 = Integer.parseInt(ids[1]);
            }
            if ((keys = IndexManager.createKey(searchType, limitTo, ids[0], id2)) == null) {
                int id1 = Integer.parseInt(ids[0]);
                keys = IndexManager.createKey(searchType, limitTo, id1, id2);
            }
        } else {
            int id2 = -1;
            keys = IndexManager.createKey(searchType, limitTo, ids[0], id2);
            if (keys == null) {
                int id1 = Integer.parseInt(ids[0]);
                keys = IndexManager.createKey(searchType, limitTo, id1, id2);
            }
        }
        return keys;
    }

    public static IndexConstants convertSearchTypeInIndex(SearchType type, IReferenceElement.ElementType limitTo) {
        if (type == SearchType.BY_LINKNAME) {
            return IndexConstants.BY_LINKNAME;
        }
        if (type == SearchType.BY_LINKTEXT) {
            return IndexConstants.BY_LINKTEXT;
        }
        if (limitTo == IReferenceElement.ElementType.REFERENCE) {
            if (type == SearchType.BY_TYPE) {
                return IndexConstants.BY_REFERENCETYPE;
            }
        } else if (limitTo == IReferenceElement.ElementType.LINK && type == SearchType.BY_TYPE) {
            return IndexConstants.BY_LINKTYPE;
        }
        return null;
    }

    public static Collection<LinkKey> createScopedKey(SearchScope scope, IndexConstants searchType, IReferenceElement.ElementType limitTo, String pattern) {
        SpecializedType type;
        ArrayList<LinkKey> keys = new ArrayList<LinkKey>();
        if (limitTo == IReferenceElement.ElementType.LINK && searchType == IndexConstants.BY_LINKTYPE && (type = LinkTypeRegistry.getInstance().getLinkType(pattern)) != null) {
            IPath[] paths;
            IPath[] iPathArray = paths = scope.getPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                LinkByTypeBySourcePathKey key = new LinkByTypeBySourcePathKey();
                key.setIntStringInt(type.getTypeid(), path.toString(), -1);
                keys.add(key);
                ++n2;
            }
        }
        return keys;
    }

    private static void waitForIndexes() {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                INIT.get();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new RuntimeException(t);
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private static IReferenceIndex getIndex(LinkKey key) {
        String indexName = key.getIndexName();
        return INDEXES.get(indexName);
    }

    public static boolean convertIndexes(boolean toHeap, IProgressMonitor progressMonitor) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            Collection<IReferenceIndex> idx = INDEXES.values();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)idx.size());
            sub.subTask(Messages.errorMsg_optimizingindexes);
            for (IReferenceIndex oldIndex : idx) {
                IndexManager.doConvert(toHeap, (IProgressMonitor)sub.newChild(1), oldIndex, false);
            }
            return false;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    private static void doConvert(boolean toHeap, IProgressMonitor monitor, IReferenceIndex oldIndex, boolean recreateOnly) {
        if (toHeap) {
            Assert.isTrue((!recreateOnly ? 1 : 0) != 0, (String)"Cannot recreate when going to heap");
            if (!(oldIndex instanceof HeapBasedReferenceIndex)) {
                IReferenceIndex newIndex;
                int newSize;
                IndexKeyFactory factory = FILETOKEY.get(oldIndex.getIndexName());
                HeapBasedReferenceIndex index = new HeapBasedReferenceIndex(oldIndex.getFile(), oldIndex.getIndexName(), factory.createKey().defaultComparator());
                int oldSize = oldIndex.getSize();
                if (oldSize != (newSize = (newIndex = oldIndex.convertToHeap(index, monitor)).getSize())) {
                    Assert.isTrue((oldSize == newSize ? 1 : 0) != 0, (String)NLS.bind((String)Messages.OldAndNewSizeDifferent, (Object[])new String[]{"" + oldSize, "" + newSize}));
                }
                oldIndex.recreate();
                INDEXES.put(oldIndex.getIndexName(), newIndex);
            }
        } else if (recreateOnly) {
            IReferenceIndex diskIndex = DISK.get(oldIndex.getIndexName());
            diskIndex.recreate();
            INDEXES.put(oldIndex.getIndexName(), diskIndex);
        } else if (!(oldIndex instanceof DiskBasedReferenceIndex)) {
            IReferenceIndex diskIndex;
            IReferenceIndex newIndex;
            int newSize;
            int oldSize = oldIndex.getSize();
            if (oldSize != (newSize = (newIndex = oldIndex.convertToDisk(diskIndex = (IReferenceIndex)DISK.get(oldIndex.getIndexName()), monitor)).getSize())) {
                Assert.isTrue((oldSize == newSize ? 1 : 0) != 0, (String)NLS.bind((String)Messages.OldAndNewSizeDifferent, (Object[])new String[]{"" + oldSize, "" + newSize}));
            }
            oldIndex.recreate();
            INDEXES.put(oldIndex.getIndexName(), newIndex);
        }
    }

    public static List<LinkKey> getKeys(InternalReferenceObject link) {
        IndexConstants[] values = IndexConstants.values();
        ArrayList<LinkKey> keys = new ArrayList<LinkKey>(values.length);
        IndexConstants[] indexConstantsArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IndexConstants searchType = indexConstantsArray[n2];
            Collection<LinkKey> key = IndexManager.createKey(searchType, link);
            if (key != null) {
                keys.addAll(key);
            }
            ++n2;
        }
        return keys;
    }

    public static void addToIndexes(InternalReferenceObject link) throws ReferenceException {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            List<LinkKey> keys = IndexManager.getKeys(link);
            for (LinkKey linkArtifactKey : keys) {
                IReferenceIndex diskBasedReferenceIndex = IndexManager.getIndex(linkArtifactKey);
                diskBasedReferenceIndex.add((Key)linkArtifactKey, link);
            }
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static void deleteFromIndexes(InternalReferenceObject link) throws ReferenceException {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            List<LinkKey> keys = IndexManager.getKeys(link);
            IndexManager.deleteKeys(keys);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static void deleteKeys(Collection<LinkKey> keys) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            for (LinkKey linkArtifactKey : keys) {
                IReferenceIndex diskBasedReferenceIndex = IndexManager.getIndex(linkArtifactKey);
                diskBasedReferenceIndex.delete(linkArtifactKey);
            }
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static void updateFromIndexes(List<LinkKey> oldKeys, InternalReferenceObject newObj) throws ReferenceException {
        IndexManager.waitForIndexes();
        try {
            IReferenceIndex diskBasedReferenceIndex;
            RW_LOCK.writeLock().lock();
            List<LinkKey> newKeys = IndexManager.getKeys(newObj);
            for (LinkKey linkArtifactKey : oldKeys) {
                if (newKeys.remove(linkArtifactKey)) continue;
                diskBasedReferenceIndex = IndexManager.getIndex(linkArtifactKey);
                diskBasedReferenceIndex.delete(linkArtifactKey);
            }
            for (LinkKey linkArtifactKey : newKeys) {
                diskBasedReferenceIndex = IndexManager.getIndex(linkArtifactKey);
                diskBasedReferenceIndex.add((Key)linkArtifactKey, newObj);
            }
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    private static String trimQuotes(String string) {
        if (string == null) {
            return null;
        }
        String result = null;
        result = string.trim();
        if (IndexManager.hasQuotes(result)) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    private static boolean hasQuotes(String string) {
        String s = string.trim();
        char[] chars = s.toCharArray();
        return chars.length >= 2 && (chars[0] == '\'' && chars[chars.length - 1] == '\'' || chars[0] == '\"' && chars[chars.length - 1] == '\"');
    }

    public static void printIndexCacheStats(PrintStream out) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex index : INDEXES.values()) {
                out.println(String.valueOf(index.getIndexName()) + ": ");
                index.printCacheStats(out);
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static void resetCacheStats() {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex index : INDEXES.values()) {
                index.resetCacheStats();
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static void clearCaches() {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex index : INDEXES.values()) {
                index.clearCache();
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static void drainCache(boolean immediate) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex index : INDEXES.values()) {
                index.drainCache(immediate);
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Exception> closeIndexes() {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            Map<String, IReferenceIndex> map = INDEXES;
            synchronized (map) {
                for (IReferenceIndex idx : INDEXES.values()) {
                    try {
                        idx.close();
                    }
                    catch (RuntimeException e) {
                        exceptions.add(e);
                    }
                }
            }
            ArrayList<Exception> arrayList = exceptions;
            return arrayList;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static List<Exception> recreateIndexes() {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (IReferenceIndex idx : INDEXES.values()) {
                try {
                    IndexManager.doConvert(false, null, idx, true);
                }
                catch (RuntimeException e) {
                    exceptions.add(e);
                }
            }
            ArrayList<Exception> arrayList = exceptions;
            return arrayList;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static List<Exception> syncIndexes(boolean ensureDisk) {
        IndexManager.waitForIndexes();
        ArrayList<IReferenceIndex> snapshot = new ArrayList<IReferenceIndex>();
        try {
            RW_LOCK.readLock().lock();
            snapshot.addAll(INDEXES.values());
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (IReferenceIndex idx : snapshot) {
            try {
                if (ensureDisk && !(idx instanceof DiskBasedReferenceIndex)) {
                    throw new RuntimeException("Found a non disk-based index during shutdown: " + idx.getIndexName());
                }
                idx.sync();
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public static void reloadIndexes() {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex idx : INDEXES.values()) {
                idx.reload();
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static void printIndexes() {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex idx : INDEXES.values()) {
                idx.print();
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static Object getTree(File file) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex idx : INDEXES.values()) {
                if (!file.equals(idx.getFile()) || !(idx instanceof DiskBasedReferenceIndex)) continue;
                BPTree bPTree = ((DiskBasedReferenceIndex)idx).getTree();
                return bPTree;
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
        return null;
    }

    public static void printIndexFile(File file, PrintStream stream, boolean includeLinks) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.readLock().lock();
            for (IReferenceIndex idx : INDEXES.values()) {
                if (!file.equals(idx.getFile())) continue;
                idx.print(stream, includeLinks);
            }
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static Set<Integer> getAllLinkIds() {
        IndexManager.waitForIndexes();
        try {
            Set<Integer> ids;
            RW_LOCK.readLock().lock();
            IReferenceIndex index = INDEXES.get(ALL_LINKS_KEY.getIndexName());
            Set<Integer> set = ids = index.search(null, null);
            return set;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static Set<Integer> search(LinkKey key, LinkKey maximumValueKey) {
        IndexManager.waitForIndexes();
        try {
            Set<Integer> ids;
            RW_LOCK.readLock().lock();
            IReferenceIndex index = IndexManager.getIndex(key);
            Set<Integer> set = ids = index.search(key, maximumValueKey);
            return set;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static void addToIndexes(LinkKey key, byte[] bytes) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            IReferenceIndex index = IndexManager.getIndex(key);
            index.add((Key)key, bytes);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static void removeFromIndexes(LinkKey key) {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            IReferenceIndex index = IndexManager.getIndex(key);
            index.delete(key);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static Map<Key, Integer> entries(LinkKey key, Set<Integer> scopeIds) {
        return IndexManager.entries(key.getIndexName(), scopeIds);
    }

    public static Map<Key, Integer> entriesFilteredByKey(String indexName, Set<Integer> scopeIds) {
        IndexManager.waitForIndexes();
        try {
            Map<Key, Integer> entries;
            RW_LOCK.readLock().lock();
            IReferenceIndex index = INDEXES.get(indexName);
            Map<Key, Integer> map = entries = index.entriesFilteredByKey(scopeIds);
            return map;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static Map<Key, Integer> entries(String indexName, Set<Integer> scopeIds) {
        IndexManager.waitForIndexes();
        try {
            Map<Key, Integer> entries;
            RW_LOCK.readLock().lock();
            IReferenceIndex index = INDEXES.get(indexName);
            Map<Key, Integer> map = entries = index.entries(scopeIds);
            return map;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getIndexFiles() {
        IndexManager.waitForIndexes();
        try {
            RW_LOCK.writeLock().lock();
            Map<String, IReferenceIndex> map = INDEXES;
            synchronized (map) {
                ArrayList<File> files = new ArrayList<File>();
                Collection<IReferenceIndex> indexes = INDEXES.values();
                for (IReferenceIndex diskBasedReferenceIndex : indexes) {
                    files.add(diskBasedReferenceIndex.getFile());
                }
                ArrayList<File> arrayList = files;
                return arrayList;
            }
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    private static class Init
    implements Runnable {
        private Init() {
        }

        @Override
        public void run() {
            try {
                ALL_LINKS_KEY = (LinkByLinkTypeKey)LinkByLinkTypeKey.class.newInstance();
            }
            catch (Exception e) {
                InternalAPI.handleFrameworkException(null, Messages.IndexManager_ExceptionDuringStartup, e, EnumSet.of(ErrorEvent.PresentationHints.BLOCK), true);
            }
            boolean interrupted = Thread.interrupted();
            while (true) {
                try {
                    ReferenceDatabase.READY_LATCH.await();
                    ArrayList<KeyConfig> keys = new ArrayList<KeyConfig>();
                    keys.add(new KeyConfig(ReferenceByLinkIdKey.class, new IntPairComparator(), 8, 8, 4));
                    keys.add(new KeyConfig(ResolvedReferenceBySourceLinkId.class, new IntPairComparator(), 8, 8, 4));
                    keys.add(new KeyConfig(ResolvedReferenceByTargetLinkId.class, new IntPairComparator(), 8, 8, 4));
                    keys.add(new KeyConfig(ResolvedReferenceByReferenceIdKey.class, new IntPairComparator(), 8, 8, 4));
                    keys.add(new KeyConfig(ReferenceByTypeKey.class, new IntPairComparator(), 8, 8, 4));
                    keys.add(new KeyConfig(LinkByLinkTypeKey.class, new IntPairComparator(), 8, 8, 4));
                    keys.add(new KeyConfig(LinkByLinkNameKey.class, new StringIntPairComparator(), -1, 64, 4));
                    keys.add(new KeyConfig(LinkByLinkTextKey.class, new StringIntPairComparator(), -1, 96, 4));
                    keys.add(new KeyConfig(LinkBySourcePathKey.class, new StringIntPairComparator(), -1, 128, 4));
                    keys.add(new KeyConfig(ResolvedReferenceByModelInstanceRefKey.class, new StringIntPairComparator(), -1, 128, 4));
                    keys.add(new KeyConfig(ResolvedReferenceByTargetPathKey.class, new StringIntPairComparator(), -1, 128, 4));
                    keys.add(new KeyConfig(ResolvedReferenceBySourcePathKey.class, new StringIntPairComparator(), -1, 128, 4));
                    keys.add(new KeyConfig(LinkByTypeBySourcePathKey.class, new IntStringIntComparator(), -1, 136, 4));
                    HashMap<String, DiskBasedReferenceIndex> tmpIndex = new HashMap<String, DiskBasedReferenceIndex>(IndexConstants.values().length);
                    for (KeyConfig config : keys) {
                        IndexKeyFactory factory = IndexManager.createFactory(config);
                        LinkKey key = factory.createKey();
                        String indexName = key.getIndexName();
                        File indexFile = new File(Activator.getDatabaseDirectory(), indexName);
                        FILETOKEY.put(key.getIndexName(), factory);
                        try {
                            DiskBasedReferenceIndex index = new DiskBasedReferenceIndex(indexFile, indexName, factory, config.dataSize);
                            tmpIndex.put(indexName, index);
                        }
                        catch (RuntimeException e) {
                            Status status = new Status(4, "com.ibm.etools.references", "Exception during index initialization, creating new index. Cause: " + e.getClass().getSimpleName(), (Throwable)e);
                            Logger.log((IStatus)status);
                            try {
                                DiskBasedReferenceIndex index = new DiskBasedReferenceIndex(indexFile, indexName, factory, config.dataSize, true);
                                tmpIndex.put(indexName, index);
                            }
                            catch (RuntimeException ee) {
                                Status doubleFault = new Status(4, "com.ibm.etools.references", "Double fault during index initialization, could NOT create new index. Cause: " + e.getClass().getSimpleName(), (Throwable)ee);
                                Logger.log((IStatus)doubleFault);
                            }
                        }
                    }
                    DISK = Collections.unmodifiableMap(tmpIndex);
                    INDEXES = new HashMap(DISK);
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class KeyConfig {
        public Class<? extends LinkKey> clazz;
        public int size;
        public int averagesize;
        public int dataSize;
        public Comparator<KeyInfo> comparator;

        public KeyConfig(Class<? extends LinkKey> clazz, Comparator<KeyInfo> comparator, int size, int averagesize, int datasize) {
            this.clazz = clazz;
            this.size = size;
            this.averagesize = averagesize;
            this.dataSize = datasize;
            this.comparator = comparator;
        }
    }
}

