/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.TreeInconsistencyException;
import com.ibm.etools.references.internal.index.IReferenceIndex;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.IntPairLinkKey;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class HeapBasedReferenceIndex
implements IReferenceIndex {
    private final TreeMap<Key, byte[]> index;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock write = this.lock.writeLock();
    private final ReentrantReadWriteLock.ReadLock read = this.lock.readLock();
    private final File indexFile;
    private final String indexName;

    public HeapBasedReferenceIndex(File indexFile, String indexName, Comparator c) {
        this.indexFile = indexFile;
        this.indexName = indexName;
        this.index = new TreeMap(c);
    }

    @Override
    public IReferenceIndex newIndex() {
        return new HeapBasedReferenceIndex(this.indexFile, this.indexName, this.index.comparator());
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    private IStatus createStatus(String errorString, Exception e) {
        String eString = errorString;
        Status status = new Status(4, "com.ibm.etools.references", eString, (Throwable)e);
        return status;
    }

    private void assertStuff() throws TreeInconsistencyException {
    }

    private int itrCount(Iterator<Map.Entry<Key, byte[]>> itr) throws TreeInconsistencyException {
        int c = 0;
        Key prev = null;
        while (itr.hasNext()) {
            Map.Entry<Key, byte[]> entry = itr.next();
            if (c != 0 && prev != null) {
                Key current = entry.getKey();
                if (this.index.comparator().compare(current, prev) <= 0) {
                    throw new TreeInconsistencyException(Messages.bTreeMsg_incorrect_key_ordering);
                }
            }
            prev = entry.getKey();
            ++c;
        }
        return c;
    }

    @Override
    public void add(Key linkArtifactKey, IReferenceElement artifact) throws ReferenceException {
        try {
            try {
                this.write.lock();
                int id = artifact.getId();
                this.index.put(linkArtifactKey, ByteUtils.intToBytes(id).array());
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, (Object)artifact), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void add(Key linkArtifactKey, byte[] bytes) throws ReferenceException {
        try {
            try {
                this.write.lock();
                this.index.put(linkArtifactKey, bytes);
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, (Object)bytes), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void addAll(Iterator<?> entryItr, boolean replace, IProgressMonitor monitor, int itrSize) throws ReferenceException {
        Map.Entry entry = null;
        try {
            try {
                monitor.beginTask("", itrSize);
                this.write.lock();
                if (replace) {
                    this.recreate();
                }
                while (entryItr.hasNext()) {
                    entry = (Map.Entry)entryItr.next();
                    this.index.put((Key)entry.getKey(), (byte[])entry.getValue());
                    monitor.worked(1);
                }
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                IStatus status = null;
                status = entry != null && entry.getKey() != null ? this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, entry.getKey()), e) : this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, (Object)""), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void close() {
        throw new RuntimeException(Messages.errorMsg_HeapBasedReferenceIndex_nocloseheapindex);
    }

    @Override
    public void delete(Key artifact) throws ReferenceException {
        try {
            try {
                this.write.lock();
                this.index.remove(artifact);
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_deleting_key_x, (Object)artifact), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void delete() {
        try {
            this.write.lock();
            this.index.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Map<Key, Integer> entries(Set<Integer> valueIds) {
        HashMap<Key, Integer> hashMap = new HashMap<Key, Integer>();
        try {
            this.read.lock();
            for (Map.Entry<Key, byte[]> entry : this.index.entrySet()) {
                Key key = entry.getKey();
                int id = ByteUtils.bytesToInt(ByteBuffer.wrap(entry.getValue()));
                if (valueIds == null) {
                    hashMap.put(key, id);
                    continue;
                }
                if (!valueIds.contains(id)) continue;
                hashMap.put(key, id);
            }
        }
        finally {
            this.read.unlock();
        }
        return hashMap;
    }

    @Override
    public Map<Key, Integer> entriesFilteredByKey(Set<Integer> keyIds) {
        HashMap<Key, Integer> hashMap = new HashMap<Key, Integer>();
        try {
            this.read.lock();
            for (Map.Entry<Key, byte[]> entry : this.index.entrySet()) {
                int id;
                Key key = entry.getKey();
                IntPairLinkKey pair = (IntPairLinkKey)key;
                if (keyIds == null) {
                    id = ByteUtils.bytesToInt(entry.getValue());
                    hashMap.put(key, id);
                    continue;
                }
                if (!keyIds.contains(pair.getInt1())) continue;
                id = ByteUtils.bytesToInt(entry.getValue());
                hashMap.put(key, id);
            }
        }
        finally {
            this.read.unlock();
        }
        return hashMap;
    }

    @Override
    public File getFile() {
        return this.indexFile;
    }

    @Override
    public void print() {
        this.print(System.out, true);
    }

    @Override
    public void print(PrintStream stream, boolean includeLinks) {
        try {
            this.read.lock();
            stream.println("Iteration: ");
            Iterator<Map.Entry<Key, byte[]>> itr = this.index.entrySet().iterator();
            int count = 0;
            while (itr.hasNext()) {
                Map.Entry<Key, byte[]> entry = itr.next();
                stream.print("Key: " + entry.getKey());
                stream.print(" Value: " + this.printData(entry.getValue()));
                if (includeLinks) {
                    int id = ByteUtils.bytesToInt(ByteBuffer.wrap(entry.getValue()));
                    stream.println(" Link: " + ReferenceDatabase.getDefault().getReferenceElement(id));
                } else {
                    stream.println();
                }
                ++count;
            }
            stream.println("Tree size: " + this.index.size() + " iteration count: " + count);
        }
        finally {
            this.read.unlock();
        }
    }

    private String printData(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            buf.append(String.valueOf(b) + ",");
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void recreate() {
        this.delete();
    }

    @Override
    public void reload() {
    }

    @Override
    public Set<Integer> search(Key start, Key end) throws ReferenceException {
        HashSet<Integer> results = new HashSet<Integer>();
        try {
            try {
                this.read.lock();
                for (Map.Entry entry : this.index.subMap(start, true, end, true).entrySet()) {
                    int id = ByteUtils.bytesToInt(ByteBuffer.wrap((byte[])entry.getValue()));
                    results.add(id);
                }
            }
            catch (TreeInconsistencyException e) {
                IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_searching_key_x, (Object)start), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.read.unlock();
        }
        return results;
    }

    @Override
    public IReferenceIndex convertToDisk(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        try {
            this.write.lock();
            int size = this.index.size();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
            Iterator<Map.Entry<Key, byte[]>> entryItr = this.index.entrySet().iterator();
            targetIndex.addAll(entryItr, true, (IProgressMonitor)sub.newChild(size), size);
            this.assertStuff();
        }
        finally {
            this.write.unlock();
        }
        return targetIndex;
    }

    @Override
    public IReferenceIndex convertToHeap(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        return this;
    }

    @Override
    public void sync() {
    }

    @Override
    public void printCacheStats(PrintStream out) {
        out.print("Heap-based: no-cache");
    }

    @Override
    public void resetCacheStats() {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void drainCache(boolean immediate) {
    }

    @Override
    public int getSize() {
        try {
            this.read.lock();
            int n = this.index.size();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }
}

