/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.search.InternalSearchScope;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import java.util.ArrayList;
import java.util.List;

public class EventCollector {
    private final List<ReferenceEvent> events = new ArrayList<ReferenceEvent>();

    public void addEvent(ReferenceEvent event) {
        if (Logger.SHOULD_TRACE_EVENT_DETAILED) {
            Logger.trace(Logger.Category.EVENT_DETAILED, event.toString(), new Throwable[0]);
        }
        this.events.add(event);
        if (event.getReferenceElement().getElementType() == IReferenceElement.ElementType.LINK) {
            if (event.getKind() == ReferenceEvent.Kind.ADD) {
                InternalSearchScope.addLink((ILink)event.getReferenceElement());
            } else if (event.getKind() == ReferenceEvent.Kind.REMOVE) {
                InternalSearchScope.removeLink((ILink)event.getReferenceElement());
            }
        }
    }

    public List<ReferenceEvent> getEvents() {
        return this.events;
    }
}

