/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.tree.BPTree;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.TreeInconsistencyException;
import com.ibm.etools.references.internal.index.IReferenceIndex;
import com.ibm.etools.references.internal.index.keys.IndexKeyFactory;
import com.ibm.etools.references.internal.index.keys.IntPairLinkKey;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class DiskBasedReferenceIndex
implements IReferenceIndex {
    private final BPTree tree;
    private final String indexName;

    public DiskBasedReferenceIndex(File indexFile, String indexName, IndexKeyFactory indexKeyFactory, int dataSize) throws FatalIOException {
        this(indexFile, indexName, indexKeyFactory, dataSize, false);
    }

    public DiskBasedReferenceIndex(File indexFile, String indexName, IndexKeyFactory indexKeyFactory, int dataSize, boolean create) throws FatalIOException {
        this.indexName = indexName;
        this.tree = new BPTree(indexFile, InternalAPI.Tweaks.INDEX_CACHE_SIZE, InternalAPI.Tweaks.INDEX_BRANCHES, InternalAPI.Tweaks.INDEX_NODES_PER_EXTENT, indexKeyFactory, dataSize, create);
    }

    @Override
    public IReferenceIndex newIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public File getFile() {
        return this.tree.getFile();
    }

    @Override
    public void add(Key linkArtifactKey, IReferenceElement artifact) throws ReferenceException {
        try {
            int id = artifact.getId();
            this.tree.insert(linkArtifactKey, ByteUtils.intToBytes(id).array());
        }
        catch (TreeInconsistencyException e) {
            IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, (Object)artifact), e);
            throw new ReferenceException(status);
        }
    }

    @Override
    public void add(Key linkArtifactKey, byte[] bytes) throws ReferenceException {
        try {
            this.tree.insert(linkArtifactKey, bytes);
        }
        catch (TreeInconsistencyException e) {
            IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, (Object)bytes), e);
            throw new ReferenceException(status);
        }
    }

    @Override
    public void addAll(Iterator<?> entryItr, boolean replace, IProgressMonitor monitor, int itrSize) throws ReferenceException {
        monitor.beginTask("", itrSize);
        Map.Entry entry = null;
        this.tree.beginWrite();
        try {
            try {
                if (replace) {
                    this.recreate();
                }
                while (entryItr.hasNext()) {
                    entry = (Map.Entry)entryItr.next();
                    this.tree.insert((Key)entry.getKey(), (byte[])entry.getValue());
                    monitor.worked(1);
                }
            }
            catch (TreeInconsistencyException e) {
                IStatus status = null;
                status = entry != null && entry.getKey() != null ? this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, entry.getKey()), e) : this.createStatus(NLS.bind((String)Messages.errorMsg_error_adding_key_x, (Object)""), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.tree.endWrite();
        }
    }

    @Override
    public void delete(Key artifact) throws ReferenceException {
        try {
            this.tree.delete(artifact);
        }
        catch (TreeInconsistencyException e) {
            IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_deleting_key_x, (Object)artifact), e);
            throw new ReferenceException(status);
        }
    }

    private IStatus createStatus(String errorString, Exception e) {
        String eString = errorString;
        Status status = new Status(4, "com.ibm.etools.references", eString, (Throwable)e);
        return status;
    }

    @Override
    public Set<Integer> search(Key start, Key end) throws ReferenceException {
        HashSet<Integer> results = new HashSet<Integer>();
        try {
            try {
                this.tree.beginRead();
                Iterator<Map.Entry<Key, byte[]>> itr = this.tree.iterator(start, end);
                while (itr.hasNext()) {
                    Map.Entry<Key, byte[]> entry = itr.next();
                    int id = ByteUtils.bytesToInt(entry.getValue());
                    results.add(id);
                }
            }
            catch (TreeInconsistencyException e) {
                IStatus status = this.createStatus(NLS.bind((String)Messages.errorMsg_error_searching_key_x, (Object)start), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.tree.endRead();
        }
        return results;
    }

    @Override
    public Map<Key, Integer> entries(Set<Integer> valueIds) {
        HashMap<Key, Integer> hashMap = new HashMap<Key, Integer>();
        try {
            this.tree.beginRead();
            Iterator<Map.Entry<Key, byte[]>> iterator = this.tree.iterator(null, null);
            while (iterator.hasNext()) {
                Map.Entry<Key, byte[]> entry = iterator.next();
                LinkKey key = (LinkKey)entry.getKey();
                int id = ByteUtils.bytesToInt(entry.getValue());
                if (valueIds == null) {
                    hashMap.put(key, id);
                    continue;
                }
                if (!valueIds.contains(id)) continue;
                hashMap.put(key, id);
            }
        }
        finally {
            this.tree.endRead();
        }
        return hashMap;
    }

    @Override
    public Map<Key, Integer> entriesFilteredByKey(Set<Integer> keyIds) {
        HashMap<Key, Integer> hashMap = new HashMap<Key, Integer>();
        try {
            this.tree.beginRead();
            Iterator<Map.Entry<Key, byte[]>> iterator = this.tree.iterator(null, null);
            while (iterator.hasNext()) {
                int id;
                Map.Entry<Key, byte[]> entry = iterator.next();
                LinkKey key = (LinkKey)entry.getKey();
                IntPairLinkKey pair = (IntPairLinkKey)key;
                if (keyIds == null) {
                    id = ByteUtils.bytesToInt(entry.getValue());
                    hashMap.put(key, id);
                    continue;
                }
                if (!keyIds.contains(pair.getInt1())) continue;
                id = ByteUtils.bytesToInt(entry.getValue());
                hashMap.put(key, id);
            }
        }
        finally {
            this.tree.endRead();
        }
        return hashMap;
    }

    @Override
    public void delete() {
        this.tree.delete();
    }

    @Override
    public void recreate() {
        this.tree.recreate();
    }

    @Override
    public void reload() {
        this.tree.reload();
    }

    @Override
    public void print() {
        this.print(System.out, true);
    }

    @Override
    public void print(PrintStream stream, boolean includeLinks) {
        this.tree.printToStream(stream, false, includeLinks);
    }

    @Override
    public void close() {
        this.tree.close(true);
    }

    @Override
    public String toString() {
        return "Index: " + this.tree.getFile();
    }

    @Override
    public IReferenceIndex convertToDisk(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        return this;
    }

    @Override
    public IReferenceIndex convertToHeap(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        if (targetIndex instanceof DiskBasedReferenceIndex) {
            Assert.isTrue((boolean)false, (String)Messages.DiskBasedReferenceIndex_0);
        }
        try {
            this.tree.beginRead();
            int size = this.tree.getSize();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
            Iterator<Map.Entry<Key, byte[]>> entryItr = this.tree.iterator(null, null);
            targetIndex.addAll(entryItr, true, (IProgressMonitor)sub.newChild(size), size);
        }
        finally {
            this.tree.endRead();
        }
        return targetIndex;
    }

    @Override
    public void sync() {
        this.tree.sync();
    }

    @Override
    public void printCacheStats(PrintStream out) {
        this.tree.printCacheStats(out);
    }

    @Override
    public void resetCacheStats() {
        this.tree.resetCacheStats();
    }

    @Override
    public void clearCache() {
        this.tree.clearCache();
    }

    @Override
    public void drainCache(boolean immediate) {
        this.tree.drainCache(immediate);
    }

    @Override
    public int getSize() {
        return this.tree.getSize();
    }

    public BPTree getTree() {
        return this.tree;
    }
}

