/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.cache;

import java.util.Collection;

public abstract class Cache<K, V> {
    protected final int size;
    protected int hits;
    protected int accesses;

    public Cache(int size) {
        this.size = size;
    }

    public abstract V get(K var1);

    public abstract V remove(K var1);

    public abstract V put(K var1, V var2);

    public abstract Collection<V> values();

    protected void removeFromCache(K key, V value) {
    }

    public void clear() {
        this.resetStats();
    }

    public final float getHitRatio() {
        return (float)this.hits / (float)this.accesses * 100.0f;
    }

    public final void resetStats() {
        this.hits = 0;
        this.accesses = 0;
    }
}

