/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.cache;

import com.ibm.etools.references.internal.cache.Cache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class ARCCache<K, V>
extends Cache<K, V> {
    private int targetsize = 0;
    private final LinkedHashSet LRU_T = new LinkedHashSet();
    private final LinkedHashSet LRU_B = new LinkedHashSet();
    private final LinkedHashSet LFU_T = new LinkedHashSet();
    private final LinkedHashSet LFU_B = new LinkedHashSet();
    private final HashMap<K, V> cache = new HashMap();

    public ARCCache(int size) {
        super(size);
    }

    @Override
    public final V get(K key) {
        V value = this.cache.get(key);
        if (value != null) {
            ++this.hits;
            if (this.LRU_T.remove(key) || this.LFU_T.remove(key)) {
                this.LFU_T.put(key);
            }
        }
        ++this.accesses;
        return value;
    }

    @Override
    public V remove(K key) {
        V val = this.cache.remove(key);
        if (val != null) {
            this.removeFromCache(key, val);
        }
        return val;
    }

    @Override
    public V put(K key, V value) {
        if (this.LRU_T.remove(key) || this.LFU_T.remove(key)) {
            this.LFU_T.put(key);
        } else {
            boolean lru_contains = this.LRU_B.contains(key);
            boolean lfu_contains = this.LFU_B.contains(key);
            if (lru_contains) {
                this.targetsize = Math.min(this.size, this.targetsize + Math.max(this.LFU_B.size() / this.LRU_B.size(), 1));
                this.replace(lfu_contains);
                this.LRU_B.remove(key);
                this.LFU_T.put(key);
            } else if (lfu_contains) {
                this.targetsize = Math.max(0, this.targetsize - Math.max(this.LRU_B.size() / this.LFU_B.size(), 1));
                this.replace(lfu_contains);
                this.LFU_B.remove(key);
                this.LFU_T.put(key);
            } else {
                int lru_totalsize = this.LRU_T.size() + this.LRU_B.size();
                int lfu_totalsize = this.LFU_T.size() + this.LFU_B.size();
                int totalcache = lru_totalsize + lfu_totalsize;
                if (lru_totalsize == this.size) {
                    if (this.LRU_T.size() < this.size) {
                        this.LRU_B.removeLast();
                        this.replace(lfu_contains);
                    } else {
                        Object k = this.LRU_T.removeLast();
                        V val = this.cache.remove(k);
                        if (val != null) {
                            this.removeFromCache(key, val);
                        }
                    }
                } else if (lru_totalsize > this.size) {
                    Assert.isLegal((boolean)false, (String)"Internal inconsitency");
                } else if (totalcache >= this.size) {
                    if (totalcache == 2 * this.size) {
                        this.LFU_B.removeLast();
                    }
                    this.replace(lfu_contains);
                }
                this.LRU_T.put(key);
            }
        }
        V oldval = this.cache.put(key, value);
        return oldval;
    }

    @Override
    public final Collection<V> values() {
        return this.cache.values();
    }

    @Override
    protected void removeFromCache(K key, V value) {
    }

    private void replace(boolean lfu_contains) {
        if (this.LRU_T.size() >= 1 && (this.LRU_T.size() > this.targetsize || lfu_contains && this.LRU_T.size() == this.targetsize)) {
            Object key = this.LRU_T.removeLast();
            if (key != null) {
                this.LRU_B.put(key);
                V val = this.cache.remove(key);
                if (val != null) {
                    this.removeFromCache(key, val);
                }
            }
        } else {
            Object key = this.LFU_T.removeLast();
            if (key != null) {
                this.LFU_B.put(key);
                V val = this.cache.remove(key);
                if (val != null) {
                    this.removeFromCache(key, val);
                }
            }
        }
    }

    @Override
    public final void clear() {
        super.clear();
        this.LRU_T.clear();
        this.LRU_B.clear();
        this.LFU_T.clear();
        this.LFU_B.clear();
        this.cache.clear();
        this.targetsize = 0;
    }

    public class LinkedHashSet
    implements Iterable<K> {
        private final V PRESENT = new Object();
        private boolean shouldremove = false;
        private K lastholder = null;
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (LinkedHashSet.this.shouldremove) {
                    LinkedHashSet.this.lastholder = eldest.getKey();
                }
                return LinkedHashSet.this.shouldremove;
            }
        };

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        public V put(K key) {
            return this.map.put(key, this.PRESENT);
        }

        public boolean remove(K key) {
            return this.map.remove(key) == this.PRESENT;
        }

        public void clear() {
            this.map.clear();
        }

        public int size() {
            return this.map.size();
        }

        public boolean contains(K key) {
            return this.map.containsKey(key);
        }

        public K removeLast() {
            try {
                this.shouldremove = true;
                this.map.put(null, this.PRESENT);
                this.map.remove(null);
                Object val = this.lastholder;
                this.lastholder = null;
                Object k = val;
                return k;
            }
            finally {
                this.shouldremove = false;
            }
        }
    }
}

