/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.tree;

import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.BPTree;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.KeyInfo;
import com.ibm.etools.references.internal.bplustree.tree.OverflowedKeyRecord;
import com.ibm.etools.references.internal.bplustree.tree.TreeInconsistencyException;
import com.ibm.etools.references.internal.nls.Messages;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class Node
extends DBRecord {
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    public static final int DELETED = -1;
    public static final int INNER = 2;
    public static final int LEAF = 1;
    final BPTree tree;
    PooledByteBuffer pooled;
    private ByteBuffer buffer;
    int modcount = 0;
    final CachingList<KeyInfo> KEYINFOS;
    final CachingList<Key> KEYLIST;
    final List<Node> CHILDRENLIST;
    final CachingList<byte[]> DATALIST;

    public Node(int style, BPTree tree) {
        super(style);
        this.tree = tree;
        this.KEYINFOS = new KeyInfos(tree);
        this.KEYLIST = new KeyList(tree);
        this.CHILDRENLIST = new ChildList();
        this.DATALIST = new DataList(tree);
    }

    public void init() throws TreeInconsistencyException {
        try {
            this.tree.nodeExtents.assignId(this);
            this.pooled = this.tree.nodeExtents.allocate(this);
            this.setBuffer(this.pooled.buffer);
        }
        catch (RuntimeException e) {
            int[] ints = ByteUtils.intToUnsignedShorts(this.getId());
            throw new TreeInconsistencyException(NLS.bind((String)Messages.bTreeMsg_Node_exception_during_initialization_x_y, (Object)ints[0], (Object)ints[1]), e);
        }
        byte[] blanker = new byte[this.getBuffer().remaining()];
        Arrays.fill(blanker, (byte)-1);
        this.getBuffer().put(blanker);
        this.getBuffer().putInt(0, 0);
        this.getBuffer().rewind();
    }

    public CachingList<KeyInfo> getKeyInfos() {
        return this.KEYINFOS;
    }

    public CachingList<Key> getKeys() {
        return this.KEYLIST;
    }

    public CachingList<byte[]> getData() {
        return this.DATALIST;
    }

    public List<Node> getChildren() {
        return this.CHILDRENLIST;
    }

    public boolean isLeaf() {
        return this.getDataType() == 1;
    }

    public int getFillSize() {
        int fillSize = -1;
        if (this.getBuffer() == null) {
            Assert.isNotNull((Object)this.getBuffer(), (String)Messages.bTreeMsg_nodebuffernull);
        }
        fillSize = this.getBuffer().getInt(0);
        return fillSize;
    }

    @Override
    public boolean isDirty() {
        boolean ret = this.modcount > 0;
        return ret;
    }

    @Override
    public void clean() {
        this.modcount = 0;
    }

    public Node addEntry(KeyInfo key, byte[] data, int offset, int pos) throws TreeInconsistencyException {
        Node ret = this;
        int keySize = this.tree.keySize;
        int dataSize = data.length;
        int curFillSize = this.getFillSize();
        int newSize = curFillSize + 1;
        int median = newSize + 1 >> 1;
        if (pos >= 0 && pos < curFillSize) {
            --newSize;
            this.tree.decSize();
        } else {
            key.commit();
        }
        int insertPos = -1;
        insertPos = pos < 0 ? -pos - 1 : Math.abs(pos);
        int startOffset = 4 + offset + (keySize + dataSize) * insertPos;
        if (curFillSize == this.tree.branches - 1 && newSize > curFillSize) {
            ret = (Node)this.tree.nodeExtents.getFactory().createRecord(this.getDataType(), this.tree.nodeExtents);
            ret.init();
            if (this.isLeaf()) {
                int ptrOffset = 4 + offset + (keySize + dataSize) * (this.tree.branches - 1);
                this.getBuffer().limit(ptrOffset + 4);
                this.getBuffer().position(ptrOffset);
                this.getBuffer().mark();
                ret.getBuffer().limit(ptrOffset + 4);
                ret.getBuffer().position(ptrOffset);
                ret.getBuffer().put(this.getBuffer());
                this.getBuffer().reset();
                this.getBuffer().putInt(ret.getId());
            }
            ByteBuffer splitNodeBuffer = ret.getBuffer();
            if (!this.isLeaf()) {
                ret.getBuffer().putInt(4, -1);
            }
            int recordsAtAndAboveMedian = curFillSize + 1 - median;
            int medianOffset = 4 + offset + (keySize + dataSize) * (median - 1);
            int endMedianRange = medianOffset + (keySize + dataSize) * recordsAtAndAboveMedian;
            int insertPosOffset = 4 + offset + (keySize + dataSize) * insertPos;
            if (insertPosOffset >= medianOffset && insertPosOffset < endMedianRange) {
                this.getBuffer().limit(insertPosOffset);
                this.getBuffer().position(medianOffset);
                splitNodeBuffer.rewind();
                splitNodeBuffer.putInt(recordsAtAndAboveMedian + 1);
                splitNodeBuffer.position(splitNodeBuffer.position() + offset);
                splitNodeBuffer.put(this.getBuffer());
                this.writeKeyToBuffer(key.writeKeyData(), splitNodeBuffer);
                splitNodeBuffer.put(data);
                this.getBuffer().limit(endMedianRange);
                this.getBuffer().position(insertPosOffset);
                splitNodeBuffer.put(this.getBuffer());
                newSize -= recordsAtAndAboveMedian + 1;
            } else {
                int addedToOverflow = 0;
                if (insertPosOffset == endMedianRange) {
                    ++addedToOverflow;
                } else {
                    medianOffset -= keySize + dataSize;
                    ++addedToOverflow;
                }
                this.getBuffer().limit(endMedianRange);
                this.getBuffer().position(medianOffset);
                splitNodeBuffer.rewind();
                splitNodeBuffer.putInt(recordsAtAndAboveMedian + addedToOverflow);
                splitNodeBuffer.position(splitNodeBuffer.position() + offset);
                splitNodeBuffer.put(this.getBuffer());
                if (insertPosOffset == endMedianRange) {
                    this.writeKeyToBuffer(key.writeKeyData(), splitNodeBuffer);
                    splitNodeBuffer.put(data);
                }
                newSize -= recordsAtAndAboveMedian + addedToOverflow;
            }
            ++ret.modcount;
            this.tree.updateNode(ret);
        }
        if (insertPos < median || newSize > curFillSize) {
            if (insertPos < newSize - 1 && newSize != curFillSize) {
                this.getKeyInfos().clearCaches(insertPos);
                this.getKeys().clearCaches(insertPos);
                this.getData().clearCaches(insertPos);
                int newPosOffset = 4 + offset + (keySize + dataSize) * insertPos + keySize + dataSize;
                int entriesAboveInsert = newSize - 1 - insertPos;
                int entryRange = (keySize + dataSize) * entriesAboveInsert;
                int lastDataOffset = 4 + offset + (keySize + dataSize) * (this.tree.branches - 1);
                int endRange = newPosOffset + entryRange;
                if (endRange <= lastDataOffset) {
                    this.getBuffer().limit(endRange);
                    this.getBuffer().position(newPosOffset);
                    ByteBuffer destination = this.getBuffer().slice();
                    this.getBuffer().limit(startOffset + entryRange);
                    this.getBuffer().position(startOffset);
                    if (BPTree.MMAP_BUG && this.affectedByBug(startOffset, startOffset + entryRange, newPosOffset, endRange)) {
                        int capacity = this.getBuffer().limit() - this.getBuffer().position();
                        this.tree.TMP_BUFFER.limit(capacity);
                        this.tree.TMP_BUFFER.position(0);
                        this.tree.TMP_BUFFER.put(this.getBuffer());
                        this.tree.TMP_BUFFER.rewind();
                        destination.put(this.tree.TMP_BUFFER);
                    } else {
                        destination.put(this.getBuffer());
                    }
                }
            }
            this.getBuffer().limit(this.getSize());
            if (newSize == curFillSize) {
                this.getBuffer().position(startOffset + this.tree.keySize);
            } else {
                this.getBuffer().position(startOffset);
                this.writeKeyToBuffer(key.writeKeyData(), this.getBuffer());
            }
            this.getBuffer().put(data);
            ++this.modcount;
        }
        if (curFillSize != newSize) {
            this.getBuffer().putInt(0, newSize);
            ++this.modcount;
        }
        this.tree.updateNode(this);
        return ret;
    }

    private void writeKeyToBuffer(ByteBuffer keydata, ByteBuffer targetBuffer) {
        keydata.rewind();
        Assert.isTrue((keydata.remaining() <= this.tree.keySize ? 1 : 0) != 0);
        int padding = this.tree.keySize - keydata.remaining();
        targetBuffer.put(keydata);
        targetBuffer.position(targetBuffer.position() + padding);
    }

    public Node addData(KeyInfo key, byte[] data, int pos) throws TreeInconsistencyException {
        Node ret = this;
        if (!this.isLeaf()) {
            throw new UnsupportedOperationException(Messages.bTreeMsg_Node_Cant_add_data_to_non_data_node);
        }
        ret = this.addEntry(key, data, 0, pos);
        return ret;
    }

    public Node addKey(KeyInfo key, Node overflow, int index) throws TreeInconsistencyException {
        ByteBuffer nodeId = ByteBuffer.allocate(4);
        nodeId.putInt(overflow.getId());
        Node ret = this.addEntry(key, nodeId.array(), 4, index);
        return ret;
    }

    public Node getNextNode() throws TreeInconsistencyException {
        int ptrOffset = 4 + (this.tree.keySize + this.tree.dataSize) * (this.tree.branches - 1);
        this.getBuffer().limit(ptrOffset + 4);
        this.getBuffer().position(ptrOffset);
        int nextNodeId = this.getBuffer().getInt();
        return this.tree.getNode(nextNodeId);
    }

    public boolean isFull() {
        return this.getFillSize() >= this.tree.branches - 1;
    }

    @Override
    public int getSize() {
        if (this.getDataType() == 1) {
            return this.tree.leafNodeSize;
        }
        if (this.getDataType() == 2) {
            return this.tree.innerNodeSize;
        }
        return -1;
    }

    @Override
    public void readRecord(PooledByteBuffer input) {
        this.tree.beginRead();
        try {
            Assert.isNotNull((Object)input, (String)"Null node input");
            this.pooled = input;
            this.setBuffer(input.buffer);
            Assert.isNotNull((Object)input.buffer, (String)"Null node input");
            this.getBuffer().rewind();
        }
        finally {
            this.tree.endRead();
        }
    }

    @Override
    public PooledByteBuffer writeRecord() {
        this.tree.beginWrite();
        try {
            this.getBuffer().limit(this.getSize());
            this.getBuffer().rewind();
            PooledByteBuffer tmp = this.pooled;
            this.setBuffer(null);
            this.pooled = null;
            PooledByteBuffer pooledByteBuffer = tmp;
            return pooledByteBuffer;
        }
        finally {
            this.tree.endWrite();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.pooled != null) {
            this.pooled.returnBuffer();
        }
        this.setBuffer(null);
        this.pooled = null;
    }

    public void createRoot(int leftNodeId, KeyInfo key, int rightNodeId) {
        this.getBuffer().position(0);
        this.getBuffer().putInt(1);
        this.getBuffer().putInt(leftNodeId);
        this.writeKeyToBuffer(key.writeKeyData(), this.getBuffer());
        this.getBuffer().putInt(rightNodeId);
        ++this.modcount;
    }

    public boolean isMinimal() {
        return this.isMinimal(this.getFillSize());
    }

    private boolean isMinimal(int size) {
        return size == (this.tree.branches + 1 >> 1) - 1;
    }

    public Node removeData(int insertionPt, Node left, Node right, Node leftAnchor, Node rightAnchor, Node parent) throws TreeInconsistencyException {
        Node ret = null;
        if (this.isMinimal() && this != this.tree.getRootNode()) {
            KeyInfo realKeyToRemove = (KeyInfo)this.getKeyInfos().get(insertionPt);
            realKeyToRemove.decrement();
            realKeyToRemove.dispose();
            if (left == null && right == null) {
                this.removeEntry(insertionPt, this.tree.dataSize);
                ++this.modcount;
                this.tree.updateNode(this);
                return this;
            }
            if (left == null) {
                this.tree.balanceNode = right;
            } else if (right == null) {
                this.tree.balanceNode = left;
            } else {
                Node node = this.tree.balanceNode = left.getFillSize() <= right.getFillSize() ? right : left;
            }
            if (this.tree.balanceNode.isMinimal()) {
                Node anchorNode = parent;
                Node mergeNode = null;
                if (anchorNode == leftAnchor && left != null) {
                    mergeNode = left;
                } else if (anchorNode == rightAnchor && right != null) {
                    mergeNode = right;
                }
                boolean bl = this.tree.rightshiftormerge = mergeNode == right;
                if (!this.tree.rightshiftormerge) {
                    int nextId = this.getNextNodeId();
                    int ptrOffset = 4 + (this.tree.keySize + this.tree.dataSize) * (this.tree.branches - 1);
                    left.getBuffer().limit(ptrOffset + 4);
                    left.getBuffer().position(ptrOffset);
                    left.getBuffer().putInt(nextId);
                    ++left.modcount;
                    this.tree.updateNode(left);
                }
                this.merge(mergeNode, anchorNode, mergeNode == right, insertionPt);
                this.tree.balanceNode = mergeNode;
                if (mergeNode == left) {
                    this.tree.newkey = null;
                } else {
                    Node bNode = mergeNode;
                    bNode.getBuffer().limit(4 + this.tree.keySize);
                    bNode.getBuffer().position(4);
                    this.tree.newkey = new byte[this.tree.keySize];
                    bNode.getBuffer().get(this.tree.newkey);
                }
                ret = this;
            } else {
                Node anchorNode = this.tree.balanceNode == right ? rightAnchor : leftAnchor;
                this.tree.rightshiftormerge = this.tree.balanceNode == right;
                this.shift(this.tree.balanceNode, anchorNode, this.tree.balanceNode == left, insertionPt);
                if (this.tree.balanceNode == left) {
                    this.getBuffer().limit(4 + this.tree.keySize);
                    this.getBuffer().position(4);
                    this.tree.newkey = new byte[this.tree.keySize];
                    this.getBuffer().get(this.tree.newkey);
                } else {
                    Node bNode = this.tree.balanceNode;
                    bNode.getBuffer().limit(4 + this.tree.keySize);
                    bNode.getBuffer().position(4);
                    this.tree.newkey = new byte[this.tree.keySize];
                    bNode.getBuffer().get(this.tree.newkey);
                }
            }
        } else {
            if (this.isLeaf() && insertionPt >= 0) {
                KeyInfo realKeyToRemove = (KeyInfo)this.getKeyInfos().get(insertionPt);
                realKeyToRemove.decrement();
            }
            this.removeEntry(insertionPt, this.tree.dataSize);
            ++this.modcount;
            this.tree.updateNode(this);
        }
        return ret;
    }

    private void removeEntry(int insertionPt, int dataSize) throws TreeInconsistencyException {
        int startPos = 0;
        int endPos = 0;
        int endOfRecords = 4 + (this.tree.keySize + dataSize) * this.getFillSize();
        if (!this.isLeaf()) {
            endOfRecords += 4;
        }
        boolean shift = true;
        if (insertionPt < 0) {
            if (this != this.tree.getRootNode()) {
                shift = true;
                if (this.isLeaf()) {
                    startPos = 4 + (this.tree.keySize + dataSize);
                    endPos = endOfRecords;
                } else {
                    endPos = 4 + (this.tree.keySize + dataSize) * 1;
                    startPos = 4;
                }
            } else {
                shift = true;
                if (this.isLeaf()) {
                    startPos = 4 + (this.tree.keySize + dataSize);
                    endPos = endOfRecords;
                } else {
                    endPos = 4 + (this.tree.keySize + dataSize) * 1;
                    startPos = 4;
                }
            }
        } else {
            startPos = 4 + (this.tree.keySize + dataSize) * insertionPt;
            if (!this.isLeaf()) {
                startPos += 4;
            }
            endPos = startPos + (this.tree.keySize + dataSize);
        }
        if (shift) {
            if (endPos <= endOfRecords) {
                int range = endOfRecords - endPos;
                this.getBuffer().limit(endOfRecords);
                this.getBuffer().position(endPos);
                ByteBuffer shiftedData = this.getBuffer().slice();
                this.getBuffer().limit(startPos + range);
                this.getBuffer().position(startPos);
                if (BPTree.MMAP_BUG && this.affectedByBug(endPos, endOfRecords, startPos, startPos + range)) {
                    this.tree.TMP_BUFFER.limit(range);
                    this.tree.TMP_BUFFER.position(0);
                    this.tree.TMP_BUFFER.put(shiftedData);
                    this.tree.TMP_BUFFER.rewind();
                    this.getBuffer().put(this.tree.TMP_BUFFER);
                } else {
                    this.getBuffer().put(shiftedData);
                }
            }
            this.getBuffer().putInt(0, this.getFillSize() - 1);
        } else {
            this.getBuffer().limit(startPos + 4);
            this.getBuffer().position(startPos);
            this.getBuffer().putInt(-1);
        }
    }

    private boolean affectedByBug(int sourceStart, int sourceEnd, int targetStart, int targetEnd) {
        if (targetStart <= sourceStart) {
            return false;
        }
        return sourceStart <= targetEnd;
    }

    private void shift(Node balanceNode, Node anchorNode, boolean fromLeft, int insertionPt) throws TreeInconsistencyException {
        this.tree.merge = false;
        int innerOffset = 0;
        int dataSize = this.tree.dataSize;
        int key0adjustment = 0;
        if (!this.isLeaf()) {
            innerOffset = 4;
            if (insertionPt < 0) {
                key0adjustment = -4;
            }
            dataSize = 4;
        }
        int needed = (this.tree.branches + 1 >> 1) - 1;
        int difference = needed - (this.getFillSize() - 1);
        if (fromLeft) {
            int startPos = 4 + innerOffset + (this.tree.keySize + dataSize) * (balanceNode.getFillSize() - difference);
            int length = (this.tree.keySize + dataSize) * difference;
            int endOfRecords = 4 + innerOffset + (this.tree.keySize + dataSize) * this.getFillSize();
            int deleteOffset = 4 + innerOffset + (this.tree.keySize + dataSize) * (insertionPt < 0 ? 0 : insertionPt);
            int newStartPos = 4 + innerOffset + (this.tree.keySize + dataSize) * difference;
            this.getBuffer().limit(deleteOffset);
            this.getBuffer().position(4 + innerOffset);
            ByteBuffer beforeChunk = this.getBuffer().slice();
            this.getBuffer().limit(endOfRecords);
            this.getBuffer().position(deleteOffset + (this.tree.keySize + dataSize));
            ByteBuffer afterChunk = this.getBuffer().slice();
            this.getBuffer().limit(newStartPos + beforeChunk.limit() + afterChunk.limit());
            this.getBuffer().position(newStartPos);
            ByteBuffer destination = this.getBuffer().slice();
            if (BPTree.MMAP_BUG && this.affectedByBug(4 + innerOffset, deleteOffset, newStartPos, newStartPos + beforeChunk.limit())) {
                this.tree.TMP_BUFFER.limit(beforeChunk.limit() - beforeChunk.position());
                this.tree.TMP_BUFFER.position(0);
                this.tree.TMP_BUFFER.put(beforeChunk);
                this.tree.TMP_BUFFER.rewind();
                destination.put(this.tree.TMP_BUFFER);
            } else {
                destination.put(beforeChunk);
            }
            this.getBuffer().position(this.getBuffer().position() + beforeChunk.limit() - beforeChunk.position());
            if (deleteOffset + (this.tree.keySize + dataSize) != this.getBuffer().position()) {
                if (BPTree.MMAP_BUG && this.affectedByBug(deleteOffset + (this.tree.keySize + dataSize), endOfRecords, newStartPos + beforeChunk.limit(), newStartPos + beforeChunk.limit() + afterChunk.limit())) {
                    this.tree.TMP_BUFFER.limit(afterChunk.limit() - afterChunk.position());
                    this.tree.TMP_BUFFER.position(0);
                    this.tree.TMP_BUFFER.put(afterChunk);
                    this.tree.TMP_BUFFER.rewind();
                    destination.put(this.tree.TMP_BUFFER);
                } else {
                    destination.put(afterChunk);
                }
            }
            balanceNode.getBuffer().limit(startPos + length);
            balanceNode.getBuffer().position(startPos);
            this.getBuffer().limit(4 + innerOffset + length);
            this.getBuffer().position(4 + innerOffset);
            this.getBuffer().put(balanceNode.getBuffer());
        } else {
            ByteBuffer afterChunk;
            ByteBuffer beforeChunk;
            int startPos = 4 + innerOffset;
            int length = (this.tree.keySize + dataSize) * difference;
            int endOfRecords = 4 + innerOffset + (this.tree.keySize + dataSize) * this.getFillSize();
            int deleteOffset = 4 + innerOffset + (this.tree.keySize + dataSize) * (insertionPt < 0 ? 0 : insertionPt);
            if (insertionPt < 0) {
                int start = 4 + (this.tree.keySize + dataSize) * 1;
                beforeChunk = EMPTY;
                this.getBuffer().limit(endOfRecords);
                this.getBuffer().position(start);
                afterChunk = this.getBuffer().slice();
            } else {
                this.getBuffer().limit(deleteOffset);
                this.getBuffer().position(4 + innerOffset);
                beforeChunk = this.getBuffer().slice();
                this.getBuffer().limit(endOfRecords);
                this.getBuffer().position(deleteOffset + (this.tree.keySize + dataSize));
                afterChunk = this.getBuffer().slice();
            }
            this.getBuffer().limit(4 + innerOffset + beforeChunk.limit() + afterChunk.limit() + key0adjustment);
            this.getBuffer().position(4 + innerOffset + key0adjustment);
            this.getBuffer().put(beforeChunk);
            this.getBuffer().put(afterChunk);
            balanceNode.getBuffer().limit(startPos + length);
            balanceNode.getBuffer().position(startPos);
            this.getBuffer().limit(endOfRecords - length + length);
            this.getBuffer().position(endOfRecords - length);
            this.getBuffer().put(balanceNode.getBuffer());
            int otherEndOfRecords = 4 + innerOffset + (this.tree.keySize + dataSize) * balanceNode.getFillSize();
            int otherStartPos = 4 + innerOffset + (this.tree.keySize + dataSize) * difference;
            balanceNode.getBuffer().limit(otherEndOfRecords);
            balanceNode.getBuffer().position(otherStartPos);
            ByteBuffer source = balanceNode.getBuffer().slice();
            balanceNode.getBuffer().limit(4 + innerOffset + (this.tree.keySize + dataSize) * (balanceNode.getFillSize() - difference));
            balanceNode.getBuffer().position(4 + innerOffset);
            balanceNode.getBuffer().put(source);
            balanceNode.getBuffer().limit(4 + innerOffset + this.tree.keySize);
            balanceNode.getBuffer().position(4 + innerOffset);
        }
        balanceNode.getBuffer().putInt(0, balanceNode.getFillSize() - difference);
        ++balanceNode.modcount;
        this.tree.updateNode(balanceNode);
        ++this.modcount;
        this.tree.updateNode(this);
    }

    private void merge(Node neighborNode, Node anchorNode, boolean prepend, int insertionPt) throws TreeInconsistencyException {
        ByteBuffer afterChunk;
        ByteBuffer beforeChunk;
        this.tree.merge = true;
        int innerOffset = 0;
        int dataSize = this.tree.dataSize;
        if (!this.isLeaf()) {
            innerOffset = 4;
            dataSize = 4;
        }
        int key0adjustment = prepend && !this.isLeaf() ? -4 : 0;
        int endOfRecords = 4 + innerOffset + (this.tree.keySize + dataSize) * this.getFillSize();
        int deleteOffset = 4 + innerOffset + (this.tree.keySize + dataSize) * (insertionPt < 0 ? 0 : insertionPt);
        if (insertionPt < 0) {
            int start = 4 + (this.tree.keySize + dataSize) * 1;
            beforeChunk = EMPTY;
            this.getBuffer().limit(endOfRecords);
            this.getBuffer().position(start);
            afterChunk = this.getBuffer().slice();
        } else {
            this.getBuffer().limit(deleteOffset);
            this.getBuffer().position(4 + innerOffset + key0adjustment);
            beforeChunk = this.getBuffer().slice();
            this.getBuffer().limit(endOfRecords);
            this.getBuffer().position(deleteOffset + (this.tree.keySize + dataSize));
            afterChunk = this.getBuffer().slice();
        }
        int length = (this.tree.keySize + dataSize) * (this.getFillSize() - 1);
        if (prepend) {
            boolean slidingUp;
            int shiftAmount = (this.tree.keySize + dataSize) * (this.getFillSize() - 1);
            int sizeOfData = (this.tree.keySize + dataSize) * neighborNode.getFillSize();
            int destinationStart = 4 + innerOffset + shiftAmount;
            neighborNode.getBuffer().limit(4 + innerOffset + shiftAmount + sizeOfData);
            neighborNode.getBuffer().position(4 + innerOffset + shiftAmount);
            ByteBuffer destination = neighborNode.getBuffer().slice();
            neighborNode.getBuffer().limit(4 + innerOffset + sizeOfData);
            neighborNode.getBuffer().position(4 + innerOffset);
            boolean bl = slidingUp = destinationStart > 4 + innerOffset && destinationStart < 4 + innerOffset + sizeOfData;
            if (BPTree.MMAP_BUG && slidingUp) {
                int capacity = neighborNode.getBuffer().limit() - neighborNode.getBuffer().position();
                this.tree.TMP_BUFFER.limit(capacity);
                this.tree.TMP_BUFFER.position(0);
                this.tree.TMP_BUFFER.put(neighborNode.getBuffer());
                this.tree.TMP_BUFFER.rewind();
                destination.put(this.tree.TMP_BUFFER);
            } else {
                destination.put(neighborNode.getBuffer());
            }
            neighborNode.getBuffer().limit(4 + innerOffset + beforeChunk.limit() + afterChunk.limit() + key0adjustment);
            neighborNode.getBuffer().position(4 + innerOffset + key0adjustment);
            neighborNode.getBuffer().put(beforeChunk);
            neighborNode.getBuffer().put(afterChunk);
            neighborNode.getBuffer().putInt(0, neighborNode.getFillSize() + (this.getFillSize() - 1));
            ++neighborNode.modcount;
            this.tree.updateNode(neighborNode);
        } else {
            int destStartPos = 4 + innerOffset + (this.tree.keySize + dataSize) * neighborNode.getFillSize();
            neighborNode.getBuffer().limit(destStartPos + length);
            neighborNode.getBuffer().position(destStartPos);
            neighborNode.getBuffer().put(beforeChunk);
            neighborNode.getBuffer().put(afterChunk);
            neighborNode.getBuffer().putInt(0, neighborNode.getFillSize() + (this.getFillSize() - 1));
            ++neighborNode.modcount;
            this.tree.updateNode(neighborNode);
        }
    }

    public Node removeKey(int insertionPt, Node left, Node right, Node leftAnchor, Node rightAnchor, Node parent) throws TreeInconsistencyException {
        Node ret = null;
        if (this != this.tree.getRootNode() && this.isMinimal()) {
            KeyInfo realKeyToRemove = (KeyInfo)this.getKeyInfos().get(insertionPt < 0 ? 0 : insertionPt);
            realKeyToRemove.decrement();
            realKeyToRemove.dispose();
            if (left == null && right == null) {
                this.removeEntry(insertionPt, this.tree.dataSize);
                ++this.modcount;
                this.tree.updateNode(this);
                return this;
            }
            if (left == null) {
                this.tree.balanceNode = right;
            } else if (right == null) {
                this.tree.balanceNode = left;
            } else {
                Node node = this.tree.balanceNode = left.getFillSize() <= right.getFillSize() ? right : left;
            }
            if (this.tree.balanceNode.isMinimal()) {
                Node anchorNode = parent;
                Node mergeNode = null;
                if (anchorNode == leftAnchor && left != null) {
                    mergeNode = left;
                } else if (anchorNode == rightAnchor && right != null) {
                    mergeNode = right;
                }
                this.tree.rightshiftormerge = mergeNode == right;
                this.merge(mergeNode, anchorNode, mergeNode == right, insertionPt);
                this.tree.balanceNode = mergeNode;
                if (mergeNode == left) {
                    this.tree.newkey = null;
                } else {
                    Node bNode = mergeNode;
                    bNode.getBuffer().limit(8 + this.tree.keySize);
                    bNode.getBuffer().position(8);
                    this.tree.newkey = new byte[this.tree.keySize];
                    bNode.getBuffer().get(this.tree.newkey);
                }
                ret = this;
            } else {
                Node anchorNode = this.tree.balanceNode == right ? rightAnchor : leftAnchor;
                this.tree.rightshiftormerge = this.tree.balanceNode == right;
                this.shift(this.tree.balanceNode, anchorNode, this.tree.balanceNode == left, insertionPt);
                if (this.tree.balanceNode == left) {
                    this.getBuffer().limit(8 + this.tree.keySize);
                    this.getBuffer().position(8);
                    this.tree.newkey = new byte[this.tree.keySize];
                    this.getBuffer().get(this.tree.newkey);
                } else {
                    Node bNode = this.tree.balanceNode;
                    bNode.getBuffer().limit(8 + this.tree.keySize);
                    bNode.getBuffer().position(8);
                    this.tree.newkey = new byte[this.tree.keySize];
                    bNode.getBuffer().get(this.tree.newkey);
                }
            }
        } else {
            if (insertionPt >= -1) {
                KeyInfo realKeyToRemove = (KeyInfo)this.getKeyInfos().get(insertionPt < 0 ? 0 : insertionPt);
                realKeyToRemove.decrement();
            }
            this.removeEntry(insertionPt, 4);
            ++this.modcount;
            this.tree.updateNode(this);
        }
        return ret;
    }

    public String toDebuString() {
        String s = "";
        s = this.buffer == null ? String.valueOf(s) + "BPTree: Brand new or commited/disposed node" : String.valueOf(s) + "BPTree Node Id: " + this.getId() + " FillSize: " + this.getFillSize() + " isLeaf: " + this.isLeaf();
        return "BPTree node" + super.toString();
    }

    @Override
    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(stream, true);
        if (this.buffer == null) {
            p.println("BPTree: Brand new or commited/disposed node");
        } else {
            p.println("BPTree Node Id: " + this.getId() + " FillSize: " + this.getFillSize() + " isLeaf: " + this.isLeaf());
            p.println("BTree node contents: ");
            this.print(p, "    ");
        }
        p.println(super.toString());
        return stream.toString();
    }

    public static String printData(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            buf.append(b);
            if (i < bytes.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public void print(String indent) {
        this.print(System.out, indent);
    }

    public void print(PrintStream stream, String indent) {
        String newIndent = String.valueOf(indent) + "  ";
        if (this.isLeaf()) {
            int i = 0;
            while (i < this.getFillSize()) {
                stream.println(String.valueOf(indent) + "L[" + this.getId() + " :: " + this.getNextNodeId() + "] Key: " + this.getKeyInfos().get(i) + " Data: " + Node.printData((byte[])this.getData().get(i)));
                ++i;
            }
        } else if (this.getFillSize() == 0) {
            stream.print(String.valueOf(indent) + "No children");
        } else {
            Node node = this.getChildren().get(0);
            if (node == null) {
                stream.println(String.valueOf(indent) + indent + "[null]");
            } else {
                node.print(stream, newIndent);
            }
            int i = 0;
            while (i < this.getFillSize()) {
                stream.println(String.valueOf(indent) + "I[" + this.getId() + "] Key: " + this.getKeyInfos().get(i) + " No Data");
                Node n = this.getChildren().get(i + 1);
                if (n == null) {
                    stream.println(String.valueOf(indent) + "NULL CHILD!");
                } else {
                    n.print(stream, newIndent);
                }
                ++i;
            }
        }
    }

    int getNextNodeId() {
        int ptrOffset = 4 + (this.tree.keySize + this.tree.dataSize) * (this.tree.branches - 1);
        ByteBuffer dup = this.getBuffer().duplicate();
        dup.limit(ptrOffset + 4);
        dup.position(ptrOffset);
        int nextNodeId = dup.getInt();
        return nextNodeId;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        if (this.buffer == null) {
            this.tree.getNode(this.getId());
        }
        return this.buffer;
    }

    public abstract class CachingList<T>
    extends AbstractList<T> {
        public abstract void clearCaches(int var1);
    }

    private class ChildList
    extends AbstractList<Node>
    implements RandomAccess {
        private ChildList() {
        }

        @Override
        public Node get(int index) {
            if (Node.this.isLeaf()) {
                return null;
            }
            int offset = 4 + (index > 0 ? Node.this.tree.keySize * index : 0) + 4 * index;
            int nodeId = 65535;
            ByteBuffer buf = Node.this.getBuffer().duplicate();
            buf.limit(offset + 4);
            buf.position(offset);
            nodeId = buf.getInt();
            Node node = null;
            try {
                node = Node.this.tree.getNode(nodeId);
            }
            catch (TreeInconsistencyException e) {
                throw new TreeInconsistencyException(NLS.bind((String)Messages.bTreeMsg_couldnotfindchildXforindexYwithinnodeZ, (Object[])new Object[]{nodeId, index, Node.this.getId()}), e);
            }
            return node;
        }

        @Override
        public int size() {
            if (Node.this.isLeaf()) {
                return 0;
            }
            return Node.this.getFillSize() + 1;
        }
    }

    private class DataList
    extends CachingList<byte[]>
    implements RandomAccess {
        public DataList(BPTree tree) {
        }

        @Override
        public void clearCaches(int start) {
        }

        @Override
        public byte[] get(int index) {
            int offset = 0;
            if (!Node.this.isLeaf()) {
                throw new IndexOutOfBoundsException();
            }
            offset = 4 + (Node.this.tree.keySize + Node.this.tree.dataSize) * index + Node.this.tree.keySize;
            byte[] dataBytes = new byte[Node.this.tree.dataSize];
            ByteBuffer buf = Node.this.getBuffer().duplicate();
            buf.limit(offset + Node.this.tree.dataSize);
            buf.position(offset);
            buf.get(dataBytes, 0, Node.this.tree.dataSize);
            return dataBytes;
        }

        @Override
        public int size() {
            return Node.this.getFillSize();
        }
    }

    private class KeyInfos
    extends CachingList<KeyInfo>
    implements RandomAccess {
        public KeyInfos(BPTree tree) {
        }

        @Override
        public void clearCaches(int start) {
        }

        @Override
        public KeyInfo get(int index) {
            int offset = 0;
            offset = Node.this.isLeaf() ? 4 + (Node.this.tree.keySize + Node.this.tree.dataSize) * index : 8 + (4 + Node.this.tree.keySize) * index;
            ByteBuffer buf = Node.this.getBuffer().duplicate();
            if (Node.this.tree.factory.getSize() == -1) {
                buf.limit(offset + Node.this.tree.keySize);
                buf.position(offset);
                buf.mark();
                byte overflow = buf.get();
                if (overflow == 1) {
                    int oid = buf.getInt();
                    OverflowedKeyRecord record = Node.this.tree.getOverflowNode(oid);
                    if (record == null) {
                        return null;
                    }
                    buf.reset();
                    ByteBuffer keyData = buf.slice();
                    KeyInfo info = new KeyInfo(record, Node.this.tree);
                    info.setKeyData(new PooledByteBuffer(keyData));
                    return info;
                }
                buf.reset();
                KeyInfo info = new KeyInfo(Node.this.tree);
                info.isproxy = true;
                info.setKeyData(new PooledByteBuffer(buf.slice()));
                return info;
            }
            buf.limit(offset + Node.this.tree.keySize);
            buf.position(offset);
            KeyInfo info = new KeyInfo(new PooledByteBuffer(buf.slice()), Node.this.tree);
            return info;
        }

        @Override
        public int size() {
            return Node.this.getFillSize();
        }
    }

    private class KeyList
    extends CachingList<Key>
    implements RandomAccess {
        public KeyList(BPTree tree) {
        }

        @Override
        public void clearCaches(int start) {
        }

        @Override
        public Key get(int index) {
            int offset = 0;
            offset = Node.this.isLeaf() ? 4 + (Node.this.tree.keySize + Node.this.tree.dataSize) * index : 8 + (4 + Node.this.tree.keySize) * index;
            ByteBuffer buf = Node.this.getBuffer().duplicate();
            if (Node.this.tree.factory.getSize() == -1) {
                buf.limit(offset + Node.this.tree.keySize);
                buf.position(offset);
                buf.mark();
                byte overflow = buf.get();
                if (overflow == 1) {
                    int oid = buf.getInt();
                    OverflowedKeyRecord record = Node.this.tree.getOverflowNode(oid);
                    ByteBuffer overflowData = record.getOverflowKeyData();
                    Key key = Node.this.tree.factory.createKey();
                    key.readKeyData(new PooledByteBuffer(overflowData));
                    return key;
                }
            } else {
                buf.limit(offset + Node.this.tree.keySize);
                buf.position(offset);
            }
            Key key = Node.this.tree.factory.createKey();
            key.readKeyData(new PooledByteBuffer(buf.slice()));
            return key;
        }

        @Override
        public int size() {
            return Node.this.getFillSize();
        }
    }
}

