/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.tree;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.DBRecordFactory;
import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.IntFileHeader;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.KeyFactory;
import com.ibm.etools.references.internal.bplustree.tree.KeyInfo;
import com.ibm.etools.references.internal.bplustree.tree.Node;
import com.ibm.etools.references.internal.bplustree.tree.OverflowedKeyRecord;
import com.ibm.etools.references.internal.bplustree.tree.TreeInconsistencyException;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.nls.Messages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class BPTree {
    static final boolean MMAP_BUG;
    static final int KEY = 3;
    final int branches;
    int keySize;
    final int dataSize;
    final int leafNodeSize;
    final int innerNodeSize;
    ExtentManager nodeExtents;
    ExtentManager overflowExtents;
    private IntFileHeader rootNodeIdHeader = null;
    private IntFileHeader hasOverflowHeader = null;
    private IntFileHeader size = null;
    private IntFileHeader height = null;
    public boolean rightshiftormerge;
    public boolean merge;
    public byte[] newkey;
    Node balanceNode;
    KeyRecordFactory keyFactory;
    final KeyFactory factory;
    private final boolean create;
    final ByteBuffer TMP_BUFFER;
    private final File index;
    private final Comparator<KeyInfo> comparator;
    private final int cacheSize;
    private final int extentSize;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock write = this.lock.writeLock();
    private final ReentrantReadWriteLock.ReadLock read = this.lock.readLock();
    String before = null;
    private final boolean EXTRA_ASSERTS = false;
    private boolean reLinkLeaf = false;
    private int relinkNodeId = -1;
    private final DirectNodeFileFactory directNodeFileFactory;

    static {
        boolean tmpResult = false;
        if (tmpResult) {
            Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, Messages.bTreeMsg_UsingWorkaroundForMMapBug);
        }
        MMAP_BUG = tmpResult;
    }

    public BPTree(File index, int cacheSize, int branches, int nodesPerExtent, KeyFactory factory, int dataSize, boolean create) throws FatalIOException {
        this.index = index;
        this.cacheSize = cacheSize;
        this.branches = branches;
        this.factory = factory;
        Assert.isLegal((dataSize > 0 ? 1 : 0) != 0);
        this.dataSize = dataSize;
        this.create = create;
        this.keySize = factory.getSize() == -1 ? Math.max(factory.getAverageSize() + 1, 5) : factory.getSize();
        this.leafNodeSize = 4 + (this.keySize + dataSize) * (this.branches - 1) + 4;
        this.innerNodeSize = 4 + this.keySize * (this.branches - 1) + 4 * this.branches;
        this.extentSize = Math.max(this.leafNodeSize, this.innerNodeSize) * nodesPerExtent;
        this.TMP_BUFFER = MMAP_BUG ? ByteBuffer.allocateDirect(Math.max(this.leafNodeSize, this.innerNodeSize)) : null;
        this.directNodeFileFactory = new DirectNodeFileFactory(branches);
        this.keyFactory = new KeyRecordFactory();
        this.comparator = factory.keyComparator();
        this.init(create);
    }

    public Access getAccess(Object o) {
        return new Access();
    }

    public File getFile() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtentManager getOverflowExtents() throws FatalIOException {
        BPTree bPTree = this;
        synchronized (bPTree) {
            if (this.overflowExtents == null) {
                File keyfile = new File(this.nodeExtents.getFile() + "-o");
                int overflowSize = 128000;
                if (this.hasOverflowHeader.getHeaderValue() == 0) {
                    this.overflowExtents = new ExtentManager(InternalAPI.Tweaks.INDEX_OVERFLOW_CACHE_SIZE, keyfile, this.keyFactory, overflowSize, Collections.emptyList(), 1.0f, true, this.lock);
                    this.overflowExtents.setBPtree(true);
                    this.hasOverflowHeader.setHeaderValue(1);
                } else {
                    this.overflowExtents = new ExtentManager(InternalAPI.Tweaks.INDEX_OVERFLOW_CACHE_SIZE, keyfile, this.keyFactory, overflowSize, Collections.emptyList(), 1.0f, this.create, this.lock);
                    this.overflowExtents.setBPtree(true);
                }
            }
            return this.overflowExtents;
        }
    }

    private void init(boolean create) {
        List<FileHeader> headers = this.initHeaders();
        this.nodeExtents = new ExtentManager(this.cacheSize, this.index, this.directNodeFileFactory, this.extentSize, headers, 1.0f, create, this.lock);
        this.nodeExtents.setBPtree(true);
        this.loadHeaders();
        this.getRootNode();
    }

    private List<FileHeader> initHeaders() {
        this.rootNodeIdHeader = new IntFileHeader("BPTree root node id", -1);
        this.hasOverflowHeader = new IntFileHeader("BPTree has overflow", 0);
        this.size = new IntFileHeader("BPTree size", 0);
        this.height = new IntFileHeader("BPTree height", 0);
        ArrayList<FileHeader> headers = new ArrayList<FileHeader>();
        headers.add(this.rootNodeIdHeader);
        headers.add(this.hasOverflowHeader);
        headers.add(this.size);
        headers.add(this.height);
        return headers;
    }

    private void loadHeaders() {
    }

    private void saveHeaders() {
    }

    public int getNumberOfNodes() throws FatalIOException {
        this.read.lock();
        try {
            int n = this.nodeExtents.getTotalSlotsUsage();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    public String printToString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(stream, true);
        this.printToStream(p, true, true);
        return stream.toString();
    }

    public void printToStream(PrintStream stream, boolean justTree, boolean includeLinks) {
        try {
            stream.println(">>>Dumping Tree ");
            stream.println("Iteration: ");
            Iterator<Map.Entry<Key, byte[]>> itr = this.iterator(null, null);
            int count = 0;
            while (itr.hasNext()) {
                Map.Entry<Key, byte[]> entry = itr.next();
                stream.print("Key: " + entry.getKey());
                stream.print(" Value: " + Node.printData(entry.getValue()));
                if (includeLinks) {
                    int id = ByteUtils.bytesToInt(ByteBuffer.wrap(entry.getValue()));
                    stream.println(" Link: " + ReferenceDatabase.getDefault().getReferenceElement(id));
                } else {
                    stream.println();
                }
                ++count;
            }
            stream.println("Tree size: " + this.getSize() + " iteration count: " + count);
            if (!justTree) {
                stream.println("==== DATA EXTENTS");
                this.nodeExtents.debugPrintRecords(stream);
                stream.println("=== END OF DATA");
                if (this.overflowExtents != null) {
                    stream.println("===== OVERFLOW EXTENTS");
                    this.getOverflowExtents().debugPrintRecords(stream);
                    stream.println("===== END OF OVERFLOW");
                } else {
                    stream.println("NO OVERFLOWS");
                }
            }
            this.getRootNode().print(stream, "");
            stream.println("<<<Dumping Tree ");
        }
        catch (RuntimeException e) {
            e.printStackTrace(stream);
        }
    }

    public void print() {
        this.printToStream(System.out, false, false);
    }

    public void print(boolean justTree) {
        this.printToStream(System.out, justTree, true);
    }

    public int getSize() {
        this.read.lock();
        try {
            int n = this.size.getHeaderValue();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    public void close(boolean flush) throws FatalIOException {
        this.write.lock();
        try {
            this.saveHeaders();
            try {
                if (this.nodeExtents != null) {
                    this.nodeExtents.close(flush);
                }
            }
            finally {
                if (this.hasOverflowHeader.getHeaderValue() == 1 && this.overflowExtents != null) {
                    this.overflowExtents.close(flush);
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void delete() throws FatalIOException {
        this.write.lock();
        try {
            if (this.nodeExtents != null) {
                this.nodeExtents.delete();
            }
            if (this.hasOverflowHeader.getHeaderValue() == 1 && this.overflowExtents != null) {
                this.getOverflowExtents().delete();
            }
            this.nodeExtents = null;
            this.overflowExtents = null;
        }
        finally {
            this.write.unlock();
        }
    }

    public byte[] search(Key key) throws TreeInconsistencyException {
        this.read.lock();
        try {
            Node root = this.getRootNode();
            PooledByteBuffer data = key.writeKeyData();
            KeyInfo keyInfo = new KeyInfo(data, this);
            data.returnBuffer();
            SearchResult result = this.findLeafNode(root, keyInfo, true, false);
            keyInfo.dispose();
            if (result == null) {
                return null;
            }
            this.assertStuff();
            byte[] byArray = (byte[])result.node.getData().get(result.position);
            return byArray;
        }
        finally {
            this.read.unlock();
        }
    }

    Node getNode(int id) throws TreeInconsistencyException {
        try {
            DBRecord r = this.nodeExtents.readRecord(id);
            if (r instanceof Node) {
                Node n = (Node)r;
                return n;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw new TreeInconsistencyException("Could not get node with id: " + id, e);
        }
    }

    OverflowedKeyRecord getOverflowNode(int id) throws TreeInconsistencyException {
        try {
            DBRecord r = this.getOverflowExtents().readRecord(id);
            if (r instanceof OverflowedKeyRecord) {
                return (OverflowedKeyRecord)r;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw new TreeInconsistencyException("Could not get node with id: " + id, e);
        }
    }

    void updateNode(Node node) throws TreeInconsistencyException {
        if (InternalAPI.Tweaks.SHOULD_USE_MAPPED_BUFFER) {
            this.nodeExtents.flush(node);
            this.nodeExtents.touch(node);
            if (node.isDirty()) {
                node.clean();
            }
            return;
        }
        try {
            this.nodeExtents.update(node);
        }
        catch (RuntimeException e) {
            throw new TreeInconsistencyException(NLS.bind((String)Messages.bTreeMsg_exception_during_update_of_X, (Object)node.getId()), e);
        }
    }

    private void deleteNode(Node directNode) throws TreeInconsistencyException {
        try {
            this.nodeExtents.delete(directNode);
        }
        catch (RuntimeException e) {
            throw new TreeInconsistencyException(Messages.bTreeMsg_exception_deleting_node_from_extents, e);
        }
    }

    Node getRootNode() throws TreeInconsistencyException {
        Node root = null;
        if (this.rootNodeIdHeader.getHeaderValue() == -1) {
            root = (Node)this.directNodeFileFactory.createRecord(1, null);
            root.init();
            int ptrOffset = 4 + (this.keySize + this.dataSize) * (this.branches - 1);
            root.getBuffer().limit(ptrOffset + 4);
            root.getBuffer().position(ptrOffset);
            root.getBuffer().putInt(-1);
            ++root.modcount;
            this.updateNode(root);
            this.rootNodeIdHeader.setHeaderValue(root.getId());
        } else {
            root = this.getNode(this.rootNodeIdHeader.getHeaderValue());
            if (root == null) {
                root = (Node)this.directNodeFileFactory.createRecord(1, null);
                root.init();
                this.updateNode(root);
                this.rootNodeIdHeader.setHeaderValue(root.getId());
            }
        }
        return root;
    }

    SearchResult findLeafNode(Node node, KeyInfo key, boolean exact, boolean floor) throws TreeInconsistencyException {
        Node.CachingList<KeyInfo> buffers = node.getKeyInfos();
        int insertionPt = Collections.binarySearch(buffers, key, this.comparator);
        if (node.isLeaf()) {
            if (insertionPt >= 0) {
                SearchResult result = new SearchResult();
                result.node = node;
                result.position = insertionPt;
                return result;
            }
            if (exact) {
                return null;
            }
            int closest = -insertionPt - 1;
            SearchResult result = new SearchResult();
            if (node.getFillSize() == 0) {
                result.node = node;
                result.position = 0;
            } else if (closest < node.getFillSize()) {
                result.node = node;
                result.position = floor ? closest - 1 : closest;
            } else if (closest >= node.getFillSize()) {
                Node next = node.getNextNode();
                if (next == null) {
                    result.position = node.getFillSize();
                    result.node = node;
                } else {
                    result.node = next;
                    result.position = floor ? -1 : 0;
                }
            }
            return result;
        }
        Node child = null;
        int childId = insertionPt;
        if (childId < 0) {
            childId = -childId - 1;
            child = node.getChildren().get(childId);
        } else if (childId <= node.getFillSize()) {
            child = node.getChildren().get(childId + 1);
        }
        return child == null ? null : this.findLeafNode(child, key, exact, floor);
    }

    public void insert(Key key, byte[] data) throws TreeInconsistencyException {
        this.write.lock();
        try {
            try {
                Node root = this.getRootNode();
                PooledByteBuffer kData = key.writeKeyData();
                KeyInfo info = new KeyInfo(kData, this);
                kData.returnBuffer();
                Node newNode = this.recurseInsert(info, data, root);
                if (newNode != root) {
                    Node newRoot = (Node)this.directNodeFileFactory.createRecord(2, null);
                    newRoot.init();
                    KeyInfo newNodeKey = (KeyInfo)newNode.getKeyInfos().get(0);
                    newNodeKey.increment();
                    KeyInfo oldRootKey = (KeyInfo)root.getKeyInfos().get(0);
                    if (this.comparator.compare(newNodeKey, oldRootKey) < 0) {
                        if (newNode.isLeaf()) {
                            this.reLinkLeaf(newNode, root.getId());
                        }
                        newRoot.createRoot(newNode.getId(), newNodeKey, root.getId());
                    } else {
                        if (root.isLeaf()) {
                            this.reLinkLeaf(root, newNode.getId());
                        }
                        newRoot.createRoot(root.getId(), newNodeKey, newNode.getId());
                    }
                    this.updateNode(newRoot);
                    this.rootNodeIdHeader.setHeaderValue(newRoot.getId());
                    this.height.setHeaderValue(this.height.getHeaderValue() + 1);
                    newNodeKey.dispose();
                    oldRootKey.dispose();
                } else {
                    this.updateNode(root);
                }
                info.dispose();
                this.assertStuff();
            }
            catch (RuntimeException e) {
                String toString = key.getClass().getCanonicalName();
                try {
                    toString = key.toString();
                }
                catch (RuntimeException runtimeException) {}
                throw new TreeInconsistencyException("Error inserting key: " + toString, e);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    private void assertStuff() throws TreeInconsistencyException {
    }

    private int itrCount(Iterator<Map.Entry<Key, byte[]>> itr) throws TreeInconsistencyException {
        int c = 0;
        Key prev = null;
        while (itr.hasNext()) {
            Map.Entry<Key, byte[]> entry = itr.next();
            if (c != 0 && prev != null) {
                Key current = entry.getKey();
                PooledByteBuffer cd = current.writeKeyData();
                PooledByteBuffer pd = prev.writeKeyData();
                try {
                    KeyInfo cinfo = new KeyInfo(cd, this);
                    KeyInfo pinfo = new KeyInfo(pd, this);
                    if (this.comparator.compare(cinfo, pinfo) <= 0) {
                        cinfo.dispose();
                        pinfo.dispose();
                        throw new TreeInconsistencyException(Messages.bTreeMsg_incorrect_key_ordering);
                    }
                    cinfo.dispose();
                    pinfo.dispose();
                }
                finally {
                    cd.returnBuffer();
                    pd.returnBuffer();
                }
            }
            prev = entry.getKey();
            ++c;
        }
        return c;
    }

    public int getHeight() {
        return this.height.getHeaderValue();
    }

    private Node recurseInsert(KeyInfo info, byte[] data, Node node) throws TreeInconsistencyException {
        Node.CachingList<KeyInfo> buffers = node.getKeyInfos();
        Node overflow = node;
        int insertionPt = Collections.binarySearch(buffers, info, this.comparator);
        if (node.isLeaf()) {
            overflow = node.addData(info, data, insertionPt);
            this.size.setHeaderValue(this.size.getHeaderValue() + 1);
        } else {
            Node child = null;
            int childId = insertionPt;
            if (childId < 0) {
                childId = -childId - 1;
                child = node.getChildren().get(childId);
                if (child == null) {
                    Assert.isNotNull((Object)child, (String)NLS.bind((String)"Could not find child index: {0} for context node id {1}, fillSize = {2}, isLeaf={3}.  Root node id = {4}", (Object[])new Object[]{childId, node.getId(), Boolean.toString(node.isLeaf()), node.getFillSize(), this.rootNodeIdHeader.getHeaderValue()}));
                }
            } else {
                child = node.getChildren().get(childId + 1);
                if (child == null) {
                    Assert.isNotNull((Object)child, (String)NLS.bind((String)"Could not find child index: {0} for context node id {1}, fillSize = {2}, isLeaf={3}.  Root node id = {4}", (Object[])new Object[]{childId, node.getId(), Boolean.toString(node.isLeaf()), node.getFillSize(), this.rootNodeIdHeader.getHeaderValue()}));
                }
            }
            Node newNode = null;
            Node keyOverflow = this.recurseInsert(info, data, child);
            if (child != keyOverflow) {
                newNode = keyOverflow;
            }
            if (newNode != null) {
                KeyInfo overFlowKeyBuffer = (KeyInfo)newNode.getKeyInfos().get(0);
                boolean fixLinks = false;
                int pos = -1;
                int overFlowId = newNode.getId();
                if (newNode.isLeaf()) {
                    if (insertionPt < 0) {
                        pos = -insertionPt - 1;
                    }
                    if (pos >= 0) {
                        fixLinks = true;
                    }
                }
                newNode = node.addKey(overFlowKeyBuffer, newNode, insertionPt);
                if (fixLinks && ++pos > 0) {
                    Node left = node.getChildren().get(pos - 1);
                    this.reLinkLeaf(left, overFlowId);
                }
                if (newNode != node) {
                    overflow = newNode;
                }
            }
        }
        return overflow;
    }

    public Iterator<Map.Entry<Key, byte[]>> iterator(Key start, Key end) throws TreeInconsistencyException {
        this.read.lock();
        try {
            BPTreeIterator bPTreeIterator = new BPTreeIterator(start, end, this);
            return bPTreeIterator;
        }
        finally {
            this.read.unlock();
        }
    }

    public void delete(Key key) throws TreeInconsistencyException {
        this.write.lock();
        try {
            try {
                PooledByteBuffer kData = key.writeKeyData();
                KeyInfo info = new KeyInfo(kData, this);
                kData.returnBuffer();
                this.balanceNode = null;
                Node newRoot = this.recurseDelete(this.getRootNode(), null, null, null, null, info, null);
                if (newRoot != null) {
                    this.rootNodeIdHeader.setHeaderValue(newRoot.getId());
                }
                info.dispose();
                Assert.isTrue((this.getSize() >= 0 ? 1 : 0) != 0, (String)(String.valueOf(Messages.BPTree_1) + this.getSize()));
            }
            catch (RuntimeException e) {
                String toString = key.getClass().getCanonicalName();
                try {
                    toString = key.toString();
                }
                catch (RuntimeException runtimeException) {}
                throw new TreeInconsistencyException("Error deleting key: " + toString, e);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    private Node recurseDelete(Node node, Node left, Node right, Node leftAnchor, Node rightAnchor, KeyInfo keyBuffer, Node parent) throws TreeInconsistencyException {
        Assert.isNotNull((Object)node, (String)"Tried to recurse down a null btree node");
        Node.CachingList<KeyInfo> buffers = node.getKeyInfos();
        int insertionPt = Collections.binarySearch(buffers, keyBuffer, this.comparator);
        Node underflow = node;
        int childIndex = 65535;
        Node child = null;
        if (insertionPt < 0) {
            childIndex = -insertionPt - 1;
            child = node.getChildren().get(childIndex);
        } else {
            childIndex = insertionPt + 1;
            child = node.getChildren().get(childIndex);
        }
        if (node.isLeaf()) {
            if (insertionPt >= 0) {
                underflow = node.removeData(childIndex - 1, left, right, leftAnchor, rightAnchor, parent);
                this.size.setHeaderValue(this.size.getHeaderValue() - 1);
            } else {
                underflow = null;
            }
        } else {
            Node newLeft = null;
            Node newLeftAnc = null;
            Node newRight = null;
            Node newRightAnc = null;
            if (childIndex == 0) {
                newLeft = left == null ? null : left.getChildren().get(left.getFillSize());
                newLeftAnc = leftAnchor;
            } else {
                newLeft = node.getChildren().get(childIndex - 1);
                newLeftAnc = node;
            }
            if (childIndex == node.getFillSize()) {
                newRight = right == null ? null : right.getChildren().get(0);
                newRightAnc = rightAnchor;
            } else {
                newRight = node.getChildren().get(childIndex + 1);
                newRightAnc = node;
            }
            underflow = this.recurseDelete(child, newLeft, newRight, newLeftAnc, newRightAnc, keyBuffer, node);
            Node oldBalance = this.balanceNode;
            if (this.balanceNode != null) {
                if (this.newkey != null) {
                    int keyStart = 8 + (this.keySize + 4) * childIndex;
                    if (this.balanceNode == newLeft) {
                        keyStart = 8 + (this.keySize + 4) * (childIndex - 1);
                    } else if (this.balanceNode == newRight) {
                        keyStart = underflow != null & childIndex == 0 ? 8 + (this.keySize + 4) * childIndex : 8 + (this.keySize + 4) * childIndex;
                    }
                    node.getBuffer().limit(keyStart + this.keySize);
                    node.getBuffer().position(keyStart);
                    if (this.factory.getSize() == -1) {
                        ByteBuffer newOne;
                        ByteBuffer existingOne;
                        if (node == this.getRootNode()) {
                            if (node.getFillSize() >= 1) {
                                if (underflow == null) {
                                    existingOne = node.getBuffer().duplicate();
                                    if (!existingOne.equals(newOne = ByteBuffer.wrap(this.newkey)) && existingOne.get() == 1) {
                                        int existingRec = existingOne.getInt();
                                        OverflowedKeyRecord eKRec = this.getOverflowNode(existingRec);
                                        eKRec.decrement();
                                    }
                                    if (newOne.get() == 1) {
                                        int recId = newOne.getInt();
                                        OverflowedKeyRecord kRec = this.getOverflowNode(recId);
                                        kRec.increment();
                                    }
                                } else {
                                    existingOne = node.getBuffer().duplicate();
                                    if (!existingOne.equals(newOne = ByteBuffer.wrap(this.newkey)) && existingOne.get() == 1) {
                                        int existingRec = existingOne.getInt();
                                        OverflowedKeyRecord eKRec = this.getOverflowNode(existingRec);
                                        eKRec.decrement();
                                    }
                                    if (newOne.get() == 1) {
                                        int recId = newOne.getInt();
                                        OverflowedKeyRecord kRec = this.getOverflowNode(recId);
                                        kRec.increment();
                                    }
                                }
                            }
                        } else {
                            existingOne = node.getBuffer().duplicate();
                            if (!existingOne.equals(newOne = ByteBuffer.wrap(this.newkey)) && existingOne.get() == 1) {
                                int eId = existingOne.getInt();
                                OverflowedKeyRecord eRec = this.getOverflowNode(eId);
                                eRec.decrement();
                            }
                            if (newOne.get() == 1) {
                                int recId = newOne.getInt();
                                OverflowedKeyRecord kRec = this.getOverflowNode(recId);
                                kRec.increment();
                            }
                        }
                    }
                    node.getBuffer().put(this.newkey);
                    this.newkey = null;
                    ++node.modcount;
                    this.updateNode(node);
                }
                this.balanceNode = null;
            }
            if (this.reLinkLeaf && left != null) {
                this.reLinkLeaf(this.getLastLeaf(left), this.relinkNodeId);
                this.reLinkLeaf = false;
                this.relinkNodeId = 65535;
            }
            if (underflow != null) {
                if (!this.reLinkLeaf) {
                    if (oldBalance == null && underflow.isLeaf()) {
                        if (left != null) {
                            throw new TreeInconsistencyException(Messages.bTreeMsg_collision_merging_left);
                        }
                        this.reLinkLeaf = true;
                        this.relinkNodeId = underflow.getNextNodeId();
                    } else {
                        if (oldBalance == null) {
                            throw new TreeInconsistencyException(Messages.bTreeMsg_balance_node_is_null);
                        }
                        if (oldBalance.isLeaf() && this.rightshiftormerge) {
                            if (left != null) {
                                Node leftChild = left.getChildren().get(left.getFillSize());
                                if (!leftChild.isLeaf()) {
                                    throw new TreeInconsistencyException(Messages.bTreeMsg_child_of_leaf_is_non_data_node);
                                }
                                this.reLinkLeaf(leftChild, oldBalance.getId());
                            } else {
                                this.reLinkLeaf = true;
                                this.relinkNodeId = oldBalance.getId();
                            }
                        }
                    }
                }
                this.deleteNode(underflow);
                if (childIndex - 1 < node.getFillSize()) {
                    Node tmpUnderFlow;
                    int a = childIndex - 1;
                    underflow = tmpUnderFlow = node.removeKey(a, left, right, leftAnchor, rightAnchor, parent);
                } else {
                    underflow = null;
                }
                if (node == this.getRootNode()) {
                    if (node.getFillSize() == 0) {
                        this.deleteNode(node);
                        Node newRoot = node.getChildren().get(0);
                        this.rootNodeIdHeader.setHeaderValue(newRoot.getId());
                        this.height.setHeaderValue(this.height.getHeaderValue() - 1);
                        this.reLinkLeaf = false;
                        this.relinkNodeId = 65535;
                        return newRoot;
                    }
                    if (node.getFillSize() == 1) {
                        Node two;
                        Node one = node.getChildren().get(0);
                        if (one != null ^ (two = node.getChildren().get(1)) != null) {
                            Node newRoot = one;
                            if (newRoot == null) {
                                newRoot = two;
                            }
                            this.deleteNode(node);
                            this.rootNodeIdHeader.setHeaderValue(newRoot.getId());
                            this.height.setHeaderValue(this.height.getHeaderValue() - 1);
                            this.reLinkLeaf = false;
                            this.relinkNodeId = 65535;
                            return newRoot;
                        }
                        this.reLinkLeaf = false;
                        this.relinkNodeId = 65535;
                        return node;
                    }
                    this.reLinkLeaf = false;
                    this.relinkNodeId = 65535;
                    return node;
                }
            } else if (node == this.getRootNode()) {
                this.reLinkLeaf = false;
                this.relinkNodeId = 65535;
                return node;
            }
        }
        return underflow;
    }

    private void reLinkLeaf(Node left, int id) throws TreeInconsistencyException {
        int ptrOffset = 4 + (this.keySize + this.dataSize) * (this.branches - 1);
        left.getBuffer().limit(ptrOffset + 4);
        left.getBuffer().position(ptrOffset);
        left.getBuffer().putInt(id);
        ++left.modcount;
        this.updateNode(left);
    }

    Node getFirstLeaf(Node subNode) {
        while (subNode.getFillSize() > 0 && !subNode.isLeaf()) {
            subNode = subNode.getChildren().get(0);
        }
        return subNode;
    }

    private Node getLastLeaf(Node subNode) {
        while (subNode.getFillSize() > 0 && !subNode.isLeaf()) {
            subNode = subNode.getChildren().get(subNode.getFillSize());
        }
        return subNode;
    }

    public void recreate() throws FatalIOException {
        this.write.lock();
        try {
            this.delete();
            this.overflowExtents = null;
            this.init(true);
        }
        finally {
            this.write.unlock();
        }
    }

    public void reload() throws FatalIOException {
        this.write.lock();
        try {
            this.close(true);
            this.init(false);
        }
        finally {
            this.write.unlock();
        }
    }

    public void debugDump(PrintStream stream) throws FatalIOException {
        this.read.lock();
        try {
            stream.println("Data...");
            this.nodeExtents.debugPrintRecords(stream);
            stream.println("Overflows...");
            this.getOverflowExtents().debugPrintRecords(stream);
        }
        finally {
            this.read.unlock();
        }
    }

    public void sync() {
        ExtentManager oF;
        ExtentManager nE;
        this.write.lock();
        try {
            nE = this.nodeExtents;
            if (nE != null) {
                nE.drainCache(false);
            }
            if ((oF = this.overflowExtents) != null) {
                oF.drainCache(false);
            }
        }
        finally {
            this.write.unlock();
        }
        if (nE != null) {
            nE.sync();
        }
        if (oF != null) {
            oF.sync();
        }
    }

    public void assertNoKeyRecs(PrintStream stream) throws FatalIOException {
        this.sync();
        this.write.lock();
        try {
            stream.println("Data...");
            this.nodeExtents.debugPrintRecords(stream);
            int slotUsage = this.nodeExtents.getTotalSlotsUsage();
            stream.println("Overflows...");
            this.getOverflowExtents().debugPrintRecords(stream);
            int overflowusage = this.getOverflowExtents().getTotalSlotsUsage();
            Assert.isTrue((overflowusage == 0 ? 1 : 0) != 0, (String)("Should not have any overflow records. Actual overflow size: " + overflowusage));
            Assert.isTrue((slotUsage == 1 ? 1 : 0) != 0, (String)("Tree was not empty: Actual Size: " + slotUsage));
        }
        finally {
            this.write.unlock();
        }
    }

    public String toString() {
        return "Size=" + this.getSize() + ", Height=" + this.height + ", file=" + this.getFile().getAbsolutePath();
    }

    public void printCacheStats(PrintStream out) {
        this.read.lock();
        try {
            out.println("\tNode extents: ");
            out.print("\t\t");
            this.nodeExtents.printCacheStats(out);
            out.println("\tOverflow keys: ");
            out.print("\t\t");
            this.getOverflowExtents().printCacheStats(out);
        }
        finally {
            this.read.unlock();
        }
    }

    public void resetCacheStats() {
        this.write.lock();
        try {
            this.nodeExtents.resetStats();
            this.getOverflowExtents().resetStats();
        }
        finally {
            this.write.unlock();
        }
    }

    public void clearCache() {
        this.write.lock();
        try {
            if (this.nodeExtents != null) {
                this.nodeExtents.clearCache();
            }
            if (this.overflowExtents != null) {
                this.getOverflowExtents().clearCache();
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void drainCache(boolean immediate) {
        this.write.lock();
        try {
            if (this.nodeExtents != null) {
                this.nodeExtents.drainCache(immediate);
            }
            if (this.overflowExtents != null) {
                this.getOverflowExtents().drainCache(immediate);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void clearWriteBack() {
        this.write.lock();
        try {
            if (this.nodeExtents != null) {
                this.nodeExtents.clearWriteBack();
            }
            if (this.overflowExtents != null) {
                this.getOverflowExtents().clearWriteBack();
            }
        }
        finally {
            this.write.unlock();
        }
    }

    void decSize() {
        this.size.setHeaderValue(this.size.getHeaderValue() - 1);
    }

    public void beginWrite() {
        this.write.lock();
    }

    public void endWrite() {
        this.write.unlock();
    }

    public void beginRead() {
        this.read.lock();
    }

    public void endRead() {
        this.read.unlock();
    }

    public class Access {
        public Node getRootNode() {
            return BPTree.this.getRootNode();
        }
    }

    static class BPTreeIterator
    implements Iterator<Map.Entry<Key, byte[]>> {
        private Node startNode;
        private int cursor;
        private Node cursorNode;
        int endPos;
        Node endNode;
        private Entry entry;

        public BPTreeIterator(Key start, Key end, BPTree tree) throws TreeInconsistencyException {
            SearchResult result;
            PooledByteBuffer buffer;
            if (end != null) {
                // empty if block
            }
            if (start == null) {
                this.cursorNode = this.startNode = tree.getFirstLeaf(tree.getRootNode());
                this.cursor = 0;
            } else {
                buffer = start.writeKeyData();
                KeyInfo startInfo = new KeyInfo(buffer, tree);
                buffer.returnBuffer();
                result = tree.findLeafNode(tree.getRootNode(), startInfo, false, false);
                if (result != null) {
                    this.cursorNode = this.startNode = result.node;
                    this.cursor = result.position;
                }
            }
            if (end == null) {
                this.endNode = tree.getLastLeaf(tree.getRootNode());
                this.endPos = this.endNode.getFillSize();
            } else {
                buffer = end.writeKeyData();
                KeyInfo e = new KeyInfo(buffer, tree);
                buffer.returnBuffer();
                result = tree.findLeafNode(tree.getRootNode(), e, false, true);
                if (result != null) {
                    this.endNode = result.node;
                    this.endPos = result.position;
                }
            }
            if (this.cursorNode != null && this.cursorNode.getBuffer() == null) {
                Assert.isTrue((boolean)false, (String)Messages.bTreeMsg_cursornodenobuffer);
            }
        }

        @Override
        public boolean hasNext() {
            this.entry = null;
            if (this.cursorNode != null) {
                int max;
                int n = max = this.cursorNode == this.endNode ? Math.min(this.endNode.getFillSize(), this.endPos + 1) : this.cursorNode.getFillSize();
                if (this.cursor < max) {
                    this.entry = new Entry(this.cursorNode, this.cursor);
                    return true;
                }
                if (this.cursor >= max) {
                    this.cursorNode = null;
                    return false;
                }
                if (this.cursorNode == this.startNode) {
                    this.cursorNode = null;
                    return false;
                }
            }
            return false;
        }

        @Override
        public Map.Entry<Key, byte[]> next() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            int fillsize = this.cursorNode.getFillSize();
            if (this.cursor + 1 >= fillsize) {
                this.cursor = 0;
                this.cursorNode = this.cursorNode.getNextNode();
            } else {
                ++this.cursor;
            }
            return this.entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static class Entry
        implements Map.Entry<Key, byte[]> {
            private final Node node;
            private final int cursor;

            public Entry(Node node, int cursor) {
                this.node = node;
                this.cursor = cursor;
            }

            @Override
            public Key getKey() {
                return (Key)this.node.getKeys().get(this.cursor);
            }

            @Override
            public byte[] getValue() {
                return (byte[])this.node.getData().get(this.cursor);
            }

            @Override
            public byte[] setValue(byte[] value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }

            @Override
            public int hashCode() {
                return super.hashCode();
            }
        }
    }

    private class DirectNodeFileFactory
    extends DBRecordFactory {
        private final int treeBranches;

        DirectNodeFileFactory(int treeBranches) {
            this.treeBranches = treeBranches;
        }

        @Override
        public int[] recordTypes() {
            return new int[]{1, 2};
        }

        @Override
        public DBRecord createRecord(int recordType, ExtentManager manager) {
            if (recordType == 1) {
                return new Node(1, BPTree.this);
            }
            if (recordType == 2) {
                return new Node(2, BPTree.this);
            }
            return null;
        }

        @Override
        public int getSize(int recordType) {
            int leafNodeSize = 4 + (BPTree.this.keySize + BPTree.this.dataSize) * (this.treeBranches - 1) + 4;
            int innerNodeSize = 4 + BPTree.this.keySize * (this.treeBranches - 1) + 4 * this.treeBranches;
            if (recordType == 1) {
                return leafNodeSize;
            }
            if (recordType == 2) {
                return innerNodeSize;
            }
            return -1;
        }

        @Override
        public int getAverageSize(int recordType) {
            return this.getSize(recordType);
        }
    }

    class KeyRecordFactory
    extends DBRecordFactory {
        KeyRecordFactory() {
        }

        @Override
        public int[] recordTypes() {
            return new int[]{3};
        }

        @Override
        public DBRecord createRecord(int recordType, ExtentManager manager) {
            if (recordType == 3) {
                return new OverflowedKeyRecord(3, BPTree.this);
            }
            return null;
        }

        @Override
        public int getSize(int recordType) {
            return BPTree.this.factory.getSize();
        }

        @Override
        public int getAverageSize(int recordType) {
            return BPTree.this.factory.getAverageSize();
        }
    }

    static class SearchResult {
        public Node node;
        public int position;

        SearchResult() {
        }
    }
}

