/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import java.nio.ByteBuffer;

public class SplitRecord
extends DBRecord {
    private static final PooledByteBuffer EMPTY = new PooledByteBuffer(ByteBuffer.allocate(0));
    static final int BEGINING_TYPE = -2;
    static final int MIDDLE_TYPE = -3;
    static final int END_TYPE = -4;
    static final int ENTRY_POINTER = -5;
    private PooledByteBuffer original;
    int originalDataType;
    int nextRecord = 65535;

    SplitRecord(int type) {
        super(type);
    }

    @Override
    protected boolean isSplit() {
        return this.getDataType() != -5;
    }

    public void setOriginalBuffer(PooledByteBuffer slice) {
        if (this.original != null) {
            this.original.returnBuffer();
        }
        this.original = slice.duplicate();
    }

    @Override
    public void readRecord(PooledByteBuffer input) {
        if (this.getDataType() == -2) {
            this.originalDataType = input.buffer.get();
            this.nextRecord = ByteUtils.bytesToUnsignedShort(input.buffer);
            this.setOriginalBuffer(input);
        } else if (this.getDataType() == -3) {
            this.nextRecord = ByteUtils.bytesToUnsignedShort(input.buffer);
            this.setOriginalBuffer(input);
        } else if (this.getDataType() == -5) {
            this.nextRecord = input.buffer.getInt();
        } else {
            this.setOriginalBuffer(input);
        }
        input.returnBuffer();
    }

    public void readNextRecordField(PooledByteBuffer input) {
        if (this.getDataType() == -2) {
            this.originalDataType = input.buffer.get();
            this.nextRecord = ByteUtils.bytesToUnsignedShort(input.buffer);
        } else if (this.getDataType() == -3) {
            this.nextRecord = ByteUtils.bytesToUnsignedShort(input.buffer);
        } else if (this.getDataType() == -5) {
            this.nextRecord = input.buffer.getInt();
        }
        input.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeRecord() {
        if (this.getDataType() == -4) {
            PooledByteBuffer output = this.original;
            this.original = null;
            return output;
        }
        if (this.getDataType() == -2) {
            this.original.buffer.rewind();
            PooledByteBuffer buf = PooledByteBuffer.INSTANCE.leaseByteBuffer(3 + this.original.buffer.remaining());
            buf.buffer.put((byte)this.originalDataType);
            buf.buffer.put(ByteUtils.unsignedShortToBytes(this.nextRecord));
            buf.buffer.put(this.original.buffer);
            buf.buffer.rewind();
            this.original.returnBuffer();
            this.original = null;
            return buf;
        }
        if (this.getDataType() == -3) {
            this.original.buffer.rewind();
            PooledByteBuffer buf = PooledByteBuffer.INSTANCE.leaseByteBuffer(2 + this.original.buffer.remaining());
            buf.buffer.put(ByteUtils.unsignedShortToBytes(this.nextRecord));
            buf.buffer.put(this.original.buffer);
            buf.buffer.rewind();
            this.original.returnBuffer();
            this.original = null;
            return buf;
        }
        if (this.getDataType() == -5) {
            ByteBuffer ID = ByteBuffer.allocate(4);
            ID.putInt(this.nextRecord);
            ID.rewind();
            return new PooledByteBuffer(ID);
        }
        return EMPTY;
    }

    @Override
    public int getSize() {
        if (this.getDataType() == -4) {
            return this.original.buffer.limit();
        }
        if (this.getDataType() == -2) {
            return 3 + this.original.buffer.limit();
        }
        if (this.getDataType() == -3) {
            return 2 + this.original.buffer.limit();
        }
        if (this.getDataType() == -5) {
            return 4;
        }
        return 0;
    }

    public int getOriginalBufferSize() {
        return this.original.buffer.limit();
    }

    public PooledByteBuffer getOriginalBuffer() {
        this.original.buffer.rewind();
        PooledByteBuffer o = this.original;
        this.original = null;
        return o;
    }

    @Override
    public String toString() {
        String type = null;
        if (this.getDataType() == -4) {
            type = "END TYPE";
        } else if (this.getDataType() == -3) {
            type = "MIDDLE TYPE";
        } else if (this.getDataType() == -2) {
            type = "BEGINING_TYPE";
        } else if (this.getDataType() == -5) {
            type = "ENTRY_POINTER";
            return String.valueOf(type) + " nextExtent: " + this.getEntryPointerExtent() + " nextRecord: " + this.getEntryPointerRecord() + " (" + this.getEntryPointerData() + ")";
        }
        return String.valueOf(type) + " nextRec: " + this.nextRecord;
    }

    public void setEntryPointerData(int nextExtent, int recordId) {
        this.nextRecord = ByteUtils.doubleUnsignedShortToInt(nextExtent, recordId);
    }

    public int getEntryPointerData() {
        return this.nextRecord;
    }

    public int getEntryPointerExtent() {
        return ByteUtils.intToFirstUnsignedShort(this.nextRecord);
    }

    public int getEntryPointerRecord() {
        return ByteUtils.intToSecondUnsignedShort(this.nextRecord);
    }
}

