/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import java.nio.ByteBuffer;

public class ShortFileHeader
extends FileHeader {
    private short value = 0;
    private short def = 0;

    public ShortFileHeader(String name, short def) {
        super(name);
        this.def = def;
        this.value = def;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "Value: " + this.value + " Default: " + this.def;
    }

    public short getHeaderValue() {
        return this.value;
    }

    @Override
    public short getSize() {
        return 2;
    }

    @Override
    public void readRecord(PooledByteBuffer bytes) {
        this.value = bytes.buffer.getShort();
        bytes.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeRecord() {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort(this.value);
        buf.rewind();
        return new PooledByteBuffer(buf);
    }

    public void setHeaderValue(short val) {
        this.value = val;
    }

    @Override
    public void reset() {
        this.value = this.def;
    }
}

