/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.ByteBufferPool;
import java.nio.ByteBuffer;

public class PooledByteBuffer {
    public final ByteBuffer buffer;
    public int capacity;
    public final boolean pooled;
    public boolean inpool;
    public static final ByteBufferPool INSTANCE = new ByteBufferPool();

    PooledByteBuffer(int capacity) {
        this.capacity = capacity;
        this.pooled = false;
        this.buffer = null;
    }

    PooledByteBuffer(ByteBuffer buffer, boolean pooled) {
        this.buffer = buffer;
        this.capacity = buffer.capacity();
        this.pooled = pooled;
    }

    public PooledByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.capacity = buffer.capacity();
        this.pooled = false;
    }

    public String toString() {
        return "Capacity: " + this.capacity + " pooled: " + this.pooled;
    }

    public ByteBuffer copy() {
        if (InternalAPI.Tweaks.SHOULD_USE_POOLED_DIRECT_BUFFER) {
            ByteBuffer heap = ByteBuffer.allocate(this.buffer.remaining());
            heap.put(this.buffer.slice());
            heap.rewind();
            return heap;
        }
        return this.buffer.slice();
    }

    public PooledByteBuffer duplicate() {
        if (this.pooled) {
            PooledByteBuffer dup = INSTANCE.leaseByteBuffer(this.buffer.remaining());
            dup.buffer.put(this.buffer.slice());
            dup.buffer.rewind();
            return dup;
        }
        return new PooledByteBuffer(this.copy());
    }

    public void returnBuffer() {
        INSTANCE.returnByteBuffer(this);
    }
}

