/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.nls.Messages;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public interface IO {
    public void position(int var1) throws FatalIOException;

    public void write(ByteBuffer var1) throws FatalIOException;

    public PooledByteBuffer read(int var1) throws FatalIOException;

    public boolean init(boolean var1, int var2) throws FatalIOException;

    public void close() throws FatalIOException;

    public PooledByteBuffer allocate(int var1) throws FatalIOException;

    public IO duplicate() throws FatalIOException;

    public void delete() throws FatalIOException;

    public void flush();

    public IO expand(int var1);

    public int size();

    public static class BufferIO
    implements IO {
        private ByteBuffer buffer;
        private final File file;
        private RandomAccessFile raf;
        private FileChannel channel;
        private FileLock lock;

        public BufferIO(File file) {
            this.file = file;
        }

        private BufferIO(File file, ByteBuffer buffer) {
            this.file = file;
            this.buffer = buffer;
        }

        private void ensureOpen() throws FatalIOException {
            if (this.buffer == null) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_file_x_has_been_closed, (Object)fileName), 1);
            }
        }

        @Override
        public IO duplicate() throws FatalIOException {
            this.ensureOpen();
            ByteBuffer buf = this.buffer.duplicate();
            return new BufferIO(this.file, buf);
        }

        @Override
        public void position(int newPosition) throws FatalIOException {
            this.ensureOpen();
            try {
                this.buffer.position(newPosition);
            }
            catch (RuntimeException e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_set_position_to_x_for_y, (Object)newPosition, (Object)fileName), e);
            }
        }

        @Override
        public void write(ByteBuffer src) throws FatalIOException {
            this.ensureOpen();
            int position = this.buffer.position();
            try {
                this.buffer.put(src);
            }
            catch (RuntimeException e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_write, (Object[])new Object[]{position, src.limit(), fileName}), e);
            }
        }

        @Override
        public PooledByteBuffer read(int bytes) throws FatalIOException {
            this.ensureOpen();
            int position = this.buffer.position();
            try {
                this.buffer.limit(this.buffer.position() + bytes);
                ByteBuffer slice = this.buffer.slice();
                this.buffer.position(this.buffer.limit());
                this.buffer.limit(this.buffer.capacity());
                return new PooledByteBuffer(slice);
            }
            catch (RuntimeException e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_read_offset_x_length_y_file_z, (Object[])new Object[]{position, bytes, fileName}), e);
            }
        }

        @Override
        public void close() throws FatalIOException {
            try {
                if (this.buffer != null) {
                    ((MappedByteBuffer)this.buffer).force();
                }
                if (this.lock != null) {
                    this.lock.release();
                }
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.raf != null) {
                    this.raf.close();
                }
                this.buffer = null;
                this.raf = null;
                this.channel = null;
                this.lock = null;
            }
            catch (Exception e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_close, (Object)fileName), e);
            }
        }

        @Override
        public boolean init(boolean create, int totalBytes) throws FatalIOException {
            if (create) {
                this.create(totalBytes);
                return false;
            }
            if (this.file.exists()) {
                try {
                    this.raf = new RandomAccessFile(this.file, "rw");
                    this.channel = this.raf.getChannel();
                    this.lock = this.channel.tryLock();
                    if (this.lock == null) {
                        throw new FatalIOException(Messages.bTreeMsg_no_lock, null);
                    }
                    this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, totalBytes);
                    return true;
                }
                catch (Exception e) {
                    String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                    throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_init, (Object)fileName), e);
                }
            }
            this.create(totalBytes);
            return false;
        }

        private void create(int totalBytes) throws FatalIOException {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
                this.raf = new RandomAccessFile(this.file, "rw");
                this.channel = this.raf.getChannel();
                this.lock = this.channel.tryLock();
            }
            catch (Exception e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_init, (Object)fileName), e);
            }
            if (this.lock == null) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_no_lock, (Object)fileName), null);
            }
            try {
                this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, totalBytes);
                ByteBuffer empty = ByteBuffer.allocate(totalBytes);
                Arrays.fill(empty.array(), (byte)-1);
                empty.rewind();
                this.channel.position(0L);
                this.channel.write(empty);
            }
            catch (Exception e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_create_X, (Object)fileName), e);
            }
        }

        @Override
        public void delete() throws FatalIOException {
            this.close();
            this.raf = null;
            this.lock = null;
            this.buffer = null;
            this.channel = null;
            boolean didDelete = this.file.delete();
            if (!didDelete && Logger.SHOULD_TRACE_DEBUG) {
                Logger.trace(Logger.Category.DEBUG, NLS.bind((String)Messages.bTreeMsg_file_in_use_X, (Object)this.file.getAbsolutePath()), new Throwable[]{null});
            }
        }

        @Override
        public PooledByteBuffer allocate(int bytes) throws FatalIOException {
            ByteBuffer copy = this.buffer.duplicate();
            copy.limit(copy.position() + bytes);
            ByteBuffer newBuf = copy.slice();
            return new PooledByteBuffer(newBuf);
        }

        @Override
        public void flush() {
        }

        @Override
        public IO expand(int bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.buffer.capacity();
        }
    }

    public static class FileChannelIO
    implements IO {
        private FileChannel channel;
        private File file;
        private RandomAccessFile raf;
        private FileLock lock;
        private int position;
        private FileChannelIO real;
        private int startOffset = 0;
        private int endOffset = 0;

        public FileChannelIO(File file) {
            this.file = file;
        }

        private FileChannelIO(FileChannelIO real, int startOffset, int endOffset) {
            this.real = real;
            this.position = startOffset;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        protected FileChannelIO getRoot() {
            FileChannelIO fio = this;
            while (fio != null) {
                if (fio.real == null) break;
                fio = fio.real;
            }
            return fio;
        }

        @Override
        public int size() {
            return this.endOffset;
        }

        @Override
        public void position(int newPosition) throws FatalIOException {
            this.position = newPosition + this.startOffset;
            if (this.position > this.endOffset) {
                Assert.isLegal((boolean)false, (String)"Position falls outside io range");
            }
        }

        @Override
        public void write(final ByteBuffer src) throws FatalIOException {
            this.runUninterruptibly(new Callable<Object>(){

                @Override
                public Object call() {
                    FileChannelIO.this.doWrite(src);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doWrite(ByteBuffer src) {
            block10: {
                this.ensureOpen();
                try {
                    if (this.real != null) {
                        FileChannel fileChannel = this.real.channel;
                        synchronized (fileChannel) {
                            int bytes = src.remaining();
                            this.real.channel.position(this.position);
                            this.real.channel.write(src);
                            this.position += bytes;
                            break block10;
                        }
                    }
                    FileChannel fileChannel = this.channel;
                    synchronized (fileChannel) {
                        int bytes = src.remaining();
                        this.channel.position(this.position);
                        this.channel.write(src);
                        this.position += bytes;
                    }
                }
                catch (IOException e) {
                    String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                    throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_write, (Object[])new Object[]{this.position, src.limit(), fileName}), e);
                }
            }
            if (this.position > this.endOffset) {
                Assert.isLegal((boolean)false, (String)"Position falls outside io range");
            }
        }

        @Override
        public PooledByteBuffer read(final int bytes) throws FatalIOException {
            return this.runUninterruptibly(new Callable<PooledByteBuffer>(){

                @Override
                public PooledByteBuffer call() {
                    return FileChannelIO.this.doRead(bytes);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PooledByteBuffer doRead(int bytes) {
            this.ensureOpen();
            try {
                if (this.real == null) {
                    FileChannel fileChannel = this.channel;
                    synchronized (fileChannel) {
                        this.channel.position(this.position);
                        PooledByteBuffer buf = PooledByteBuffer.INSTANCE.leaseByteBuffer(bytes);
                        this.channel.read(buf.buffer);
                        buf.buffer.rewind();
                        this.position += bytes;
                        return buf;
                    }
                }
                FileChannel fileChannel = this.real.channel;
                synchronized (fileChannel) {
                    this.real.channel.position(this.position);
                    PooledByteBuffer buf = PooledByteBuffer.INSTANCE.leaseByteBuffer(bytes);
                    this.real.channel.read(buf.buffer);
                    buf.buffer.rewind();
                    this.position += bytes;
                    return buf;
                }
            }
            catch (IOException e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_read_offset_x_length_y_file_z, (Object[])new Object[]{this.position, bytes, fileName}), e);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean init(final boolean create, final int totalBytes) throws FatalIOException {
            return this.runUninterruptibly(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return FileChannelIO.this.doInit(create, totalBytes);
                }
            });
        }

        boolean doInit(boolean create, int totalBytes) throws FatalIOException {
            this.endOffset = this.startOffset + totalBytes;
            if (this.real == null) {
                if (create) {
                    this.create(totalBytes);
                    return false;
                }
                if (this.file.exists()) {
                    try {
                        this.raf = new RandomAccessFile(this.file, "rw");
                        this.channel = this.raf.getChannel();
                        this.lock = this.channel.tryLock();
                    }
                    catch (Exception e) {
                        String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                        throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_init, (Object)fileName), e);
                    }
                    if (this.lock == null) {
                        String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                        throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_no_lock, (Object)fileName), null);
                    }
                    return true;
                }
                this.create(totalBytes);
                return false;
            }
            try {
                if (this.real.raf.length() < (long)this.endOffset) {
                    this.zeroOut(totalBytes);
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_init, (Object)this.file.toURI().toString()), e);
            }
        }

        private void create(int totalBytes) throws FatalIOException {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
                this.raf = new RandomAccessFile(this.file, "rw");
                this.channel = this.raf.getChannel();
                this.lock = this.channel.tryLock();
            }
            catch (Exception e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_init, (Object)fileName), e);
            }
            if (this.lock == null) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_no_lock, (Object)fileName), null);
            }
            this.zeroOut(totalBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zeroOut(int bytes) {
            this.ensureOpen();
            ByteBuffer empty = ByteBuffer.allocate(bytes);
            Arrays.fill(empty.array(), (byte)-1);
            empty.rewind();
            try {
                if (this.real == null) {
                    FileChannel fileChannel = this.channel;
                    synchronized (fileChannel) {
                        this.channel.position(this.startOffset + 0);
                        this.channel.write(empty);
                    }
                }
                FileChannel fileChannel = this.real.channel;
                synchronized (fileChannel) {
                    this.real.channel.position(this.startOffset + 0);
                    this.real.channel.write(empty);
                }
                if (this.position > this.endOffset) {
                    Assert.isLegal((boolean)false, (String)"Position falls outside io range");
                }
            }
            catch (IOException e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_init_pos, (Object)fileName), e);
            }
            if (this.position > this.endOffset) {
                Assert.isLegal((boolean)false, (String)"Position falls outside io range");
            }
        }

        private <T> T runUninterruptibly(Callable<T> runnable) {
            Future<T> future = InternalAPI.getScheduled().submit(runnable);
            T result = null;
            boolean wasInterrupted = Thread.interrupted();
            try {
                while (true) {
                    try {
                        result = future.get();
                    }
                    catch (ExecutionException e) {
                        Throwable t = e.getCause() == null ? e : e.getCause();
                        throw new RuntimeException(t);
                    }
                    catch (InterruptedException interruptedException) {
                        wasInterrupted = true;
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return result;
        }

        @Override
        public void close() throws FatalIOException {
            try {
                if (this.lock != null) {
                    this.lock.release();
                    this.lock = null;
                }
                if (this.channel != null) {
                    this.channel.close();
                    this.channel = null;
                }
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
            }
            catch (Exception e) {
                String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_close, (Object)fileName), e);
            }
        }

        @Override
        public void delete() throws FatalIOException {
            this.close();
            if (this.file != null) {
                this.file.delete();
            }
        }

        @Override
        public PooledByteBuffer allocate(int bytes) throws FatalIOException {
            return PooledByteBuffer.INSTANCE.leaseByteBuffer(bytes);
        }

        @Override
        public IO duplicate() throws FatalIOException {
            return new FileChannelIO(this.getRoot(), this.startOffset, this.endOffset);
        }

        @Override
        public IO expand(int bytes) {
            return new FileChannelIO(this.getRoot(), this.endOffset, this.endOffset + bytes);
        }

        private void ensureOpen() throws FatalIOException {
            if (this.real == null) {
                if (this.channel == null) {
                    String fileName = this.file == null ? Messages.bTreeMsg_none : this.file.getAbsolutePath();
                    throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_file_x_has_been_closed, (Object)fileName), null);
                }
            } else {
                this.real.ensureOpen();
            }
        }
    }
}

