/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.Persistable;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.OverflowedKeyRecord;
import com.ibm.etools.references.internal.nls.Messages;
import org.eclipse.core.runtime.Assert;

public abstract class DBRecord
implements Persistable {
    private static final int STALE = 1;
    private static final int DELETED = 2;
    private static final int DELETEME = 4;
    private static final int DISPOSED = 8;
    private static final int FULLY_LOADED = 16;
    private static final int COMMITED = 32;
    private static final int ASSIGNED_NEW = 64;
    private final int dataType;
    int id = -1;
    int pointerToActual = 65535;
    ExtentManager manager;
    private volatile byte state;

    private synchronized boolean getBoolean(int mask) {
        return (this.state & mask) == mask;
    }

    private synchronized void setTrue(int mask) {
        this.state = (byte)(this.state | mask);
    }

    private synchronized void setFalse(int mask) {
        this.state = (byte)(this.state & ~mask);
    }

    public DBRecord(int dataType) {
        this.dataType = dataType;
        this.setFullyloaded(true);
    }

    public void init(ExtentManager manager) {
        this.manager = manager;
        if (this.manager == null) {
            this.setFullyloaded(true);
        } else {
            this.setFullyloaded(!manager.getFactory().shouldProxyLoad(this.dataType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFullyLoaded() {
        DBRecord dBRecord = this;
        synchronized (dBRecord) {
            return this.isFullyloaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullyLoad() {
        DBRecord dBRecord = this;
        synchronized (dBRecord) {
            if (this.manager != null) {
                this.manager.readRecordFully(this);
            }
            this.setFullyloaded(true);
        }
        if (!this.isFullyLoaded()) {
            Assert.isTrue((boolean)this.isFullyLoaded(), (String)("Record " + this.getId() + " full read attempt was not succesful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markLoaded() {
        DBRecord dBRecord = this;
        synchronized (dBRecord) {
            this.setFullyloaded(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLoadData() {
        DBRecord dBRecord = this;
        synchronized (dBRecord) {
            if (!this.isFullyLoaded()) {
                this.fullyLoad();
            }
        }
    }

    public void loadData() {
        if (!this.isFullyLoaded() && this.manager != null) {
            this.manager.loadData(this);
        }
    }

    public boolean isDeleted() {
        return this.isRecordDeleted();
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final int getId() {
        return this.id;
    }

    final void setId(int id) {
        this.id = id;
    }

    protected boolean isSplit() {
        return false;
    }

    public void setRecordId(int nextRecord) {
        this.id = ByteUtils.setSecondUnsignedShort(this.id, nextRecord);
    }

    public int getSize() {
        PooledByteBuffer payload = this.writeRecord();
        Assert.isNotNull((Object)payload, (String)Messages.bTreeMsg_DBRecord_0);
        return payload.buffer.limit();
    }

    @Override
    public abstract PooledByteBuffer writeRecord();

    @Override
    public abstract void readRecord(PooledByteBuffer var1);

    protected boolean isDirty() {
        return true;
    }

    protected void clean() {
    }

    protected final void become(OverflowedKeyRecord record) {
        this.id = record.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DBRecord dBRecord = this;
        synchronized (dBRecord) {
            this.setDisposed(true);
        }
    }

    void setDisposed(boolean disposed) {
        if (disposed) {
            this.setTrue(8);
        } else {
            this.setFalse(8);
        }
    }

    boolean isDisposed() {
        return this.getBoolean(8);
    }

    void setCommited(boolean commited) {
        if (commited) {
            this.setTrue(32);
        } else {
            this.setFalse(32);
        }
    }

    boolean isCommited() {
        return this.getBoolean(32);
    }

    void setFullyloaded(boolean fullyloaded) {
        if (fullyloaded) {
            this.setTrue(16);
        } else {
            this.setFalse(16);
        }
    }

    boolean isFullyloaded() {
        return this.getBoolean(16);
    }

    void setDeleteme(boolean deleteme) {
        if (deleteme) {
            this.setTrue(4);
        } else {
            this.setFalse(4);
        }
    }

    boolean isDeleteme() {
        return this.getBoolean(4);
    }

    void setRecordDeleted(boolean deleted) {
        if (deleted) {
            this.setTrue(2);
        } else {
            this.setFalse(2);
        }
    }

    boolean isRecordDeleted() {
        return this.getBoolean(2);
    }

    void setStale(boolean stale) {
        if (stale) {
            this.setTrue(1);
        } else {
            this.setFalse(1);
        }
    }

    boolean isStale() {
        return this.getBoolean(1);
    }

    boolean isAssignedNew() {
        return this.getBoolean(64);
    }

    void setAssignedNew(boolean assignednew) {
        if (assignednew) {
            this.setTrue(64);
        } else {
            this.setFalse(64);
        }
    }

    public String toDebugString() {
        return this.toRecordInfo();
    }

    private String toRecordInfo() {
        String s = "";
        if (this.isAssignedNew()) {
            s = String.valueOf(s) + " ASSIGNED_NEW ";
        }
        if (this.isDirty()) {
            s = String.valueOf(s) + " DIRTY ";
        }
        if (this.isDeleted()) {
            s = String.valueOf(s) + " DELETED ";
        }
        if (this.isDeleteme()) {
            s = String.valueOf(s) + " DELETEME ";
        }
        if (this.isDeleted()) {
            s = String.valueOf(s) + " DELETED ";
        }
        if (this.isStale()) {
            s = String.valueOf(s) + " STALE ";
        }
        if (this.isCommited()) {
            s = String.valueOf(s) + " COMMITED ";
        }
        if (this.isDisposed()) {
            s = String.valueOf(s) + " DISPOSED ";
        }
        if (this.isFullyloaded()) {
            s = String.valueOf(s) + " FULLY_LOADED ";
        }
        return "ID: " + this.getId() + s;
    }

    public String toString() {
        return this.toRecordInfo();
    }

    protected boolean isValid() {
        return !this.isDeleted() && !this.isDeleteme() && !this.isStale() && !this.isDisposed();
    }
}

