/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.nls.Messages;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class ByteBufferPool {
    private static final int MIN_BUFFER_SIZE = 512;
    private int poolsize = 0;
    private final TreeSet<PooledByteBuffer> pool = new TreeSet<PooledByteBuffer>(new Comparator<PooledByteBuffer>(){

        @Override
        public int compare(PooledByteBuffer o1, PooledByteBuffer o2) {
            int compare = o1.capacity - o2.capacity;
            if (compare == 0) {
                if (o1.buffer == null && o2.buffer == null) {
                    return 0;
                }
                if (o1.buffer == null && o2.buffer != null) {
                    return -1;
                }
                if (o1.buffer != null && o2.buffer == null) {
                    return 1;
                }
                compare = o1.hashCode() - o2.hashCode();
            }
            return compare;
        }
    });

    public synchronized PooledByteBuffer leaseByteBuffer(int size) {
        if (InternalAPI.Tweaks.SHOULD_USE_POOLED_DIRECT_BUFFER) {
            NavigableSet<PooledByteBuffer> tail = this.pool.tailSet(new PooledByteBuffer(size), true);
            PooledByteBuffer pooledByteBuffer = tail.pollFirst();
            if (pooledByteBuffer == null) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(Math.max(size, 512));
                pooledByteBuffer = new PooledByteBuffer(buffer, true);
                ++this.poolsize;
            }
            if (pooledByteBuffer.buffer.position() != 0) {
                throw new RuntimeException(Messages.bTreeMsg_pooledbufferdirty);
            }
            pooledByteBuffer.buffer.limit(size);
            pooledByteBuffer.inpool = false;
            return pooledByteBuffer;
        }
        return new PooledByteBuffer(ByteBuffer.allocate(size));
    }

    public synchronized void returnByteBuffer(PooledByteBuffer buffer) {
        if (buffer.pooled && !buffer.inpool) {
            buffer.inpool = true;
            buffer.buffer.clear();
            this.pool.add(buffer);
            if (buffer.buffer.position() != 0) {
                throw new RuntimeException(Messages.bTreeMsg_pooledbufferdirty);
            }
        }
    }
}

