/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.ReferenceThreadFactrory;
import com.ibm.etools.references.internal.nls.Messages;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadSupport {
    private static ScheduledExecutorService service;
    private static ExecutorService unbounded;
    private static ReferenceThreadFactrory factory;
    private static final long NANO_ORIGIN;

    static {
        NANO_ORIGIN = System.nanoTime();
    }

    private static synchronized ReferenceThreadFactrory getFactory() {
        if (factory == null) {
            ThreadGroup group = new ThreadGroup(Messages.InternalAPI_LinkIndexer);
            factory = new ReferenceThreadFactrory(group, Messages.InternalAPI_LinkIndexerWorker);
        }
        return factory;
    }

    public static synchronized ExecutorService getExecutor() {
        if (unbounded == null) {
            ThreadPoolExecutor scheduled = new ThreadPoolExecutor(InternalAPI.Tweaks.CACHED_THREAD_MIN_THREADS, InternalAPI.Tweaks.CACHED_THREAD_MAX_THREADS, (long)InternalAPI.Tweaks.CACHED_THREAD_KEEPALIVE, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadSupport.getFactory());
            scheduled.allowCoreThreadTimeOut(true);
            unbounded = scheduled;
        }
        return unbounded;
    }

    static final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    public static synchronized ScheduledExecutorService getScheduled() {
        if (service == null) {
            ReferenceThreadFactrory factory = new ReferenceThreadFactrory(ThreadSupport.getFactory().getGroup(), "Link Indexer Thread Scheduler");
            ScheduledThreadPoolExecutor scheduled = new ScheduledThreadPoolExecutor(InternalAPI.Tweaks.SCHEDULED_THREAD_MAX_THREADS, factory){

                @Override
                protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
                    ScheduledFutureTask<V> t = new ScheduledFutureTask<V>(callable, task.getDelay(TimeUnit.NANOSECONDS));
                    return t;
                }

                @Override
                protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
                    ScheduledFutureTask<Object> t = new ScheduledFutureTask<Object>(Executors.callable(runnable, null), task.getDelay(TimeUnit.NANOSECONDS));
                    return t;
                }
            };
            scheduled.setKeepAliveTime(InternalAPI.Tweaks.SCHEDULED_THREAD_KEEPALIVE, TimeUnit.SECONDS);
            scheduled.allowCoreThreadTimeOut(true);
            service = scheduled;
        }
        return service;
    }

    private static class ScheduledFutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long time;
        private final Callable<V> callable;
        private final Object sync = new Object();
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile boolean canceled;
        private volatile Future<V> future;

        ScheduledFutureTask(Callable<V> callable, long ns) {
            this.callable = new CallableWrapper<V>(callable);
            this.time = ns;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - ThreadSupport.now(), TimeUnit.NANOSECONDS);
            return d;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        @Override
        public boolean isPeriodic() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.sync;
            synchronized (object) {
                if (!this.canceled && this.future == null) {
                    this.future = ThreadSupport.getExecutor().submit(this.callable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Object object = this.sync;
            synchronized (object) {
                if (this.future != null) {
                    return this.future.cancel(mayInterruptIfRunning);
                }
            }
            this.canceled = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            Future<V> localFuture;
            this.latch.await();
            Object object = this.sync;
            synchronized (object) {
                localFuture = this.future;
            }
            return localFuture.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Future<V> localFuture;
            this.latch.await(timeout, unit);
            Object object = this.sync;
            synchronized (object) {
                localFuture = this.future;
            }
            return localFuture.get(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object object = this.sync;
            synchronized (object) {
                if (this.future != null) {
                    return this.future.isCancelled();
                }
            }
            return this.canceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.sync;
            synchronized (object) {
                if (this.future != null) {
                    return this.future.isDone();
                }
            }
            return this.canceled;
        }

        private class CallableWrapper<VV>
        implements Callable<VV> {
            private final Callable<VV> callable;

            public CallableWrapper(Callable<VV> callable) {
                this.callable = callable;
            }

            @Override
            public VV call() throws Exception {
                VV result;
                try {
                    result = this.callable.call();
                }
                finally {
                    ScheduledFutureTask.this.latch.countDown();
                }
                return result;
            }
        }
    }
}

