/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.etools.references.Logger;
import java.lang.reflect.Method;

public class ProfilerProxy {
    private static boolean PROFILE = false;
    private static Object controllerInstance;
    private static Method cachedStartMethod;
    private static Method cachedStopMethod;
    private static Method cachedCaptureMethod;

    public static void startProfiling(String string) {
        try {
            if (PROFILE) {
                if (cachedStartMethod == null) {
                    Class<?> controller = Class.forName("com.yourkit.api.Controller");
                    controllerInstance = controller.newInstance();
                    if (controllerInstance == null) {
                        PROFILE = false;
                        return;
                    }
                    cachedStartMethod = controller.getMethod("startCPUProfiling", Long.class, String.class);
                    if (cachedStartMethod == null) {
                        PROFILE = false;
                        return;
                    }
                    cachedCaptureMethod = controller.getMethod("captureSnapshot", Long.class);
                    if (cachedCaptureMethod == null) {
                        PROFILE = false;
                        return;
                    }
                    cachedCaptureMethod = controller.getMethod("stopCPUProfiling", new Class[0]);
                    if (cachedCaptureMethod == null) {
                        PROFILE = false;
                        return;
                    }
                }
                if (cachedStartMethod != null) {
                    cachedStartMethod.invoke(controllerInstance, new Long(12L), "");
                }
            }
        }
        catch (Exception e) {
            Logger.logException("Error during profiling", e);
            PROFILE = false;
        }
    }

    public static void captureSnapshot() {
        try {
            if (PROFILE) {
                cachedCaptureMethod.invoke(controllerInstance, new Long(0L));
            }
        }
        catch (Exception e) {
            Logger.logException("Error during profiling", e);
            PROFILE = false;
        }
    }

    public static void stop() {
        try {
            if (PROFILE) {
                cachedStopMethod.invoke(controllerInstance, new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.logException("Error during profiling", e);
            PROFILE = false;
        }
    }
}

