/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.CountUpDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;

public class InternalReferencesJob {
    private static final int NONE = 0;
    private static final int WAITING = 1;
    private static final int RUNNING = 2;
    private static final int RAN = 3;
    private static final int RESCHEDULED = 4;
    private static final int CANCELED = 5;
    private final Runnable runnable;
    private final CountUpDownLatch active = new CountUpDownLatch(0);
    private final AtomicInteger state = new AtomicInteger();
    private final Runnable runner = new Runnable(){

        @Override
        public void run() {
            while (true) {
                if (InternalReferencesJob.this.state.get() == 5) {
                    if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " Was CANCELED, aborting", new Throwable[0]);
                    break;
                }
                if (InternalReferencesJob.this.state.get() == 3) {
                    if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " Was RAN, aborting", new Throwable[0]);
                    break;
                }
                if (InternalReferencesJob.this.state.get() == 0) {
                    if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " Was NONE, aborting", new Throwable[0]);
                    break;
                }
                if (InternalReferencesJob.this.state.get() == 2) {
                    if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " Was RUNNING, aborting", new Throwable[0]);
                    break;
                }
                if (InternalReferencesJob.this.state.compareAndSet(1, 2)) {
                    if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                        Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " WAITING TO RUNNING", new Throwable[0]);
                    }
                    try {
                        InternalReferencesJob.this.runnable.run();
                    }
                    catch (Exception e) {
                        Logger.logException("Exception during references job: ", e);
                    }
                    if (InternalReferencesJob.this.state.compareAndSet(2, 3) && Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                        Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " RUNNING TO RAN", new Throwable[0]);
                    }
                    InternalReferencesJob.this.active.countDown();
                    if (InternalReferencesJob.this.state.get() != 4) break;
                    continue;
                }
                if (InternalReferencesJob.this.state.compareAndSet(4, 2)) {
                    if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                        Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " RESCHEDULED TO RUNNING", new Throwable[0]);
                    }
                    try {
                        InternalReferencesJob.this.runnable.run();
                    }
                    catch (Exception e) {
                        Logger.logException("Exception during references job: ", e);
                    }
                    if (InternalReferencesJob.this.state.compareAndSet(2, 3) && Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                        Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + " RUNNING TO RAN", new Throwable[0]);
                    }
                    InternalReferencesJob.this.active.countDown();
                    if (InternalReferencesJob.this.state.get() != 4) break;
                    continue;
                }
                if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) continue;
                Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + InternalReferencesJob.this.runnable.toString() + "  Whoa! State in active transition, SPINNING", new Throwable[0]);
            }
        }
    };
    private volatile ScheduledFuture<?> schedule;

    public InternalReferencesJob(Runnable runnable) {
        if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
            Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + runnable.toString() + " started", new Throwable[0]);
        }
        this.runnable = runnable;
    }

    public void cancelJoin() {
        this.doCancel(true);
    }

    public void cancel() {
        this.doCancel(false);
    }

    private void doCancel(boolean join) {
        while (true) {
            if (this.state.get() == 3) {
                if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " Cancelation not needed, job already RAN", new Throwable[0]);
                break;
            }
            if (this.state.get() == 5) {
                ScheduledFuture<?> local;
                if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " Cancelation not required, but canceling again anyways. Job already CANCELED", new Throwable[0]);
                }
                if ((local = this.schedule) != null) {
                    local.cancel(true);
                }
                if (!join) break;
                this.await();
                break;
            }
            if (this.state.compareAndSet(0, 5)) {
                if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " NONE TO CANCELED", new Throwable[0]);
                break;
            }
            if (this.state.compareAndSet(4, 5)) {
                if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " RESCHEDULED TO CANCELED", new Throwable[0]);
                }
                this.active.countDown();
                break;
            }
            if (this.state.compareAndSet(1, 5)) {
                if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " WAITING TO CANCELED", new Throwable[0]);
                }
                this.active.countDown();
                break;
            }
            if (this.state.compareAndSet(2, 5)) {
                if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " RUNNING TO CANCELED", new Throwable[0]);
                }
                Assert.isNotNull(this.schedule, (String)"This can't be");
                this.schedule.cancel(true);
                if (!join) break;
                this.await();
                break;
            }
            if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) continue;
            Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + "  Whoa! State in active transition, SPINNING", new Throwable[0]);
        }
    }

    private void await() {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                this.active.await();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isDone() {
        int s = this.state.get();
        return s == 5 || s == 3;
    }

    public boolean isCancelled() {
        return this.state.get() == 5;
    }

    public void get() {
        this.await();
    }

    public void schedule(long delay, TimeUnit unit) {
        while (true) {
            if (this.state.get() == 4) {
                if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " scheduled while RESCHEDULED, no schedule necessary", new Throwable[0]);
                break;
            }
            if (this.state.get() == 1) {
                if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) break;
                Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " scheduled while WAITING, no schedule necessary", new Throwable[0]);
                break;
            }
            if (this.state.compareAndSet(2, 4)) {
                if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " RUNNING TO RESCHEDULED", new Throwable[0]);
                }
                this.active.countUp();
                break;
            }
            if (this.state.compareAndSet(0, 1)) {
                if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
                    Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " NONE TO WAITING", new Throwable[0]);
                }
                this.doSchedule(delay, unit);
                break;
            }
            if (this.state.compareAndSet(3, 1)) {
                this.doSchedule(delay, unit);
                break;
            }
            if (this.state.compareAndSet(5, 1)) {
                this.doSchedule(delay, unit);
                break;
            }
            if (!Logger.SHOULD_TRACE_JOB_STATE_CHANGES) continue;
            Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + "  Whoa! State in active transition, SPINNING", new Throwable[0]);
        }
    }

    private void doSchedule(long delay, TimeUnit unit) {
        this.active.countUp();
        if (Logger.SHOULD_TRACE_JOB_STATE_CHANGES) {
            Logger.trace(Logger.Category.JOB_STATE_CHANGES, "IRJ: " + this.runnable.toString() + " Scheduling with delay " + delay + " " + unit.toString(), new Throwable[0]);
        }
        this.schedule = InternalAPI.getScheduled().schedule(this.runner, delay, unit);
    }
}

