/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IBrokenReferenceStrategyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;

public class DefaultBrokenReferenceStrategyProvider
implements IBrokenReferenceStrategyProvider {
    @Override
    public Collection<BrokenReference> findBrokenReferences(ILink link, Set<IResolvedReference> references) {
        IResolvedReference brokenRef;
        Set<IResolvedReference> matches = references;
        HashSet<IResolvedReference> broken = new HashSet<IResolvedReference>();
        HashSet<IResolvedReference> notBroken = new HashSet<IResolvedReference>();
        for (IResolvedReference resolvedReference : matches) {
            if (resolvedReference.getBrokenStatus() == BrokenStatus.IGNORED) continue;
            if (resolvedReference.getBrokenStatus() == BrokenStatus.NOTBROKEN) {
                notBroken.add(resolvedReference);
                continue;
            }
            if (resolvedReference.getBrokenStatus() == BrokenStatus.BROKEN) {
                broken.add(resolvedReference);
                continue;
            }
            Assert.isTrue((boolean)false, (String)Messages.DefaultBrokenReferenceStrategyProvider_InvalidResolvedReferenceStatus);
        }
        if (!notBroken.isEmpty()) {
            Iterator iterator = broken.iterator();
            block1: while (iterator.hasNext()) {
                brokenRef = (IResolvedReference)iterator.next();
                TextRange range = brokenRef.getFragmentLocation();
                if (range == null) continue;
                for (IResolvedReference notBrokenRef : notBroken) {
                    TextRange nBrknRange = notBrokenRef.getFragmentLocation();
                    if (nBrknRange == null || !nBrknRange.intersets(range)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
        ArrayList<BrokenReference> brokenRefs = new ArrayList<BrokenReference>();
        brokenRef = null;
        Iterator itr = broken.iterator();
        if (itr.hasNext()) {
            brokenRef = (IResolvedReference)itr.next();
            itr.remove();
        }
        while (brokenRef != null) {
            TextRange range = brokenRef.getFragmentLocation();
            ArrayList<IResolvedReference> potentialTargets = new ArrayList<IResolvedReference>();
            potentialTargets.add(brokenRef);
            Iterator i2 = broken.iterator();
            while (i2.hasNext()) {
                IResolvedReference brokenRef2 = (IResolvedReference)i2.next();
                TextRange range2 = brokenRef2.getFragmentLocation();
                if (range == null || !range.equals(range2)) continue;
                potentialTargets.add(brokenRef2);
                i2.remove();
            }
            String text = brokenRef.getFragmentText();
            if (brokenRef.getReference() == null) {
                return Collections.emptyList();
            }
            String customText = brokenRef.getReference().getParameter("bultin.param.brokenlinktext");
            if (customText != null) {
                text = customText;
            }
            TextRange brange = brokenRef.getFragmentLocation();
            ILink source = brokenRef.getSource();
            LinkNode<IResource> container = link.getContainer();
            if (brange != null && source != null && container != null) {
                BrokenReference ref = new BrokenReference();
                TextRange brokenRange = new TextRange(brange.getOffset() + source.getLinkLocation().getOffset(), brange.getLength(), brange.getLinenumber());
                ref.setBrokenReferenceRange(brokenRange);
                ref.setDescription(text);
                ref.setResource(container.getResource());
                ref.setSource(link);
                ref.setPotentialTargets(potentialTargets);
                ref.setBrokenResolvedReferenceId(brokenRef.getId());
                ref.setBrokenText(text);
                brokenRefs.add(ref);
            }
            if ((itr = broken.iterator()).hasNext()) {
                brokenRef = (IResolvedReference)itr.next();
                itr.remove();
                continue;
            }
            brokenRef = null;
        }
        return brokenRefs;
    }
}

