/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.IErrorListener;
import com.ibm.etools.references.events.IJobCanceledListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.InternalReferencesJob;
import com.ibm.etools.references.internal.ThreadSupport;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.EventCollector;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.ErrorRecovery;
import com.ibm.etools.references.internal.management.EventNotification;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.refactoring.ConvertLinksRefactoring;
import com.ibm.etools.references.internal.search.BasicPattern;
import com.ibm.etools.references.internal.search.InternalSearchEngine;
import com.ibm.etools.references.internal.services.LinkDetectorService;
import com.ibm.etools.references.internal.services.ProviderPerformanceTracker;
import com.ibm.etools.references.internal.services.ReferenceResolverService;
import com.ibm.etools.references.internal.services.ResourceApproverService;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.LinkPositionInfo;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.services.providers.IProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.util.NLS;

public class InternalAPI {
    private static HashMap<String, ParameterizedRunnable> registeredRunnables = new HashMap(2, 1.0f);
    public static final Object REBUILD_DB_ERROR = ErrorRecovery.REBUILD_DB_ERROR;
    public static final String SEPERATOR = "|!|";
    public static final Pattern SEP_PATTERN = Pattern.compile("\\|\\!\\|");
    public static final Object MARKERS_FAMILY = new Object();
    public static boolean LOAD_DATA_FOR_TO_STRING = false;
    private static RebuildDBJob job = new RebuildDBJob();

    public static ResourceApprovalEntry[] deserializeResourceApprovalPrefs(String stringList) {
        String[] list;
        ArrayList<ResourceApprovalEntry> items = new ArrayList<ResourceApprovalEntry>();
        String[] stringArray = list = SEP_PATTERN.split(stringList);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            items.add(ResourceApprovalEntry.deserialize(string));
            ++n2;
        }
        return items.toArray(new ResourceApprovalEntry[items.size()]);
    }

    public static String serializeResourceApprovalPrefs(ResourceApprovalEntry[] items) {
        StringBuilder builder = new StringBuilder();
        ResourceApprovalEntry[] resourceApprovalEntryArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceApprovalEntry resourceApprovalEntry = resourceApprovalEntryArray[n2];
            builder.append(resourceApprovalEntry.serialize());
            builder.append(SEPERATOR);
            ++n2;
        }
        return builder.toString();
    }

    public static SearchEngine getSearchEngineWithoutParticipants() {
        SearchEngine engine = new SearchEngine();
        engine.setIgnoreParticipants(true);
        return engine;
    }

    public static ReferenceElementFactory getReferenceElementFactory(int linkProviderId, int resolverProviderId, LinkNode<IResource> linkNode) {
        ReferenceElementFactory factory = new ReferenceElementFactory(linkProviderId, resolverProviderId, linkNode);
        return factory;
    }

    public static void addLink(ILink link) {
        EventCollector ec = new EventCollector();
        ReferenceDatabase.getDefault().addOrUpdateArtifact(link, ec);
        List<ReferenceEvent> events = ec.getEvents();
        if (!events.isEmpty()) {
            EventNotification.EventInfo info = new EventNotification.EventInfo();
            info.events = Collections.unmodifiableList(events);
            info.listeners = Collections.unmodifiableList(ReferenceManager.getReferenceManager().getListeners());
            ReferenceManager.getReferenceManager().getReferenceProcessor().getEventNotification().addEvents(info);
            ReferenceManager.getReferenceManager().getReferenceProcessor().getEventNotification().doSchedule(500L);
        }
    }

    public static void add(IJobCanceledListener listener) {
        ReferenceManager.getReferenceManager().add(listener);
    }

    public static void addRunnable(String key, ParameterizedRunnable runnable) {
        registeredRunnables.put(key, runnable);
    }

    public static ParameterizedRunnable getRunnable(String key) {
        return registeredRunnables.get(key);
    }

    public static void removeRunnable(String key) {
        registeredRunnables.remove(key);
    }

    public static void add(IErrorListener listener) {
        ReferenceManager.getReferenceManager().add(listener);
    }

    public static void removeMarkersForLinks(List<ILink> links) {
        ReferenceManager.getReferenceManager().removeMarkerForLinks(links);
    }

    public static void removeMarkersFor(List<BrokenReference> references) {
        ReferenceManager.getReferenceManager().removeMarkerFor(references);
    }

    public static void removeMarkersFor(IFile file) {
        ReferenceManager.getReferenceManager().removeMarkerFor(file);
    }

    public static void createMarkersFor(List<BrokenReference> references) {
        ReferenceManager.getReferenceManager().createMarkersFor(references);
    }

    public static void completeLink(IPath path, LinkNode<IResource> node, ILink link) {
        Assert.isTrue((boolean)(path == null ^ node == null), (String)"Both path and node cannot be null");
        if (path != null) {
            ((Link)link).setPath(path);
        }
        if (node != null) {
            ((Link)link).setContainer(node);
        }
        ((InternalReferenceObject)((Object)link)).freeze();
    }

    public static int getProviderId(IResolvedReference rr) {
        int id = ((InternalReferenceObject)((Object)rr)).getProviderId();
        return id;
    }

    public static int getLinkProviderId(String linkProviderId) {
        return LinkDetectorService.getInstance().getProviderId(linkProviderId);
    }

    public static int getResolverProviderId(String refResolverId) {
        return ReferenceResolverService.getInstance().getProviderId(refResolverId);
    }

    public static String getRefResolverId(int providerId) {
        return ReferenceResolverService.getInstance().getRefResolverId(providerId);
    }

    public static Set<ILink> getLinksWithPrefixPath(String path, IProgressMonitor monitor) {
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            BasicPattern pattern = new BasicPattern(path, IndexConstants.BY_SOURCEPATH, IReferenceElement.ElementType.LINK, 1);
            SearchEngine engine = new SearchEngine(true);
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            engine.search(pattern, null, req, monitor);
            Set<ILink> set = req.getMatches();
            return set;
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
    }

    public static void processLinkDelta(List<LinkDelta> delta) {
        if (delta == null || delta.isEmpty()) {
            return;
        }
        if (Logger.SHOULD_TRACE_JDT_DELTA) {
            String s = "Delta size: " + delta.size() + "\n";
            for (LinkDelta linkDelta : delta) {
                s = String.valueOf(s) + linkDelta + "\n";
            }
            Logger.trace(Logger.Category.JDT_DELTA, s, new Throwable[0]);
        }
        ReferenceManager manager = ReferenceManager.getReferenceManager();
        manager.processLinkDeltas(delta);
    }

    public static LinkDelta newLinkDelta(ILink link, int kind) {
        LinkDelta delta = new LinkDelta();
        delta.link = link;
        delta.kind = kind;
        return delta;
    }

    public static LinkDelta newLinkDelta(String name, SpecializedType specializedType, String linkProvider, String modelinstanceref, int kind) {
        Link link = ReferenceDatabase.getDefault().createNewLink();
        link.setSpecializedType(specializedType);
        link.setProviderId(LinkDetectorService.getInstance().getProviderId(linkProvider));
        link.setEndpoint(true);
        link.setName(name);
        LinkDelta delta = new LinkDelta();
        delta.link = link;
        delta.kind = kind;
        delta.modelinstanceref = modelinstanceref;
        return delta;
    }

    public static IReferenceElement getElement(int id) {
        return ReferenceDatabase.getDefault().getReferenceElement(id);
    }

    public static List<File> getIndexes() {
        return IndexManager.getIndexFiles();
    }

    public static Object getTree(File file) {
        return IndexManager.getTree(file);
    }

    public static void printIndex(File file, PrintStream stream, boolean includeLinks) {
        IndexManager.printIndexFile(file, stream, includeLinks);
    }

    public static void printExtensionStats(PrintStream stream) {
        ProviderPerformanceTracker.print(stream);
    }

    public static void printDatabase(PrintStream stream) {
        ReferenceDatabase.getDefault().print(stream);
    }

    public static void reload() {
        ReferenceManager manager = ReferenceManager.getReferenceManager();
        manager.reload();
    }

    public static Object getObject(int id) {
        IReferenceElement e = ReferenceDatabase.getDefault().getReferenceElement(id);
        if (e != null) {
            return e;
        }
        return ReferenceDatabase.getDefault().getInternalReferenceRecord(id);
    }

    public static void handleFrameworkException(Object causeContext, String friendlyMsg, Exception e, Set<ErrorEvent.PresentationHints> hints, boolean hardCrash) {
        LinkNode<IResource> root = ReferenceManager.getReferenceManager().getLinkNode((IResource)ResourcesPlugin.getWorkspace().getRoot());
        ReferenceEvent resetEvent = new ReferenceEvent(root, ReferenceEvent.Kind.FATAL_ERROR);
        ReferenceManager.getReferenceManager().getReferenceProcessor().getEventNotification().fireEvents(Collections.singletonList(resetEvent));
        if (hardCrash) {
            ReferenceManager.getReferenceManager().setFatalError();
            InternalAPI.logReferenceException(friendlyMsg, "com.ibm.etools.references", e, ErrorEvent.Kind.FRAMEWORK_ERROR, hints);
        } else {
            ErrorRecovery.performRecovery(causeContext, friendlyMsg, e, hints);
        }
    }

    public static void handleContributionException(String friendlyMsg, String pluginId, Throwable e, Set<ErrorEvent.PresentationHints> hints) {
        InternalAPI.logReferenceException(friendlyMsg, pluginId, e, ErrorEvent.Kind.CONTRIBUTION_ERROR, hints);
    }

    public static void logReferenceException(String friendlyMsg, String pluginId, Throwable e, ErrorEvent.Kind kind, Set<ErrorEvent.PresentationHints> hints) {
        if (e instanceof OperationCanceledException) {
            return;
        }
        Status friendlyStatus = new Status(4, "com.ibm.etools.references", 0, friendlyMsg, null);
        Status rootStatus = new Status(4, pluginId, 0, e.getClass().getSimpleName(), e);
        if (e instanceof ReferenceException) {
            rootStatus = ((ReferenceException)e).getStatus();
        } else if (e instanceof CoreException) {
            rootStatus = ((CoreException)e).getStatus();
        }
        MultiStatus multi = new MultiStatus("com.ibm.etools.references", 4, new IStatus[]{rootStatus}, friendlyStatus.getMessage(), null);
        List<IErrorListener> errorListeners = ReferenceManager.getReferenceManager().getErrorListeners();
        if (errorListeners.isEmpty()) {
            Logger.log((IStatus)multi);
        } else {
            Set<ErrorEvent.PresentationHints> thehints = hints;
            if (thehints == null) {
                thehints = Collections.emptySet();
            }
            ErrorEvent event = new ErrorEvent((IStatus)multi, kind, thehints);
            for (IErrorListener errorListener : errorListeners) {
                try {
                    errorListener.handleError(event);
                }
                catch (RuntimeException ee) {
                    String errorMesage = NLS.bind((String)"Error during error listener notification: ", (Object)errorListener.getClass().getName());
                    String errorPluginId = Activator.getBundleId(errorListener);
                    if (errorPluginId == null) {
                        errorPluginId = "com.ibm.etools.references";
                    }
                    Status errorStatus = new Status(2, errorPluginId, 0, errorMesage, (Throwable)ee);
                    Logger.log((IStatus)errorStatus);
                }
            }
        }
    }

    public static void storeValue(String nameSpace, String key, String value) {
        ReferenceDatabase.getDefault().storeValue(nameSpace, key, value);
    }

    public static void clearValue(String nameSpace, String key) {
        ReferenceDatabase.getDefault().clearValue(nameSpace, key);
    }

    public static String readValue(String nameSpace, String key, IProgressMonitor monitor) {
        return ReferenceDatabase.getDefault().readValue(nameSpace, key, monitor);
    }

    public static void drainCaches(boolean immediate) {
        ReferenceManager.getReferenceManager().getReferenceProcessor().clearResolverCache();
        ReferenceDatabase.getDefault().drainCache(immediate);
        IndexManager.drainCache(immediate);
    }

    public static void flushCaches() {
        InternalSearchEngine.removeCache();
        ReferenceManager.getReferenceManager().getReferenceProcessor().clearResolverCache();
        ReferenceDatabase.getDefault().sync();
        IndexManager.syncIndexes(false);
    }

    public static void boostPriority() {
        ReferenceManager.getReferenceManager().getReferenceProcessor().boostPriority();
    }

    public static void printStats(PrintStream stream) {
        ReferenceDatabase.getDefault().printCacheStats(stream);
        ReferenceManager.getReferenceManager().getReferenceProcessor().printResolverStats(stream);
        IndexManager.printIndexCacheStats(stream);
    }

    public static void resetCacheStats() {
        ReferenceDatabase.getDefault().resetStats();
        ReferenceManager.getReferenceManager().getReferenceProcessor().resetResolverCacheStats();
        IndexManager.resetCacheStats();
    }

    public static void clearFaultCount() {
        ErrorRecovery.clearFaultCount();
    }

    public static LinkDelta getQueuedLinkDelta(ILink link) {
        return ReferenceManager.getReferenceManager().getReferenceProcessor().getScheduler().getQueuedLinkDelta(link);
    }

    public static void updateLink(ILink link, String linkType, String elementName, String contextText, TextRange contextRange, String linkText, TextRange linkRange, boolean endpoint) {
        Link l = (Link)link;
        l.setName(elementName);
        l.setContextText(contextText);
        l.setContextLocation(contextRange);
        l.setText(linkText);
        l.setLocation(linkRange);
        l.setEndpoint(endpoint);
    }

    public static void setExternalReadiness(boolean ready) {
        ReferenceManager.getReferenceManager().getReferenceProcessor().getScheduler().setExternalReadiness(ready);
    }

    public static void waitForReadiness() {
        ReferenceManager.getReferenceManager().getReferenceProcessor().getScheduler().waitForReadiness();
    }

    public static void waitForMarkerJob() {
        boolean interrupted = Thread.interrupted();
        while (true) {
            ReferenceManager.getReferenceManager().getReferenceProcessor().getMarkerJob().schedule(1L);
            try {
                ReferenceManager.getReferenceManager().getReferenceProcessor().getMarkerJob().join();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static Refactoring getConvertRefactoring(String style, Object o) {
        return new RenameRefactoring((RenameProcessor)new ConvertLinksRefactoring(style, o));
    }

    public static void addLogListener(ILogListener listener) {
        Logger.addLogListener(listener);
    }

    public static void removeLogListener(ILogListener listener) {
        Logger.removeLogListener(listener);
    }

    public static List<String> getDebugOptions() {
        Logger.Category[] options = Logger.Category.values();
        HashSet<String> opt = new HashSet<String>(options.length);
        Logger.Category[] categoryArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Logger.Category o = categoryArray[n2];
            opt.add(o.getOption());
            ++n2;
        }
        ArrayList<String> blah = new ArrayList<String>();
        blah.addAll(opt);
        Collections.sort(blah);
        return blah;
    }

    public static boolean isEnabled(String option) {
        Logger.Category[] options;
        Logger.Category[] categoryArray = options = Logger.Category.values();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Logger.Category o = categoryArray[n2];
            if (option.equals(o.getOption())) {
                return Logger.isEnabled(o);
            }
            ++n2;
        }
        return false;
    }

    public static void setDebugOptionEnabled(String option, boolean enabled) {
        Logger.Category[] options;
        Logger.Category[] categoryArray = options = Logger.Category.values();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Logger.Category o = categoryArray[n2];
            if (option.equals(o.getOption())) {
                Logger.setDebugOptionEnabled(o, enabled);
                break;
            }
            ++n2;
        }
    }

    public static final int doubleUnsignedShortToInt(int short1, int short2) {
        return ByteUtils.doubleUnsignedShortToInt(short1, short2);
    }

    public static void resetManager(IProgressMonitor monitor) {
        ReferenceManager manager = ReferenceManager.getReferenceManager();
        manager.reset(monitor);
    }

    public static synchronized ExecutorService getExecutor() {
        return ThreadSupport.getExecutor();
    }

    public static synchronized ScheduledExecutorService getScheduled() {
        return ThreadSupport.getScheduled();
    }

    public static void setOverrideSuspendedFlag(boolean override) {
        ReferenceManager.getReferenceManager().setOverrideSuspendedFlag(override);
    }

    public static void registerAnnotationModelDocumentProvider(AbstractAnnotationModelDocumentProvider provider) {
        ReferenceManager.getReferenceManager().setAnnotationModelDocumentProvider(provider);
    }

    public static int getBrokenLinkSeverity() {
        return ReferenceManager.getReferenceManager().getBrokenLinkSeverity();
    }

    public static List<String> getApproversIds() {
        return ResourceApproverService.getInstance().getTypeIds();
    }

    public static String getApproverName(String id) {
        return ResourceApproverService.getInstance().getName(id);
    }

    public static String getApproverDescription(String id) {
        return ResourceApproverService.getInstance().getDescription(id);
    }

    public static String getStringMatterText(String path) {
        String actualSearchString = path;
        if (path.startsWith("/")) {
            actualSearchString = path;
        } else if (path.indexOf(42) == -1) {
            actualSearchString = String.valueOf('*') + actualSearchString + '*';
        }
        return actualSearchString;
    }

    public static IProvider getProviderById(int providerId) {
        return Service.getProviderByTypeId(providerId);
    }

    public static Job getRebuildJob() {
        return job;
    }

    public static class AbstractAnnotationModelDocumentProvider {
        public static AbstractAnnotationModelDocumentProvider NULL = new AbstractAnnotationModelDocumentProvider();

        public AnnotationModelDocumentPair getAnnotationModel(IFile resource) {
            return null;
        }

        public boolean hasAnnotationsModels() {
            return false;
        }

        public void flushChanges(IProgressMonitor monitor) {
        }

        public Set<LinkPositionInfo> getActivePositions(IFile resource) {
            return Collections.emptySet();
        }
    }

    public static class AnnotationModelDocumentPair {
        private IAnnotationModel annotationModel;
        private IDocument document;
        private ITextFileBuffer buffer;

        public void setAnnotationModel(IAnnotationModel annotationModel) {
            this.annotationModel = annotationModel;
        }

        public IAnnotationModel getAnnotationModel() {
            return this.annotationModel;
        }

        public void setBuffer(ITextFileBuffer buffer) {
            this.buffer = buffer;
        }

        public ITextFileBuffer getBuffer() {
            return this.buffer;
        }

        public void setDocument(IDocument document) {
            this.document = document;
        }

        public IDocument getDocument() {
            return this.document;
        }
    }

    public static class LinkDelta {
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        public ILink link;
        public String modelinstanceref;
        public int kind;

        public String toString() {
            String s = "";
            if (this.kind == 1) {
                s = String.valueOf(s) + "ADD";
            }
            if (this.kind == 2) {
                s = String.valueOf(s) + "REMOVE";
            }
            s = String.valueOf(s) + " L[";
            s = String.valueOf(s) + this.link.toString();
            s = String.valueOf(s) + "] MIR[";
            s = String.valueOf(s) + this.modelinstanceref;
            s = String.valueOf(s) + "]";
            return s;
        }
    }

    private static class RebuildDBJob
    extends Job {
        public RebuildDBJob() {
            super("Rebuilding link database");
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            InternalAPI.clearFaultCount();
            ReferenceManager.getReferenceManager().requestRebuildIndex(monitor);
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == RebuildDBJob.class;
        }
    }

    public static class ReferencesJob
    extends InternalReferencesJob {
        @Override
        public void cancel() {
            super.cancel();
        }

        @Override
        public void cancelJoin() {
            super.cancelJoin();
        }

        @Override
        public void get() {
            super.get();
        }

        @Override
        public boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public boolean isDone() {
            return super.isDone();
        }

        @Override
        public void schedule(long delay, TimeUnit milliseconds) {
            super.schedule(delay, milliseconds);
        }

        public ReferencesJob(Runnable runnable) {
            super(runnable);
        }
    }

    public static class ResourceApprovalEntry {
        private static String FIELD_SEP = "|%|";
        private static final Pattern FIELD_SEP_PATTERN = Pattern.compile("\\|\\%\\|");
        public static final int PATH = 0;
        public static final int APPROVER = 1;
        public String stringItem = "";
        public String approverId = "";
        public int type = 0;
        public boolean enabled = false;

        public String serialize() {
            return this.stringItem == null ? "" : String.valueOf(this.stringItem) + FIELD_SEP + this.approverId + FIELD_SEP + this.type + FIELD_SEP + Boolean.toString(this.enabled);
        }

        public static ResourceApprovalEntry deserialize(String string) {
            ResourceApprovalEntry item = new ResourceApprovalEntry();
            String[] fields = FIELD_SEP_PATTERN.split(string);
            if (fields.length == 1) {
                item.stringItem = fields[0];
                item.type = 0;
                item.enabled = true;
            } else {
                item.stringItem = fields[0];
                item.approverId = fields[1];
                item.type = Integer.parseInt(fields[2]);
                item.enabled = Boolean.parseBoolean(fields[3]);
            }
            return item;
        }
    }

    public static class Tweaks {
        public static final boolean SHOULD_CLEAR_DBCACHE = Tweaks.getBoolean("com.ibm.etools.references.shouldClearDbCache");
        public static final boolean ENABLE_THREAD_PRIORITIES;
        public static final boolean USE_COMPRESSION;
        public static final boolean ALWAYS_CLEAR_DB;
        public static final boolean IS_SUSPENDED;
        public static final boolean SHOULD_DISPLAY_DEBUG_DIALOG;
        public static final boolean SHOULD_USE_MAPPED_BUFFER;
        public static final boolean SHOULD_USE_POOLED_DIRECT_BUFFER;
        public static final boolean SHOULD_USE_IN_MEMORY_INDEX;
        public static final boolean SHOULD_TRANSFER_RULE;
        public static final boolean SHOULD_FLUSH_CACHE_AFTER_INDEX;
        public static final boolean SHOULD_INDEX_HTML_ID_ATTRIBUTE;
        public static final boolean SHOULD_AVOID_SCHEDULE_DURING_BUILD;
        public static final boolean SHOULD_TRACK_EXTENSION_PERFORMANCE;
        public static final int WRITEBACKDELAY;
        public static final int INDEX_BRANCHES;
        public static final int INDEX_NODES_PER_EXTENT;
        public static final int WAIT_TIME;
        public static final int INDEX_OVERFLOW_CACHE_SIZE;
        public static final int INDEX_CACHE_SIZE;
        public static final int DB_CACHE_SIZE;
        public static final int RESOLVER_CACHE_SIZE;
        public static final int INDEX_MIN_THRESHOLD;
        public static final int INDEX_MAX_THRESHOLD;
        public static final int INDEX_MAX_DBSIZE_THRESHOLD;
        public static final int INDEX_RATE_LIMIT_BACKGROUND;
        public static final int INDEX_RATE_LIMIT_FOREGROUND;
        public static final int SCHEDULER_MIN_SIZE_BEFORE_INDEX_MAX_WAIT;
        public static final int SCHEDULER_MIN_SIZE_BEFORE_INDEX;
        public static final int CACHED_THREAD_MIN_THREADS;
        public static final int CACHED_THREAD_MAX_THREADS;
        public static final int CACHED_THREAD_KEEPALIVE;
        public static final int SCHEDULED_THREAD_MAX_THREADS;
        public static final int SCHEDULED_THREAD_KEEPALIVE;
        public static final int ERROR_RECOVERY_STYLE;
        public static final int RECOVERY_STYLE_NORMAL = 0;
        public static final int RECOVERY_STYLE_NOAUTO = 1;
        public static final int MARKERS_SCHEDULE_DELAY;
        public static boolean ENABLE_DEBUG_OVERRIDE;

        static {
            SHOULD_TRACK_EXTENSION_PERFORMANCE = Tweaks.getBoolean("com.ibm.etools.references.shouldTrackExtensionPerformance");
            ENABLE_THREAD_PRIORITIES = Tweaks.getBoolean("com.ibm.etools.references.enableThreadPriorities");
            USE_COMPRESSION = Tweaks.getBoolean("com.ibm.etools.references.useCompression");
            ALWAYS_CLEAR_DB = Tweaks.getBoolean("com.ibm.etools.references.alwaysClear");
            IS_SUSPENDED = Tweaks.getBoolean("com.ibm.etools.references.suspendAll");
            SHOULD_DISPLAY_DEBUG_DIALOG = Tweaks.getBoolean("com.ibm.etools.references.enableDebugDialog");
            SHOULD_USE_MAPPED_BUFFER = Tweaks.getBoolean("com.ibm.etools.references.enableMappedByteBuffer");
            SHOULD_USE_POOLED_DIRECT_BUFFER = Tweaks.getBoolean("com.ibm.etools.references.enablePooledDirectBuffers");
            WAIT_TIME = Tweaks.getInt("com.ibm.etools.references.waitTime");
            INDEX_OVERFLOW_CACHE_SIZE = Tweaks.getInt("com.ibm.etools.references.overflowIndexCacheSize");
            INDEX_CACHE_SIZE = Tweaks.getInt("com.ibm.etools.references.indexCacheSize");
            DB_CACHE_SIZE = Tweaks.getInt("com.ibm.etools.references.dbCacheSize");
            RESOLVER_CACHE_SIZE = Tweaks.getInt("com.ibm.etools.references.resolverCacheSize");
            INDEX_MIN_THRESHOLD = Tweaks.getInt("com.ibm.etools.references.minThresholdSize");
            INDEX_MAX_THRESHOLD = Tweaks.getInt("com.ibm.etools.references.maxThresholdSize");
            INDEX_MAX_DBSIZE_THRESHOLD = Tweaks.getInt("com.ibm.etools.references.maxInMemoryDBSize");
            SHOULD_USE_IN_MEMORY_INDEX = Tweaks.getBoolean("com.ibm.etools.references.enableInMemoryIndex");
            SHOULD_INDEX_HTML_ID_ATTRIBUTE = Tweaks.getBoolean("com.ibm.etools.references.enableIndexHTMLIDAttribute");
            SHOULD_TRANSFER_RULE = Tweaks.getBoolean("com.ibm.etools.references.shouldTransferRule");
            SHOULD_FLUSH_CACHE_AFTER_INDEX = Tweaks.getBoolean("com.ibm.etools.references.shouldFlushCacheAfterIndex");
            SHOULD_AVOID_SCHEDULE_DURING_BUILD = Tweaks.getBoolean("com.ibm.etools.references.shouldAvoidScheduleDuringBuild");
            INDEX_RATE_LIMIT_BACKGROUND = Tweaks.getInt("com.ibm.etools.references.rateLimitBackground");
            INDEX_RATE_LIMIT_FOREGROUND = Tweaks.getInt("com.ibm.etools.references.rateLimitForeground");
            SCHEDULER_MIN_SIZE_BEFORE_INDEX = Tweaks.getInt("com.ibm.etools.references.schedulerMinSize");
            SCHEDULER_MIN_SIZE_BEFORE_INDEX_MAX_WAIT = Tweaks.getInt("com.ibm.etools.schedulerMinSizeMaxWait");
            INDEX_BRANCHES = Tweaks.getInt("com.ibm.etools.references.indexDefaultBranches");
            INDEX_NODES_PER_EXTENT = Tweaks.getInt("com.ibm.etools.references.indexNodesPerExtent");
            WRITEBACKDELAY = Tweaks.getInt("com.ibm.etools.references.writeBackDelay");
            MARKERS_SCHEDULE_DELAY = Tweaks.getInt("com.ibm.etools.references.markersScheduleDelay");
            CACHED_THREAD_MIN_THREADS = Tweaks.getInt("com.ibm.etools.references.cachedMinThread");
            CACHED_THREAD_MAX_THREADS = Tweaks.getInt("com.ibm.etools.references.cachedMaxThread");
            CACHED_THREAD_KEEPALIVE = Tweaks.getInt("com.ibm.etools.references.cachedThreadKeepAlive");
            SCHEDULED_THREAD_MAX_THREADS = Tweaks.getInt("com.ibm.etools.references.schedulerMaxThread");
            SCHEDULED_THREAD_KEEPALIVE = Tweaks.getInt("com.ibm.etools.references.schedulerKeepAlive");
            ERROR_RECOVERY_STYLE = Tweaks.getInt("com.ibm.etools.references.errorRecoveryStyle");
        }

        private static String getProperty(String property) {
            String value = System.getenv(property);
            if (value == null) {
                value = System.getProperty(property);
            }
            return value;
        }

        private static String getDefault(String property) {
            URL l;
            if (Activator.getDefault() == null && (l = InternalAPI.class.getResource("")) != null && Activator.getIndexerSettings().isEmpty()) {
                try {
                    File f = new File(l.toURI());
                    String name = f.getName();
                    while (name != null) {
                        if ("com.ibm.etools.references".equals(name)) break;
                        name = (f = f.getParentFile()) != null ? f.getName() : null;
                    }
                    f = new File(f, "/indexer.settings");
                    FileInputStream stream = new FileInputStream(f);
                    Activator.setSettings(stream);
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String value = Activator.getIndexerSettings().getProperty(property);
            return value;
        }

        private static boolean getBoolean(String key) {
            String property = Tweaks.getProperty(key);
            if (property != null) {
                System.out.println("Indexer tweak: " + key + "=" + Boolean.parseBoolean(property));
            }
            return property != null ? Boolean.parseBoolean(property) : Boolean.parseBoolean(Tweaks.getDefault(key));
        }

        private static int getInt(String key) {
            String property = Tweaks.getProperty(key);
            int size = 0;
            if (property != null) {
                try {
                    size = Integer.parseInt(property);
                    System.out.println("Indexer tweak: " + key + "=" + size);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        size = Integer.parseInt(Tweaks.getDefault(key));
                    }
                    catch (NumberFormatException e1) {
                        Exception n = new Exception(NLS.bind((String)"Exception during parse of default value for key ''{0}'' value was ''{1}''. Using 0 instead", (Object)key, (Object)property), e1);
                        n.printStackTrace();
                        size = 0;
                    }
                }
            } else {
                try {
                    size = Integer.parseInt(Tweaks.getDefault(key));
                }
                catch (NumberFormatException e1) {
                    Exception n = new Exception(NLS.bind((String)"Exception during parse of default value for key ''{0}'' value was ''{1}''. Using 0 instead", (Object)key, (Object)property), e1);
                    n.printStackTrace();
                    size = 0;
                }
            }
            return size;
        }
    }
}

