/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.providers.resolver;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.CheckedReferenceRename;
import com.ibm.etools.references.services.providers.IReferenceResolverProvider;
import com.ibm.etools.references.services.providers.RefactoringResolverParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class WebLinkResolverProvider
extends AbstractWebProvider
implements IReferenceResolverProvider {
    public String createLink(Reference reference, LinkNode<IFile> linkNode) {
        return null;
    }

    public IResolvedReference resolveReference(ReferenceElementFactory factory, Reference reference, IResolvedReference previousResult) throws ReferenceException {
        String cssLinkType = reference.getSource().getSpecializedType().getId();
        String pathString = null;
        pathString = cssLinkType.equalsIgnoreCase("wst.css.class.link") ? reference.getSource().getParameter("css.uri") : reference.getParameter("web.ref.abs.path.id");
        if (pathString == null) {
            return factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "web.node.css");
        }
        if (pathString.endsWith("/") || pathString.endsWith("\"")) {
            pathString = pathString.substring(0, pathString.length() - 1);
        }
        IPath path = Path.fromPortableString((String)pathString);
        String fragment = reference.getParameter("web.url.fragment.id");
        Set<Object> matches = null;
        SearchScope scope = SearchEngine.createSearchScope((IPath[])new IPath[]{path});
        if (fragment == null) {
            SearchPattern folderPattern;
            SearchPattern filePattern = SearchPattern.createPattern((String)"builtin.file.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            Set<ILink> tmpMatches = this.doSearch(filePattern, scope);
            if (tmpMatches.isEmpty() && (tmpMatches = this.doSearch(folderPattern = SearchPattern.createPattern((String)"builtin.folder.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0), scope)).isEmpty()) {
                SearchPattern projectPattern = SearchPattern.createPattern((String)"builtin.project.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
                tmpMatches = this.doSearch(projectPattern, scope);
            }
            matches = tmpMatches;
        } else {
            Collection fragmentTypes = ReferenceManager.getReferenceManager().getMatchingLinkTypes("couldBeFragment", "true");
            SearchPattern typePattern = null;
            for (SpecializedType specializedType : fragmentTypes) {
                String linkType = specializedType.getId();
                typePattern = typePattern == null ? SearchPattern.createPattern((String)linkType, (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0) : SearchPattern.createOrPattern((SearchPattern)typePattern, (SearchPattern)SearchPattern.createPattern((String)linkType, (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
            }
            if (typePattern == null) {
                matches = Collections.emptySet();
            } else {
                SearchPattern namePattern = SearchPattern.createPattern((String)fragment, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
                SearchPattern pattern = SearchPattern.createAndPattern((SearchPattern)namePattern, typePattern);
                matches = this.doSearch(pattern, scope);
            }
        }
        IResolvedReference result = null;
        if (matches.size() == 1) {
            ILink resolved = (ILink)matches.iterator().next();
            result = fragment == null ? factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, resolved, null) : factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, resolved, null, false);
        } else {
            BrokenStatus status = BrokenStatus.BROKEN;
            String brokenResolutionHint = reference.getParameter("param.brokenhint");
            if (brokenResolutionHint != null) {
                status = BrokenStatus.valueOf((String)brokenResolutionHint);
            }
            result = fragment == null ? factory.createResolvedReference(status, reference, null, path.toString()) : factory.createResolvedReference(status, reference, null, path.toString(), false);
        }
        return result;
    }

    private Set<ILink> doSearch(SearchPattern pattern, SearchScope scope) throws ReferenceException {
        NullProgressMonitor m = new NullProgressMonitor();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, (IProgressMonitor)m);
        Set matches = requestor.getMatches();
        return matches;
    }

    public String getModelInstanceIdReference(Reference reference) {
        String pathString = reference.getParameter("web.ref.abs.path.id");
        if (pathString != null) {
            IPath path = Path.fromPortableString((String)pathString);
            return path.toString();
        }
        return UUID.randomUUID().toString();
    }

    public static Reference createWebLinkReference(ILink link, String referenceType, URIUtil.ParsedURI uri, IPath absPath) {
        Reference reference = new Reference(link, referenceType);
        TextRange range = AbstractWebProvider.createTrimmedRange(link);
        reference.setFragmentLocation(range);
        reference.addParameter("web.ref.abs.path.id", absPath.toPortableString());
        if (uri != null && uri.fragment != null && uri.fragment.length() > 0) {
            reference.addParameter("web.url.fragment.id", uri.fragment);
        }
        return reference;
    }

    public Map<String, Object> renameReference(RefactoringResolverParameters params) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String path = (String)params.targetDescription.get("web.ref.abs.path.id");
        if (path == null) {
            if (params.target != null) {
                path = params.target.getResource().getFullPath().toPortableString();
            } else if (params.targetLink != null) {
                path = params.targetLink.getContainer().getResource().getFullPath().toPortableString();
            }
        }
        paramMap.put("web.ref.abs.path.id", path);
        return paramMap;
    }

    public CheckedReferenceRename checkRenameReference(RefactoringResolverParameters params) {
        CheckedReferenceRename rename = new CheckedReferenceRename();
        if ("wst.css.class.link".equals(params.resolvedReference.getSource().getSpecializedType().getId())) {
            rename.setRenameValidationStatus(Status.CANCEL_STATUS);
        } else {
            rename.setRenameParameters(this.renameReference(params));
            rename.setRenameValidationStatus(Status.OK_STATUS);
        }
        return rename;
    }
}

