/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.providers.generators;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.internal.nls.Messages;
import com.ibm.etools.references.web.providers.resolver.WebLinkResolverProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;

public class WebLinkGeneratorProvider
extends AbstractWebProvider
implements IReferenceGeneratorProvider {
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        Reference reference = null;
        String trimmed = AbstractWebProvider.trimQuotes(transformResult);
        if ("web.reference.workspacePath".equals(referenceType)) {
            if (link.getSpecializedType().getId().equals("web.commonlink")) {
                if (trimmed == null || trimmed.length() == 0) {
                    return Collections.emptyList();
                }
                reference = this.handleBaseHref(link, referenceType, transformResult);
                if (reference != null) {
                    return Collections.singletonList(reference);
                }
            }
            reference = this.createReference(link, transformResult, referenceType);
        }
        if (reference == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(reference);
    }

    private Reference handleBaseHref(ILink link, String referenceType, String transformResult) {
        String noQuotes;
        Reference baseHrefResult = null;
        String baseHref = link.getParameter("param.base.href");
        if (baseHref != null && !AbstractWebProvider.isDynamicLink(noQuotes = AbstractWebProvider.trimQuotes(transformResult))) {
            IPath convertToWorkspacePath;
            if (baseHref.startsWith("file://") && (convertToWorkspacePath = this.convertFileURLToWorkspacePath(baseHref, link.getContainer().getResource().getProject())) != null) {
                IPath convertedPath = convertToWorkspacePath.append(noQuotes);
                URIUtil.ParsedURI uri = URIUtil.parse(noQuotes);
                baseHrefResult = WebLinkResolverProvider.createWebLinkReference(link, referenceType, uri, convertedPath);
            }
            if (baseHrefResult == null) {
                baseHrefResult = new Reference(link, referenceType);
                baseHrefResult.setFragmentLocation(new TextRange(0, link.getLinkLocation().getLength(), link.getLinkLocation().getLinenumber()));
                baseHrefResult.setBrokenStatus(BrokenStatus.BROKEN);
            }
        }
        return baseHrefResult;
    }

    protected final IPath getWorkspacePathForWebAppRelativeLink(ILink link, URIUtil.ParsedURI uri) {
        IPath path;
        if (uri.path.startsWith("/")) {
            uri.path = uri.path.substring(1);
        }
        Path uriPath = new Path(uri.path);
        IContainer docRootFolder = WebUtil.getDocumentRootContainer(link.getContainer().getResource());
        if (docRootFolder == null) {
            return null;
        }
        IPath absPath = path = docRootFolder.getFullPath().append((IPath)uriPath);
        return absPath;
    }

    protected Reference createReference(ILink link, String rawLink, String referenceType) {
        String noQuotes = AbstractWebProvider.trimQuotes(rawLink);
        if (AbstractWebProvider.isDynamicLink(noQuotes)) {
            return null;
        }
        URIUtil.ParsedURI uri = URIUtil.parse(noQuotes);
        if (uri.scheme != null && !uri.scheme.equals("file")) {
            return null;
        }
        if (uri.path.length() == 0 && uri.fragment == null) {
            return null;
        }
        IPath absPath = this.getAbsolutePathFromLink(uri, link);
        Reference reference = null;
        if (absPath == null) {
            reference = new Reference(link, referenceType);
            reference.setFragmentLocation(new TextRange(0, link.getLinkLocation().getLength(), link.getLinkLocation().getLinenumber()));
            reference.setBrokenStatus(BrokenStatus.BROKEN);
        } else {
            reference = WebLinkResolverProvider.createWebLinkReference(link, referenceType, uri, absPath);
        }
        if (reference != null && ("j_security_check".equals(noQuotes) || "ibm_security_logout".equals(noQuotes))) {
            reference.setBrokenStatus(BrokenStatus.IGNORED);
        }
        return reference;
    }

    protected IPath getAbsolutePathFromLink(URIUtil.ParsedURI uri, ILink link) {
        IPath absPath = null;
        if (uri.scheme != null) {
            if (uri.scheme.equals("file")) {
                String filePath = uri.path;
                if (uri.authority != null && uri.authority.length() > 0) {
                    filePath = String.valueOf(uri.authority) + uri.path;
                }
                absPath = this.convertFileURLToWorkspacePath(filePath, link.getContainer().getResource().getProject());
            }
        } else {
            absPath = uri.path.startsWith("/") || uri.path.startsWith("\\") ? this.getWorkspacePathForServerContextLink(link, uri) : this.getWorkspacePathForRelativeLink(link, uri);
        }
        return absPath;
    }

    protected static IPath getWebAppRootRelativePath(IPath targetPath) {
        IContainer docRootFolder;
        IFile targetFile;
        IPath linkPath = null;
        if (targetPath != null && (targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath)) != null && (docRootFolder = WebUtil.getDocumentRootContainer((IResource)targetFile)) != null) {
            IPath docRootFolderPath = docRootFolder.getFullPath();
            int matchingFirstSegments = targetPath.matchingFirstSegments(docRootFolderPath);
            linkPath = targetPath.removeFirstSegments(matchingFirstSegments);
        }
        return linkPath;
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        String path = (String)params.renameParameters.get("web.ref.abs.path.id");
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        IPath targetPath = targetFile.getFullPath();
        IContainer docRootFolder = WebUtil.getDocumentRootContainer((IResource)targetFile);
        if (docRootFolder == null) {
            String txt = AbstractWebProvider.trimQuotes(params.reference.getSource().getLinkText());
            if (txt.startsWith("/") || txt.startsWith("\\")) {
                Status s = new Status(1, Messages.weblinks_none, Messages.WebLinkGeneratorProvider_2);
                return s;
            }
        } else if (!docRootFolder.getFullPath().isPrefixOf(targetPath)) {
            Status s = new Status(1, Messages.weblinks_none, Messages.weblinks_target_not_accessible_error);
            return s;
        }
        return Status.OK_STATUS;
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        String noQuotes = AbstractWebProvider.trimQuotes(params.transformResult);
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path((String)params.renameParameters.get("web.ref.abs.path.id")));
        IFile targetContainer = this.getTargetContainer(params);
        String contextRoot = (String)params.renameParameters.get("param.context.root");
        String newString = URIUtil.rename(params.renameArguments, targetContainer.getProject(), targetContainer.getFullPath().toString(), noQuotes, targetFile.getFullPath().toString(), contextRoot);
        return newString;
    }

    protected IFile getTargetContainer(RefactoringGeneratorParameters params) {
        IFile targetContainer = null;
        targetContainer = params.newReferenceTargetContainer != null ? (IFile)params.newReferenceTargetContainer.getResource() : (IFile)params.reference.getSource().getContainer().getResource();
        return targetContainer;
    }

    protected final IPath getWorkspacePathForRelativeLink(ILink link, URIUtil.ParsedURI uri) {
        IPath absPath = null;
        if (uri.path.length() == 0 && uri.fragment != null) {
            absPath = link.getContainer().getResource().getFullPath();
        } else {
            absPath = link.getContainer().getResource().getParent().getFullPath().append(uri.path);
            IContainer docRootFolder = WebUtil.getDocumentRootContainer(link.getContainer().getResource());
            if (docRootFolder == null) {
                return absPath;
            }
            IPath filePath = link.getContainer().getResource().getFullPath();
            int maxDoubleDotLimit = 0;
            if (docRootFolder.getFullPath().isPrefixOf(filePath)) {
                int matches = filePath.matchingFirstSegments(docRootFolder.getFullPath());
                filePath = filePath.removeFirstSegments(matches);
                filePath = filePath.removeLastSegments(1);
                maxDoubleDotLimit = Math.max(0, filePath.segmentCount());
            }
            int doubleDotCount = 0;
            String[] split = uri.path.split("/");
            int i = 0;
            while (i < split.length) {
                if ("..".equals(split[i])) {
                    ++doubleDotCount;
                } else if (!".".equals(split[i])) break;
                ++i;
            }
            if (doubleDotCount > maxDoubleDotLimit) {
                if (doubleDotCount - maxDoubleDotLimit > 1) {
                    return null;
                }
                Path p = new Path(uri.path);
                String contextRoot = (p = p.removeFirstSegments(doubleDotCount)).segment(0);
                if (contextRoot == null) {
                    return null;
                }
                p = p.removeFirstSegments(1);
                IProject project = this.getProjectWithContextRoot(contextRoot);
                if (project != null) {
                    IContainer docRoot = WebUtil.getDocumentRootContainer((IResource)project);
                    absPath = docRoot.getFullPath().append((IPath)p);
                }
            } else {
                return absPath;
            }
        }
        return absPath;
    }

    private IProject getProjectWithContextRoot(String contextRoot) {
        IProject[] project = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < project.length) {
            String actualDocRoot = ComponentUtilities.getServerContextRoot((IProject)project[i]);
            if (contextRoot.equals(actualDocRoot)) {
                return project[i];
            }
            ++i;
        }
        return null;
    }

    protected final IPath getWorkspacePathForServerContextLink(ILink link, URIUtil.ParsedURI uri) {
        IPath absPath = null;
        Path uriPath = new Path(uri.path);
        String docRoot = uriPath.segment(0);
        String actualDocRoot = ComponentUtilities.getServerContextRoot((IProject)link.getContainer().getResource().getProject());
        if (actualDocRoot == null) {
            if (uriPath.toString().startsWith("/")) {
                return uriPath;
            }
            return null;
        }
        if (actualDocRoot.startsWith("/")) {
            actualDocRoot = actualDocRoot.substring(1);
        }
        if (actualDocRoot.length() == 0 || actualDocRoot.equals(docRoot)) {
            IPath path;
            IContainer docRootFolder = WebUtil.getDocumentRootContainer(link.getContainer().getResource());
            if (docRootFolder == null) {
                return null;
            }
            absPath = actualDocRoot.length() == 0 ? (path = docRootFolder.getFullPath().append((IPath)uriPath)) : (path = docRootFolder.getFullPath().append(uriPath.removeFirstSegments(1)));
        } else {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                String contextRoot = ComponentUtilities.getServerContextRoot((IProject)project);
                if (contextRoot != null && docRoot != null) {
                    if (contextRoot.startsWith("/")) {
                        contextRoot = contextRoot.substring(1);
                    }
                    if (docRoot.equals(contextRoot)) {
                        IPath path;
                        IContainer crossProjectFolder = WebUtil.getDocumentRootContainer(WebUtil.findComponent((IResource)project));
                        absPath = path = crossProjectFolder.getFullPath().append(uriPath.removeFirstSegments(1));
                    }
                }
                ++n2;
            }
        }
        return absPath;
    }

    protected IPath convertFileURLToWorkspacePath(String fileUrlPath, IProject project) {
        String path = fileUrlPath;
        if (path.startsWith("file:///")) {
            path = path.substring("file:///".length());
        } else if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        }
        Path p = new Path(path);
        IPath fullPathOfPath = this.getFullPathOfPath((IPath)p, project);
        return fullPathOfPath;
    }

    protected IPath getFullPathOfPath(IPath fullLocalIPath, IProject project) {
        if (project == null) {
            return null;
        }
        IPath projLoc = project.getLocation();
        if (projLoc != null && projLoc.isPrefixOf(fullLocalIPath)) {
            int seg = projLoc.segmentCount();
            return project.getFullPath().append(fullLocalIPath.removeFirstSegments(seg));
        }
        return null;
    }
}

