/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.internal.refactoring;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.internal.nls.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;

public class ContextRootRenameParticipant
extends RenameParticipant {
    private IProject project;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.project != null) {
            String contextRoot = ComponentUtilities.getServerContextRoot((IProject)this.project);
            if (this.project.getName().equals(contextRoot)) {
                RefactoringSupport support = new RefactoringSupport();
                SearchPattern allLinks = SearchPattern.createWildcardPattern();
                SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{this.project});
                DefaultSearchRequestor req = new DefaultSearchRequestor();
                new SearchEngine().search(allLinks, scope, (SearchRequestor)req, null);
                HashMap<String, String> desc = new HashMap<String, String>();
                desc.put("param.context.root", this.getArguments().getNewName());
                Set links = req.getMatches();
                for (ILink target : links) {
                    support.createEdits(target, target, desc, Collections.emptySet(), null);
                }
                return support.createMergedChange(Messages.UpdateLinksThatReferenceContextRoot, (RefactoringParticipant)this, null);
            }
        }
        return null;
    }

    public String getName() {
        return Messages.UpdateLinksWithContextRoot;
    }

    protected boolean initialize(Object element) {
        if (element instanceof IProject) {
            this.project = (IProject)element;
            return true;
        }
        return false;
    }
}

