/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.internal.providers.transformers;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.services.providers.ILinkTransformerProvider;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.Set;

public class ImplicitClassTransformer
implements ILinkTransformerProvider {
    public String contract(ILink link, String prevResult, Set<ProviderArguments> providerArguments) {
        String noQuotes;
        if (link != null && prevResult != null && !(noQuotes = AbstractWebProvider.trimQuotes(link.getLinkText())).endsWith(".class") && prevResult.endsWith(".class")) {
            prevResult = prevResult.substring(0, prevResult.length() - ".class".length());
            return prevResult;
        }
        return null;
    }

    public String expand(ILink link, String prevResult, Set<ProviderArguments> providerArguments) {
        if (prevResult == null) {
            return null;
        }
        String transformedResult = AbstractWebProvider.trimQuotes(prevResult);
        if (!transformedResult.endsWith(".class")) {
            transformedResult = String.valueOf(transformedResult) + ".class";
        }
        return transformedResult;
    }
}

