/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.internal;

import com.ibm.etools.references.management.ReferenceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class FacetChangeListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.POST_INSTALL || event.getType() == IFacetedProjectEvent.Type.POST_UNINSTALL || event.getType() == IFacetedProjectEvent.Type.POST_VERSION_CHANGE) {
            IProjectFacetActionEvent e = (IProjectFacetActionEvent)event;
            HashMap<String, String> arguments = new HashMap<String, String>();
            ArrayList<String> facetList = new ArrayList<String>();
            facetList.add(e.getProjectFacet().getId());
            arguments.put("facet.id", this.convertListToString(facetList));
            HashSet<IProject> affectedResources = new HashSet<IProject>();
            affectedResources.add(event.getProject().getProject());
            ReferenceManager.getReferenceManager().requestTriggeredEnablement(affectedResources, "web.trigger.FacetChanges", arguments, null);
        }
    }

    private String convertListToString(List<String> facetList) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < facetList.size()) {
            String id = facetList.get(i);
            buf.append(id);
            if (i < facetList.size() - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }
}

