/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebUtil {
    public static IContainer getContainer(IPath path) {
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        switch (path.segmentCount()) {
            case 0: {
                return root;
            }
            case 1: {
                return root.getProject(path.segment(0));
            }
        }
        return root.getFolder(path);
    }

    public static IVirtualComponent findComponent(IResource resource) {
        return resource == null ? null : ComponentCore.createComponent((IProject)resource.getProject());
    }

    public static IPath getWorkspaceRelativeDocRootPath(IVirtualComponent component) {
        IVirtualFolder folder;
        if (component != null && (folder = component.getRootFolder()) != null) {
            return folder.getWorkspaceRelativePath();
        }
        return null;
    }

    public static IPath getProjectRelativeDocRootPath(IVirtualComponent component) {
        IVirtualFolder folder;
        if (component != null && (folder = component.getRootFolder()) != null) {
            return folder.getProjectRelativePath();
        }
        return null;
    }

    public static IContainer getDocumentRootContainer(IVirtualComponent component) {
        return WebUtil.getContainer(WebUtil.getWorkspaceRelativeDocRootPath(component));
    }

    public static IContainer getDocumentRootContainer(IResource file) {
        return file == null ? null : WebUtil.getDocumentRootContainer(WebUtil.findComponent(file));
    }

    public static IPath getDocumentRootRelativePath(IFile file) {
        IContainer container = WebUtil.getDocumentRootContainer((IResource)file);
        if (container == null) {
            return null;
        }
        IPath filePath = file.getFullPath();
        int matchSegs = filePath.matchingFirstSegments(container.getFullPath());
        filePath = filePath.removeFirstSegments(matchSegs).makeAbsolute();
        return filePath;
    }
}

