/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.ui.internal.quickfix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class ProjectFacetUtil {
    public static IProjectFacetVersion getInstalledFacetVersion(IProject project, String facetId) {
        IFacetedProject facetedProject = ProjectFacetUtil.getFacetedProject(project);
        if (facetedProject != null) {
            return ProjectFacetUtil.getInstalledFacetVersion(facetedProject, facetId);
        }
        return null;
    }

    public static IProjectFacetVersion getFacetVersion(IProjectFacet projectFacet, String version) {
        try {
            return projectFacet.getVersion(version);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Set<IProjectFacetVersion> getFacetVersions(IProjectFacet projectFacet, String version) {
        try {
            return projectFacet.getVersions(version);
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    public static IProjectFacetVersion getInstalledFacetVersion(IFacetedProject facetedProject, String facetId) {
        IProjectFacet projectFacet = ProjectFacetUtil.getProjectFacet(facetId);
        if (projectFacet != null) {
            return facetedProject.getInstalledVersion(projectFacet);
        }
        return null;
    }

    public static IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IProjectFacet getProjectFacet(String facetId) {
        try {
            return ProjectFacetsManager.getProjectFacet((String)facetId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static List<IProject> getAllProjectsWithFacet(String facetId) {
        IProjectFacet facet;
        IProject[] allProjects = ProjectFacetUtil.getAllProjects();
        if (allProjects.length > 0 && (facet = ProjectFacetUtil.getProjectFacet(facetId)) != null) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            int i = 0;
            while (i < allProjects.length) {
                IFacetedProject facetedProject;
                IProject project = allProjects[i];
                if (project.isAccessible() && (facetedProject = ProjectFacetUtil.getFacetedProject(project)) != null && facetedProject.hasProjectFacet(facet)) {
                    projects.add(project);
                }
                ++i;
            }
            if (!projects.isEmpty()) {
                return projects;
            }
        }
        return Collections.emptyList();
    }

    private static IProject[] getAllProjects() {
        IWorkspaceRoot workspaceRoot;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null && (workspaceRoot = workspace.getRoot()) != null) {
            return workspaceRoot.getProjects();
        }
        return new IProject[0];
    }
}

