/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.servletProvider;

import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.struts.servletProvider.IStrutsServletProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class StrutsServletProvider
implements IStrutsServletProvider {
    private static final String[] VALID_STRUTS_SERVLET_TYPES = new String[]{"org.apache.struts.action.ActionServlet"};

    @Override
    public ILink getStrutsServletLink(SearchScope scope, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SearchPattern pattern = SearchPattern.createPattern((String)"javaee.webxml.servlet", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, StrutsServletProvider.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        Set matches = requestor.getMatches();
        mon.setWorkRemaining(1);
        for (ILink match : matches) {
            String type = AbstractWebProvider.trimQuotes((String)match.getLinkText());
            String[] stringArray = VALID_STRUTS_SERVLET_TYPES;
            int n = VALID_STRUTS_SERVLET_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (t.equals(type)) {
                    mon.done();
                    return match;
                }
                ++n2;
            }
        }
        return null;
    }

    private static IProgressMonitor monitorFor(IProgressMonitor rootMonitor, IProgressMonitor subMonitor) {
        if (rootMonitor == null || rootMonitor instanceof NullProgressMonitor) {
            return rootMonitor;
        }
        return subMonitor;
    }

    @Override
    public Collection<String> getStrutsURLPattern(SearchScope scope, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        mon.setWorkRemaining(1);
        HashSet<String> urlPatterns = new HashSet<String>();
        ILink strutsServlet = this.getStrutsServletLink(scope, monitor);
        if (strutsServlet != null) {
            Collection incoming = strutsServlet.resolveIncomingReference("javaee.webxml.servlet.name.reference", StrutsServletProvider.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
            for (IResolvedReference resolvedReference : incoming) {
                ILink link = resolvedReference.getSource();
                if (!"javaee.webxml.smapping".equals(link.getSpecializedType().getId())) continue;
                urlPatterns.add(link.getName());
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        return urlPatterns;
    }

    @Override
    public boolean isValid(IProject project) {
        try {
            Set facets = ProjectFacetUtil.getFacetedProject((IProject)project).getProjectFacets();
            boolean hasStrutsFacet = false;
            boolean hasPortletfacet = false;
            for (IProjectFacetVersion facet : facets) {
                String facetId = facet.getProjectFacet().getId();
                if (facetId.equals("web.struts")) {
                    hasStrutsFacet = true;
                    continue;
                }
                if (!facetId.equals("jsr.struts") && !facetId.equals("jsr.portal")) continue;
                hasPortletfacet = true;
            }
            return hasStrutsFacet && !hasPortletfacet;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }
}

