/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.resolvers;

import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.CheckedReferenceRename;
import com.ibm.etools.references.services.providers.IReferenceResolverProvider;
import com.ibm.etools.references.services.providers.RefactoringResolverParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.providers.resolver.WebLinkResolverProvider;
import com.ibm.etools.references.web.struts.internal.StrutsRefConstants;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.references.web.struts.internal.nls.ErrorMessages;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class StrutsConfigFileResolver
extends WebLinkResolverProvider
implements IReferenceResolverProvider {
    public static Reference createStrutsActionReference(ILink link, String referenceType, String result) {
        if (TextRange.EMPTY.equals((Object)link.getLinkLocation())) {
            return null;
        }
        Reference ref = new Reference(link, referenceType);
        URIUtil.ParsedURI uri = URIUtil.parse((String)result);
        if (uri.scheme != null && uri.scheme.length() > 0) {
            return null;
        }
        ref.addParameter("actionName.id", uri.path);
        ref.setFragmentLocation(StrutsConfigFileResolver.createTrimmedRange((ILink)link));
        return ref;
    }

    public static Reference createStrutsExceptionReference(ILink link, String referenceType, String result) {
        if (TextRange.EMPTY.equals((Object)link.getLinkLocation())) {
            return null;
        }
        Reference ref = new Reference(link, referenceType);
        ref.addParameter("strutsexception.id", result);
        ref.setFragmentLocation(StrutsConfigFileResolver.createTrimmedRange((ILink)link));
        return ref;
    }

    public static Reference createStrutsFormbeanReference(ILink link, String referenceType, String result) {
        if (TextRange.EMPTY.equals((Object)link.getLinkLocation())) {
            return null;
        }
        Reference ref = new Reference(link, referenceType);
        ref.addParameter("strutsformbean.id", result);
        ref.setFragmentLocation(StrutsConfigFileResolver.createTrimmedRange((ILink)link));
        return ref;
    }

    public static Reference createStrutsForwardReference(ILink link, String referenceType, String result) {
        if (TextRange.EMPTY.equals((Object)link.getLinkLocation())) {
            return null;
        }
        Reference ref = new Reference(link, referenceType);
        ref.addParameter("strutsforward.id", result);
        ref.setFragmentLocation(StrutsConfigFileResolver.createTrimmedRange((ILink)link));
        return ref;
    }

    private boolean canHaveWildcards(IProject project) {
        return StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)project);
    }

    public CheckedReferenceRename checkRenameReference(RefactoringResolverParameters params) {
        CheckedReferenceRename rename = new CheckedReferenceRename(this.renameReference(params));
        IStatus status = Status.OK_STATUS;
        if (params.resolvedReference == null || params.resolvedReference.getTarget() == null) {
            status = new Status(4, "com.ibm.etools.references.web.struts", ErrorMessages.StrutsConfigFileResolver_0);
        } else {
            ActionMappingWildcardUtil util;
            ILink target = params.resolvedReference.getTarget();
            if (target.getName() != null && (util = new ActionMappingWildcardUtil(target.getContainer().getResource().getProject(), target.getName())).actionHasWildcards()) {
                status = new Status(4, "com.ibm.etools.references.web.struts", ErrorMessages.refactoring_can_not_update_wildcard);
            }
        }
        rename.setRenameValidationStatus(status);
        return rename;
    }

    public String createLink(Reference reference, LinkNode<IFile> linkNode) {
        return null;
    }

    private ILink findMatch(boolean canHaveWildcards, Set<ILink> actionMappings, String actionString) {
        if (actionMappings.isEmpty() || actionString == null) {
            return null;
        }
        if (canHaveWildcards) {
            ArrayList<ILink> sortedByPosition = new ArrayList<ILink>(actionMappings);
            Collections.sort(sortedByPosition, new Comparator<ILink>(){

                @Override
                public int compare(ILink link1, ILink link2) {
                    return link2.getLinkLocation().getOffset() - link1.getLinkLocation().getOffset();
                }
            });
            ArrayList<ILink> concreteLinks = new ArrayList<ILink>();
            ArrayList<ILink> wildCardLinks = new ArrayList<ILink>();
            for (ILink link : sortedByPosition) {
                if (link.getName() == null) continue;
                ActionMappingWildcardUtil wc = new ActionMappingWildcardUtil(link.getContainer().getResource().getProject(), link.getName());
                if (wc.actionHasWildcards()) {
                    wildCardLinks.add(link);
                    continue;
                }
                concreteLinks.add(link);
            }
            for (ILink link : concreteLinks) {
                if (!actionString.equals(link.getName())) continue;
                return link;
            }
            for (ILink link : wildCardLinks) {
                StringMatcher matcher;
                if (link.getName() == null || !(matcher = new StringMatcher(link.getName())).match(actionString)) continue;
                return link;
            }
        } else {
            for (ILink link : actionMappings) {
                if (!actionString.equals(link.getName())) continue;
                return link;
            }
        }
        return null;
    }

    public String getModelInstanceIdReference(Reference reference) {
        return "struts.config.file";
    }

    private Set<ILink> getStrutsActionMappings(SearchScope scope) throws ReferenceException {
        SearchPattern pattern = SearchPattern.createPattern((String)"struts.action.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        NullProgressMonitor m = new NullProgressMonitor();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, (IProgressMonitor)m);
        Set matches = requestor.getMatches();
        return matches;
    }

    public Map<String, Object> renameReference(RefactoringResolverParameters params) {
        return params.targetDescription;
    }

    private String parseActionFromPath(IProject project, String targetModule, String targetPath) {
        String projectName;
        String pathToParse = targetPath;
        String moduleParseFromPath = StrutsSearchUtil.parseModuleFromPath(project, targetPath);
        if (pathToParse == null) {
            return pathToParse;
        }
        if (!pathToParse.startsWith("/")) {
            pathToParse = "/" + pathToParse;
        }
        if (pathToParse.startsWith(projectName = "/" + project.getName())) {
            pathToParse = pathToParse.substring(projectName.length());
        }
        if (moduleParseFromPath != null && moduleParseFromPath.equals(targetModule)) {
            pathToParse = pathToParse.substring(targetModule.length());
        }
        return pathToParse;
    }

    private IResolvedReference resolveActionReference(ReferenceElementFactory factory, Reference reference) {
        boolean moduleAttributeSet;
        ILink sourceLink = reference.getSource();
        IProject project = sourceLink.getContainer().getResource().getProject();
        String targetModule = StrutsSearchUtil.getModuleForLinkTarget(reference.getSource(), null);
        String actionString = reference.getParameter("actionName.id");
        if (actionString == null) {
            return factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "struts.config.file", false);
        }
        boolean bl = moduleAttributeSet = sourceLink.getParameter("param.struts.module") != null;
        if (!moduleAttributeSet) {
            actionString = this.parseActionFromPath(project, targetModule, actionString);
        }
        String typeID = sourceLink.getSpecializedType().getId();
        String attributeParam = sourceLink.getParameter("attributeParam");
        boolean sourceMustBePatterned = !typeID.equals("struts.jsp.form.link") && !typeID.equals("struts.jsp.action.link") && (!typeID.equals("struts.jsp.htmlink.link") || !"action".equals(attributeParam)) && !typeID.equals("struts.actionextends.link") && !typeID.equals("wdeStrutsAction");
        String dePatterned = StrutsSearchUtil.depatternActionString(project, actionString, null);
        if (sourceMustBePatterned && (dePatterned == null || dePatterned.equals(actionString))) {
            return factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "struts.config.file", false);
        }
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, targetModule, null);
        Set<ILink> actionMappings = this.getStrutsActionMappings(scope);
        boolean canHaveWildcards = this.canHaveWildcards(project);
        ILink actionTarget = this.findMatch(canHaveWildcards, actionMappings, dePatterned);
        if (actionTarget != null) {
            return factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, actionTarget, null, false);
        }
        return factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "struts.config.file", false);
    }

    private IResolvedReference resolveExceptionReference(ReferenceElementFactory factory, Reference reference) {
        IResolvedReference result = null;
        IProject project = reference.getSource().getContainer().getResource().getProject();
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{project});
        String actionScope = reference.getSource().getParameter("actionName.id");
        if (actionScope == null) {
            actionScope = "global";
        }
        String pathString = reference.getParameter("strutsexception.id");
        SearchPattern pattern = SearchPattern.createPattern((String)"struts.exception.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        NullProgressMonitor m = new NullProgressMonitor();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, (IProgressMonitor)m);
        Set matches = requestor.getMatches();
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            ILink link = (ILink)iterator.next();
            if (!pathString.equals(AbstractWebProvider.trimQuotes((String)link.getLinkText()))) {
                iterator.remove();
                continue;
            }
            if (actionScope.equals(link.getParameter("struts.paramScope"))) continue;
            iterator.remove();
        }
        if (matches.size() == 1) {
            ILink resolved = (ILink)matches.iterator().next();
            result = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, resolved, null);
        } else {
            result = factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "struts.config.file");
        }
        return result;
    }

    private IResolvedReference resolveFormbeanReference(ReferenceElementFactory factory, Reference reference) {
        IResolvedReference result = null;
        IProject project = reference.getSource().getContainer().getResource().getProject();
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{project});
        String beanName = reference.getParameter("strutsformbean.id");
        SearchPattern pattern = SearchPattern.createPattern((String)"struts.formbean.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        pattern = SearchPattern.createAndPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((String)beanName, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
        NullProgressMonitor m = new NullProgressMonitor();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        String targetModule = StrutsSearchUtil.getModuleForILink(reference.getSource(), null);
        scope = StrutsSearchUtil.getModuleScope(project, targetModule, null);
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, (IProgressMonitor)m);
        Set matches = requestor.getMatches();
        if (matches.size() == 1) {
            ILink resolved = (ILink)matches.iterator().next();
            result = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, resolved, null, false);
        } else {
            result = factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "struts.config.file", false);
        }
        return result;
    }

    private IResolvedReference resolveForwardReference(ReferenceElementFactory factory, Reference reference) {
        IResolvedReference result = null;
        IProject project = reference.getSource().getContainer().getResource().getProject();
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{project});
        String actionScope = reference.getSource().getParameter("actionName.id");
        if (actionScope == null) {
            actionScope = "global";
        }
        String pathString = reference.getParameter("strutsforward.id");
        SearchPattern pattern = SearchPattern.createPattern((String)pathString, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        pattern = SearchPattern.createAndPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((String)"struts.forward.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
        NullProgressMonitor m = new NullProgressMonitor();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        String targetModule = StrutsSearchUtil.getModuleForILink(reference.getSource(), null);
        scope = StrutsSearchUtil.getModuleScope(project, targetModule, null);
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, (IProgressMonitor)m);
        Set matches = requestor.getMatches();
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            ILink link = (ILink)iterator.next();
            if (actionScope.equals(link.getParameter("struts.paramScope"))) continue;
            iterator.remove();
        }
        if (matches.size() == 1) {
            ILink resolved = (ILink)matches.iterator().next();
            result = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, resolved, null, false);
        } else {
            result = factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "struts.config.file", false);
        }
        return result;
    }

    public IResolvedReference resolveReference(ReferenceElementFactory factory, Reference reference, IResolvedReference previousResult) throws ReferenceException {
        IResolvedReference result = null;
        if ("struts.configfile.ref".equals(reference.getReferenceType())) {
            result = super.resolveReference(factory, reference, previousResult);
        } else if ("struts.action.ref".equals(reference.getReferenceType())) {
            result = this.resolveActionReference(factory, reference);
        } else if (reference.getReferenceType().equals("struts.forward.ref")) {
            result = this.resolveForwardReference(factory, reference);
        } else if (reference.getReferenceType().equals(StrutsRefConstants.REFTYPE_STRUTS_EXCEPTION_REF)) {
            result = this.resolveExceptionReference(factory, reference);
        } else if (reference.getReferenceType().equals("struts.formbean.ref")) {
            result = this.resolveFormbeanReference(factory, reference);
        }
        return result;
    }
}

