/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.javaee.providers.resolvers.JDTReferenceResolver;
import com.ibm.etools.references.web.providers.generators.WebLinkFullWebAppRelativeGeneratorProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.references.web.struts.internal.providers.resolvers.StrutsConfigFileResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StrutsReferenceGenerator
extends WebLinkFullWebAppRelativeGeneratorProvider
implements IReferenceGeneratorProvider {
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        if (link == null || referenceType == null) {
            return Collections.emptyList();
        }
        if ("struts.action.ref".equals(referenceType)) {
            String result = AbstractWebProvider.trimQuotes((String)transformResult);
            Reference ref = StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, result);
            if (ref != null) {
                return Collections.singletonList(ref);
            }
            return Collections.emptyList();
        }
        if ("struts.forward.ref".equals(referenceType)) {
            boolean doit = false;
            if ("struts.jsp.htmlink.link".equals(link.getSpecializedType().getId())) {
                if ("forward".equals(link.getParameter("attributeParam"))) {
                    doit = true;
                }
            } else {
                doit = true;
            }
            if (doit) {
                String result = AbstractWebProvider.trimQuotes((String)transformResult);
                Reference ref = StrutsConfigFileResolver.createStrutsForwardReference(link, referenceType, result);
                if (ref != null) {
                    return Collections.singletonList(ref);
                }
                return Collections.emptyList();
            }
            return Collections.emptyList();
        }
        if ("struts.formbean.ref".equals(referenceType)) {
            String result = AbstractWebProvider.trimQuotes((String)transformResult);
            Reference ref = StrutsConfigFileResolver.createStrutsFormbeanReference(link, referenceType, result);
            if (ref != null) {
                return Collections.singletonList(ref);
            }
            return Collections.emptyList();
        }
        if ("javaee.propertiesresource".equals(referenceType)) {
            String result = AbstractWebProvider.trimQuotes((String)transformResult);
            Reference ref = JDTReferenceResolver.createPropertiesResourceReference((ILink)link, (String)result);
            if (ref != null) {
                return Collections.singletonList(ref);
            }
            return Collections.emptyList();
        }
        if ("struts.configfile.ref".equals(referenceType)) {
            IProject project = link.getContainer().getResource().getProject();
            ILink strutsServletLink = StrutsSearchUtil.getStrutsServlet(project, SearchEngine.createSearchScope((IResource[])new IResource[]{project}), null);
            if (strutsServletLink != null) {
                TextRange strutsServletRange = strutsServletLink.getContextLocation();
                TextRange linkRange = link.getLinkLocation();
                if (link.getName() != null && link.getName().startsWith("config") && strutsServletRange.contains(linkRange)) {
                    String original;
                    String noQuotes = AbstractWebProvider.trimQuotes((String)transformResult);
                    ArrayList<Reference> references = new ArrayList<Reference>(1);
                    String originalTrimmed = original = link.getLinkText();
                    if (original != null) {
                        originalTrimmed = original.trim();
                        originalTrimmed = AbstractWebProvider.trimQuotes((String)original);
                        int startOffset = original.indexOf(originalTrimmed);
                        StringTokenizer toker = new StringTokenizer(noQuotes, ",");
                        int index = 0;
                        int endIndex = 0;
                        while (toker.hasMoreElements()) {
                            endIndex = originalTrimmed.indexOf(",", index);
                            if (endIndex == -1) {
                                endIndex = originalTrimmed.length();
                            }
                            int length = endIndex - index;
                            String resourceLink = (String)toker.nextElement();
                            resourceLink = resourceLink.trim();
                            int mb_offset = startOffset + index;
                            int mb_length = length;
                            Reference reference = this.createReference(link, resourceLink, referenceType);
                            if (reference == null) {
                                return Collections.emptyList();
                            }
                            reference.addParameter("strutsconfigtarget", Boolean.TRUE.toString());
                            TextRange range = new TextRange(mb_offset, mb_length, link.getLinkLocation().getLinenumber());
                            reference.setFragmentLocation(range);
                            references.add(reference);
                            index = endIndex + 1;
                        }
                        return references;
                    }
                }
            }
        } else if ("web.reference.workspacePath".equals(referenceType) && link.getName() != null && (link.getName().endsWith("link") || link.getName().endsWith("frame") || link.getName().endsWith("image") || link.getName().endsWith("img") || link.getName().endsWith("rewrite") || link.getName().endsWith("redirect") || link.getName().endsWith("include"))) {
            Reference ref = this.createReference(link, transformResult, referenceType);
            if (ref != null) {
                return Collections.singletonList(ref);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if ("javaee.propertiesresource".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("propertiesFile.id");
        }
        if ("struts.action.ref".equals(params.reference.getReferenceType())) {
            String s = (String)params.renameParameters.get("actionName.id");
            if (s == null) {
                return StrutsReferenceGenerator.trimQuotes((String)params.transformResult);
            }
            s = StrutsSearchUtil.patternActionString(params.reference.getSource().getContainer().getResource().getProject(), s, null);
            return s;
        }
        if ("struts.forward.ref".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("strutsforward.id");
        }
        if ("struts.configfile.ref".equals(params.reference.getReferenceType())) {
            return params.transformResult;
        }
        return super.renameReference(new RefactoringGeneratorParameters(params.newReferenceTargetContainer, params.reference, params.transformResult, params.renameParameters, params.renameArguments));
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        if ("javaee.propertiesresource".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        if ("struts.action.ref".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        if ("struts.forward.ref".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        if ("struts.configfile.ref".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        return super.checkRenameReference(new RefactoringGeneratorParameters(params.newReferenceTargetContainer, params.reference, params.transformResult, params.renameParameters, params.renameArguments));
    }
}

