/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.generators;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.providers.generators.WebLinkGeneratorProvider;
import com.ibm.etools.references.web.struts.internal.providers.resolvers.StrutsConfigFileResolver;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class OrdinaryHtmlToStrutsReferenceGenerator
extends WebLinkGeneratorProvider
implements IReferenceGeneratorProvider {
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        String trimmed = AbstractWebProvider.trimQuotes((String)transformResult);
        Reference ref = null;
        if (referenceType.equals("struts.action.ref")) {
            ref = "struts.jsp.htmlink.link".equals(link.getSpecializedType().getId()) ? ("page".equals(link.getParameter("attributeParam")) ? StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, trimmed) : this.createReference(link, trimmed, referenceType)) : ("struts.jsp.page.link".equals(link.getSpecializedType().getId()) || "struts.jsp.href.link".equals(link.getSpecializedType().getId()) ? StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, trimmed) : this.createReference(link, trimmed, referenceType));
        }
        if (ref == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ref);
    }

    protected Reference createReference(ILink link, String rawLink, String referenceType) {
        String noQuotes = AbstractWebProvider.trimQuotes((String)rawLink);
        if (AbstractWebProvider.isDynamicLink((String)noQuotes)) {
            return null;
        }
        URIUtil.ParsedURI uri = URIUtil.parse((String)noQuotes);
        if (uri.scheme != null && !uri.scheme.equals("file")) {
            return null;
        }
        IPath absPath = this.getAbsolutePathFromLink(uri, link);
        Reference reference = null;
        if (absPath == null) {
            reference = new Reference(link, referenceType);
            reference.setFragmentLocation(new TextRange(0, link.getLinkLocation().getLength(), link.getLinkLocation().getLinenumber()));
            reference.setBrokenStatus(BrokenStatus.BROKEN);
        } else {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(absPath.segment(0));
            IContainer container = WebUtil.getDocumentRootContainer((IResource)project);
            if (container == null) {
                return null;
            }
            int matchingFirstSegs = absPath.matchingFirstSegments(container.getFullPath());
            if (matchingFirstSegs == 0) {
                return null;
            }
            absPath = absPath.removeFirstSegments(matchingFirstSegs).makeAbsolute();
            reference = StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, absPath.toPortableString());
        }
        return reference;
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        if ("struts.action.ref".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        return super.checkRenameReference(params);
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if ("struts.action.ref".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("actionName.id");
        }
        return super.renameReference(new RefactoringGeneratorParameters(params.newReferenceTargetContainer, params.reference, params.transformResult, params.renameParameters, params.renameArguments));
    }
}

