/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.detectors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.javaee.taglib.HTMLTaglibDirectiveUtil;
import com.ibm.etools.references.web.javaee.taglib.TaglibDirective;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class StrutsWebPageLinkDetector
implements ILinkDetectorProvider {
    private static final String ATTRIBUTE_FORWARD = "forward";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_PAGE = "page";
    private static final String ATTRIBUTE_LINKNAME = "linkName";
    private static final String ATTRIBUTE_MODULE = "module";

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        String htmlPrefix = "html:";
        String beanPrefix = "bean:";
        String logicPrefix = "logic:";
        String nestedPrefix = "nested:";
        String strutsFacesPrefix = "s";
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            List taglibDirectivesEx = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
            for (TaglibDirective taglibDirective : taglibDirectivesEx) {
                if ("http://jakarta.apache.org/struts/tags-html".equals(taglibDirective.getURI()) || "http://struts.apache.org/tags-html".equals(taglibDirective.getURI()) || "/WEB-INF/tags-html.tld".equals(taglibDirective.getURI())) {
                    htmlPrefix = String.valueOf(taglibDirective.getPrefix()) + ':';
                }
                if ("http://jakarta.apache.org/struts/tags-bean".equals(taglibDirective.getURI()) || "http://struts.apache.org/tags-bean".equals(taglibDirective.getURI()) || "/WEB-INF/tags-bean.tld".equals(taglibDirective.getURI())) {
                    beanPrefix = String.valueOf(taglibDirective.getPrefix()) + ':';
                }
                if ("http://jakarta.apache.org/struts/tags-logic".equals(taglibDirective.getURI()) || "http://struts.apache.org/tags-logic".equals(taglibDirective.getURI()) || "/WEB-INF/tags-logic.tld".equals(taglibDirective.getURI())) {
                    logicPrefix = String.valueOf(taglibDirective.getPrefix()) + ':';
                }
                if ("http://jakarta.apache.org/struts/tags-nested".equals(taglibDirective.getURI()) || "http://struts.apache.org/tags-nested".equals(taglibDirective.getURI()) || "/WEB-INF/tags-nested.tld".equals(taglibDirective.getURI())) {
                    nestedPrefix = String.valueOf(taglibDirective.getPrefix()) + ':';
                }
                if (!"http://jakarta.apache.org/struts/tags-template".equals(taglibDirective.getURI())) {
                    "/WEB-INF/tags-template.tld".equals(taglibDirective.getURI());
                }
                if (!"http://struts.apache.org/tags-faces".equals(taglibDirective.getURI())) continue;
                strutsFacesPrefix = String.valueOf(taglibDirective.getPrefix()) + ':';
            }
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                String nodeName = n.getNodeName();
                if (nodeName != null) {
                    IDOMAttr style;
                    IDOMAttr name;
                    IDOMAttr page;
                    IDOMAttr href;
                    IDOMAttr forward;
                    IDOMAttr action;
                    IDOMAttr src;
                    ILink link;
                    IDOMAttr page2;
                    IDOMAttr page3;
                    IDOMAttr href2;
                    IDOMAttr forward2;
                    IDOMAttr action2;
                    IDOMElement domElement = (IDOMElement)n;
                    if ((String.valueOf(htmlPrefix) + "form").equals(nodeName) || (String.valueOf(nestedPrefix) + "form").equals(nodeName) || (String.valueOf(strutsFacesPrefix) + "form").equals(nodeName)) {
                        action2 = (IDOMAttr)domElement.getAttributeNode("action");
                        ILink actionLink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)action2, "struts.jsp.form.link", null));
                        this.addLikelyModule(factory, sharedModel, actionLink);
                        this.addModuleParam(factory, domElement, actionLink);
                        links.add(actionLink);
                    } else if ((String.valueOf(htmlPrefix) + "link").equals(nodeName) || (String.valueOf(nestedPrefix) + "link").equals(nodeName)) {
                        ILink htmllink;
                        action2 = (IDOMAttr)domElement.getAttributeNode("action");
                        forward2 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_FORWARD);
                        href2 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_HREF);
                        page3 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE);
                        IDOMAttr linkName = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_LINKNAME);
                        String name2 = null;
                        if (linkName != null) {
                            name2 = linkName.getValue();
                        }
                        IDOMAttr selected = null;
                        selected = action2;
                        if (selected == null) {
                            selected = forward2;
                        }
                        if (selected == null) {
                            selected = href2;
                        }
                        if (selected == null) {
                            selected = page3;
                        }
                        if (selected != null) {
                            htmllink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)selected, "struts.jsp.htmlink.link", name2));
                            this.addLikelyModule(factory, sharedModel, htmllink);
                            this.addModuleParam(factory, domElement, htmllink);
                            factory.addParam(htmllink, "attributeParam", selected.getLocalName().toLowerCase());
                            links.add(htmllink);
                        } else if (linkName != null) {
                            htmllink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, null, "struts.jsp.htmlink.link", name2));
                            factory.addParam(htmllink, "attributeParam", linkName.getLocalName().toLowerCase());
                            links.add(htmllink);
                        }
                        this.handleBundle(factory, links, domElement, name2);
                    } else if ((String.valueOf(htmlPrefix) + "image").equals(nodeName) || (String.valueOf(nestedPrefix) + "image").equals(nodeName)) {
                        page2 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE);
                        if (page2 != null) {
                            link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)page2, "struts.jsp.page.link", null));
                            IProject prj = sharedModel.getLinkNode().getResource().getProject();
                            if (StrutsProjectCoreUtil.getStrutsVersion((IProject)prj) == 3) {
                                this.addModuleParam(factory, domElement, link);
                            }
                            links.add(link);
                        }
                        if ((src = (IDOMAttr)domElement.getAttributeNode("src")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)src, "struts.jsp.src.link", null)));
                        }
                        this.handleBundle(factory, links, domElement, nodeName);
                    } else if ((String.valueOf(htmlPrefix) + "img").equals(nodeName) || (String.valueOf(nestedPrefix) + "img").equals(nodeName)) {
                        IDOMAttr lowSrc;
                        page2 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE);
                        if (page2 != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)page2, "struts.jsp.page.link", null)));
                        }
                        if ((src = (IDOMAttr)domElement.getAttributeNode("src")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)src, "struts.jsp.src.link", null)));
                        }
                        if ((lowSrc = (IDOMAttr)domElement.getAttributeNode("lowsrc")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)lowSrc, "struts.jsp.lowsrc.link", null)));
                        }
                        if ((action = (IDOMAttr)domElement.getAttributeNode("action")) != null) {
                            ILink link2 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)action, "struts.jsp.action.link", null));
                            this.addModuleParam(factory, domElement, link2);
                            links.add(link2);
                        }
                        this.handleBundle(factory, links, domElement, nodeName);
                    } else if ((String.valueOf(htmlPrefix) + "rewrite").equals(nodeName)) {
                        forward = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_FORWARD);
                        if (forward != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)forward, "struts.jsp.forward.link", null)));
                        }
                        if ((href = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_HREF)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)href, "struts.jsp.href.link", null)));
                        }
                        if ((page = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)page, "struts.jsp.page.link", null)));
                        }
                        if ((action = (IDOMAttr)domElement.getAttributeNode("action")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)action, "struts.jsp.action.link", null)));
                        }
                    } else if ((String.valueOf(htmlPrefix) + "frame").equals(nodeName)) {
                        action2 = (IDOMAttr)domElement.getAttributeNode("action");
                        if (action2 != null) {
                            link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)action2, "struts.jsp.action.link", null));
                            this.addModuleParam(factory, domElement, link);
                            links.add(link);
                        }
                        if ((forward2 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_FORWARD)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)forward2, "struts.jsp.forward.link", null)));
                        }
                        if ((href2 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_HREF)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)href2, "struts.jsp.href.link", null)));
                        }
                        if ((page3 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)page3, "struts.jsp.page.link", null)));
                        }
                        this.handleBundle(factory, links, domElement, nodeName);
                    } else if ((String.valueOf(htmlPrefix) + "button").equals(nodeName) || (String.valueOf(htmlPrefix) + "cancel").equals(nodeName) || (String.valueOf(htmlPrefix) + "checkbox").equals(nodeName) || (String.valueOf(htmlPrefix) + "errors").equals(nodeName) || (String.valueOf(htmlPrefix) + "file").equals(nodeName) || (String.valueOf(htmlPrefix) + "hidden").equals(nodeName) || (String.valueOf(htmlPrefix) + "javascript").equals(nodeName) || (String.valueOf(htmlPrefix) + "messages").equals(nodeName) || (String.valueOf(htmlPrefix) + "multibox").equals(nodeName) || (String.valueOf(htmlPrefix) + "option").equals(nodeName) || (String.valueOf(htmlPrefix) + "password").equals(nodeName) || (String.valueOf(htmlPrefix) + "radio").equals(nodeName) || (String.valueOf(htmlPrefix) + "reset").equals(nodeName) || (String.valueOf(htmlPrefix) + "select").equals(nodeName) || (String.valueOf(htmlPrefix) + "submit").equals(nodeName) || (String.valueOf(htmlPrefix) + "text").equals(nodeName) || (String.valueOf(htmlPrefix) + "textarea").equals(nodeName) || (String.valueOf(nestedPrefix) + "checkbox").equals(nodeName) || (String.valueOf(nestedPrefix) + "errors").equals(nodeName) || (String.valueOf(nestedPrefix) + "file").equals(nodeName) || (String.valueOf(nestedPrefix) + "multibox").equals(nodeName) || (String.valueOf(nestedPrefix) + "password").equals(nodeName) || (String.valueOf(nestedPrefix) + "radio").equals(nodeName) || (String.valueOf(nestedPrefix) + "select").equals(nodeName) || (String.valueOf(nestedPrefix) + "submit").equals(nodeName) || (String.valueOf(nestedPrefix) + "text").equals(nodeName) || (String.valueOf(nestedPrefix) + "textarea").equals(nodeName) || (String.valueOf(nestedPrefix) + "write").equals(nodeName) || (String.valueOf(beanPrefix) + "message").equals(nodeName) || (String.valueOf(beanPrefix) + "write").equals(nodeName) || (String.valueOf(strutsFacesPrefix) + "errors").equals(nodeName) || (String.valueOf(strutsFacesPrefix) + "message").equals(nodeName)) {
                        this.handleBundle(factory, links, domElement, nodeName);
                    } else if ((String.valueOf(logicPrefix) + "redirect").equals(nodeName)) {
                        forward = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_FORWARD);
                        if (forward != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)forward, "struts.jsp.forward.link", null)));
                        }
                        if ((href = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_HREF)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)href, "struts.jsp.href.link", null)));
                        }
                        if ((page = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)page, "struts.jsp.page.link", null)));
                        }
                        if ((action = (IDOMAttr)domElement.getAttributeNode("action")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)action, "struts.jsp.action.link", null)));
                        }
                    } else if ((String.valueOf(logicPrefix) + ATTRIBUTE_FORWARD).equals(nodeName)) {
                        name = (IDOMAttr)domElement.getAttributeNode("name");
                        if (name != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)name, "struts.jsp.forward.link", null)));
                        }
                    } else if ((String.valueOf(beanPrefix) + "include").equals(nodeName)) {
                        IDOMAttr name3;
                        forward = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_FORWARD);
                        if (forward != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)forward, "struts.jsp.forward.link", null)));
                        }
                        if ((href = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_HREF)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)href, "struts.jsp.href.link", null)));
                        }
                        if ((page = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE)) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)page, "struts.jsp.page.link", null)));
                        }
                        if ((name3 = (IDOMAttr)domElement.getAttributeNode("name")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)name3, "struts.jsp.name.link", null)));
                        }
                    } else if ((String.valueOf(beanPrefix) + "resource").equals(nodeName)) {
                        name = (IDOMAttr)domElement.getAttributeNode("name");
                        if (name != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)name, "struts.jsp.name.link", null)));
                        }
                    } else if ((String.valueOf(beanPrefix) + "struts").equals(nodeName)) {
                        IDOMAttr formBean;
                        IDOMAttr mapping;
                        forward = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_FORWARD);
                        if (forward != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)forward, "struts.jsp.forward.link", null)));
                        }
                        if ((mapping = (IDOMAttr)domElement.getAttributeNode("mapping")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)mapping, "struts.jsp.action.link", null)));
                        }
                        if ((formBean = (IDOMAttr)domElement.getAttributeNode("formBean")) != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)formBean, "struts.jsp.formbean.link", null)));
                        }
                    } else if ((String.valueOf(strutsFacesPrefix) + "javascript").equals(nodeName)) {
                        page2 = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_PAGE);
                        if (page2 != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)page2, "struts.jsp.page.link", null)));
                        }
                    } else if ((String.valueOf(strutsFacesPrefix) + "stylesheet").equals(nodeName)) {
                        IDOMAttr path = (IDOMAttr)domElement.getAttributeNode("path");
                        if (path != null) {
                            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)path, "struts.jsp.page.link", null)));
                        }
                    } else if ((String.valueOf(strutsFacesPrefix) + "write").equals(nodeName) && (style = (IDOMAttr)domElement.getAttributeNode("style")) != null) {
                        links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)style, "struts.jsp.page.link", null)));
                    }
                }
                n = iter.nextNode();
            }
        }
        return links;
    }

    private void addModuleParam(ReferenceElementFactory factory, IDOMElement domElement, ILink actionLink) {
        IDOMAttr module = (IDOMAttr)domElement.getAttributeNode(ATTRIBUTE_MODULE);
        if (module != null) {
            factory.addParam(actionLink, "param.struts.module", module.getValue());
        }
    }

    private void addLikelyModule(ReferenceElementFactory factory, SharedModel sharedModel, ILink actionLink) {
        IPath likelyModule = WebUtil.getDocumentRootRelativePath((IFile)((IFile)sharedModel.getLinkNode().getResource()));
        likelyModule = likelyModule.removeLastSegments(Math.max(0, likelyModule.segmentCount() - 1)).makeRelative();
        factory.addParam(actionLink, "param.struts.likely.module", likelyModule.toString());
    }

    private void handleBundle(ReferenceElementFactory factory, List<ILink> links, IDOMElement domElement, String nodeName) {
        IDOMAttr bundle = (IDOMAttr)domElement.getAttributeNode("bundle");
        if (bundle != null) {
            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)bundle, "struts.jsp.bundle.link", null)));
        }
    }
}

