/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.detectors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class StrutsConfigFileLinkDetector
implements ILinkDetectorProvider {
    public static final String GLOBAL_SCOPE = "global";

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        String moduleName = null;
        for (IResolvedReference incRef : incomingReferences) {
            ILink source;
            String name;
            if (!Boolean.TRUE.equals(Boolean.parseBoolean(incRef.getReference().getParameter("strutsconfigtarget"))) || (name = (source = incRef.getSource()).getName()) == null || !name.startsWith("config")) continue;
            moduleName = name = name.substring(name.indexOf("config") + "config".length(), name.length());
            break;
        }
        ArrayList<ILink> links = new ArrayList<ILink>();
        ILink scLink = factory.createLink("struts.config.nodeid", null, null, TextRange.EMPTY, null, TextRange.EMPTY, true);
        factory.addParam(scLink, "param.struts.module", moduleName);
        links.add(scLink);
        IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
        IDOMDocument document = model.getDocument();
        TreeWalker iter = ((DocumentTraversal)document).createTreeWalker((Node)document, 1, null, false);
        Node n = iter.nextNode();
        while (n != null) {
            if ("struts-config".equals(n.getNodeName())) {
                n = iter.firstChild();
                continue;
            }
            if ("action-mappings".equals(n.getNodeName())) {
                this.handleActionMapping(factory, links, iter);
            }
            if ("form-beans".equals(n.getNodeName())) {
                this.handleFormBean(factory, links, iter);
            }
            if ("global-forwards".equals(n.getNodeName())) {
                this.handleForward(factory, links, iter, GLOBAL_SCOPE);
            }
            if ("global-exceptions".equals(n.getNodeName())) {
                this.handleException(factory, links, iter, GLOBAL_SCOPE);
            }
            if ("data-sources".equals(n.getNodeName())) {
                this.handleDataSource(factory, links, iter);
            }
            if ("controller".equals(n.getNodeName())) {
                this.handleController(factory, links, iter);
            }
            if ("plug-in".equals(n.getNodeName())) {
                this.handlePlugin(factory, links, iter);
            }
            if ("message-resources".equals(n.getNodeName())) {
                this.handleMessageResource(factory, links, iter);
            }
            n = iter.nextSibling();
        }
        return links;
    }

    private void handleActionMapping(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter) {
        Node n = iter.firstChild();
        boolean foundForward = n != null;
        while (n != null) {
            if ("action".equals(n.getNodeName())) {
                IDOMAttr className;
                ILink link;
                IDOMElement domElement = (IDOMElement)n;
                String name = domElement.getAttribute("path");
                IDOMAttr type = (IDOMAttr)domElement.getAttributeNode("type");
                IDOMAttr forward = (IDOMAttr)domElement.getAttributeNode("forward");
                IDOMAttr include = (IDOMAttr)domElement.getAttributeNode("include");
                IDOMAttr input = (IDOMAttr)domElement.getAttributeNode("input");
                IDOMAttr formBeanName = (IDOMAttr)domElement.getAttributeNode("name");
                IDOMAttr extendsName = (IDOMAttr)domElement.getAttributeNode("extends");
                if (type != null) {
                    link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)type, "struts.action.link", name));
                    factory.addParam(link, "attributeParam", "type");
                    links.add(link);
                } else if (forward != null) {
                    link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)forward, "struts.action.link", name));
                    factory.addParam(link, "attributeParam", "forward");
                    links.add(link);
                } else if (include != null) {
                    link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)include, "struts.action.link", name));
                    factory.addParam(link, "attributeParam", "include");
                    links.add(link);
                } else {
                    link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, null, "struts.action.link", name));
                    factory.addParam(link, "attributeParam", "null");
                    links.add(link);
                }
                if (input != null) {
                    link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)input, "struts.actioninput.link", name));
                    links.add(link);
                }
                if (formBeanName != null) {
                    link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)formBeanName, "struts.actionformbean.link", name));
                    links.add(link);
                }
                if (extendsName != null) {
                    link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)extendsName, "struts.actionextends.link", name));
                    factory.addParam(link, "struts.link.subtype", "extends");
                    links.add(link);
                }
                if ((className = (IDOMAttr)domElement.getAttributeNode("className")) != null) {
                    ILink link3 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)className, "struts.javatype.link", null));
                    links.add(link3);
                }
                this.handleForward(factory, links, iter, name);
                this.handleException(factory, links, iter, name);
            }
            n = iter.nextSibling();
        }
        if (foundForward) {
            iter.parentNode();
        }
    }

    private void handleController(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter) {
        IDOMElement domElement;
        IDOMAttr processorClass;
        Node n = iter.getCurrentNode();
        if ("controller".equals(n.getNodeName()) && (processorClass = (IDOMAttr)(domElement = (IDOMElement)n).getAttributeNode("processorClass")) != null) {
            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)processorClass, "struts.javatype.link", null)));
        }
    }

    private void handleDataSource(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter) {
        Node n = iter.firstChild();
        boolean foundDataSource = n != null;
        while (n != null) {
            if ("data-source".equals(n.getNodeName())) {
                IDOMAttr className;
                IDOMElement domElement = (IDOMElement)n;
                String fName = domElement.getAttribute("key");
                IDOMAttr type = (IDOMAttr)domElement.getAttributeNode("type");
                if (type != null) {
                    links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)type, "struts.javatype.link", fName)));
                }
                if ((className = (IDOMAttr)domElement.getAttributeNode("className")) != null) {
                    links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)className, "struts.javatype.link", null)));
                }
            }
            n = iter.nextSibling();
        }
        if (foundDataSource) {
            iter.parentNode();
        }
    }

    private void handleException(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter, String scope) {
        Node n = iter.firstChild();
        boolean foundException = n != null;
        while (n != null) {
            if ("exception".equals(n.getNodeName())) {
                IDOMAttr className;
                IDOMAttr extendsName;
                IDOMAttr handler;
                IDOMElement domElement = (IDOMElement)n;
                IDOMAttr type = (IDOMAttr)domElement.getAttributeNode("type");
                ILink link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)type, "struts.exception.link", null));
                factory.addParam(link, "struts.paramScope", scope);
                links.add(link);
                IDOMAttr path = (IDOMAttr)domElement.getAttributeNode("path");
                if (path != null) {
                    ILink link2 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)path, "struts.exceptionpath.link", null));
                    links.add(link2);
                    factory.addParam(link2, "struts.paramScope", scope);
                }
                if ((handler = (IDOMAttr)domElement.getAttributeNode("handler")) != null) {
                    ILink link3 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)handler, "struts.exception.link", null));
                    factory.addParam(link3, "struts.paramScope", scope);
                    factory.addParam(link3, "struts.link.subtype", "handler");
                    links.add(link3);
                }
                if ((extendsName = (IDOMAttr)domElement.getAttributeNode("extends")) != null) {
                    ILink link3 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)extendsName, "struts.exception.link", null));
                    factory.addParam(link3, "struts.paramScope", scope);
                    factory.addParam(link3, "struts.link.subtype", "extends");
                    links.add(link3);
                }
                if ((className = (IDOMAttr)domElement.getAttributeNode("className")) != null) {
                    ILink link3 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)className, "struts.exception.link", null));
                    links.add(link3);
                    factory.addParam(link3, "struts.paramScope", scope);
                }
            }
            n = iter.nextSibling();
        }
        if (foundException) {
            iter.parentNode();
        }
    }

    private void handleFormBean(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter) {
        Node n = iter.firstChild();
        boolean foundFormBean = n != null;
        while (n != null) {
            if ("form-bean".equals(n.getNodeName())) {
                IDOMElement domElement = (IDOMElement)n;
                String fName = domElement.getAttribute("name");
                IDOMAttr className = (IDOMAttr)domElement.getAttributeNode("className");
                if (className != null) {
                    links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)className, "struts.javatype.link", fName)));
                }
                IDOMAttr type = (IDOMAttr)domElement.getAttributeNode("type");
                ILink fbLink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)type, "struts.formbean.link", fName));
                links.add(fbLink);
                IDOMAttr extendsName = (IDOMAttr)domElement.getAttributeNode("extends");
                if (extendsName != null) {
                    ILink fbExtendsLink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)extendsName, "struts.actionformbean.link", fName));
                    factory.addParam(fbExtendsLink, "struts.link.subtype", "extends");
                    links.add(fbExtendsLink);
                }
                NodeList children = domElement.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    IDOMElement e;
                    Node node = children.item(i);
                    if (node.getNodeType() == 1 && "form-property".equals((e = (IDOMElement)node).getLocalName())) {
                        IDOMAttr propType = (IDOMAttr)e.getAttributeNode("type");
                        IDOMAttr propNameAttr = (IDOMAttr)e.getAttributeNode("name");
                        String propName = propNameAttr == null ? null : propNameAttr.getValue();
                        ILink propLink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, e, (IDOMNode)propType, "struts.form.property.link", propName));
                        links.add(propLink);
                    }
                    ++i;
                }
            }
            n = iter.nextSibling();
        }
        if (foundFormBean) {
            iter.parentNode();
        }
    }

    private void handleForward(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter, String scope) {
        Node n = iter.firstChild();
        boolean foundForward = n != null;
        while (n != null) {
            if ("forward".equals(n.getNodeName())) {
                IDOMAttr className;
                IDOMElement domElement = (IDOMElement)n;
                String fName = domElement.getAttribute("name");
                IDOMAttr path = (IDOMAttr)domElement.getAttributeNode("path");
                IDOMAttr contextRelative = (IDOMAttr)domElement.getAttributeNode("contextRelative");
                IDOMAttr module = (IDOMAttr)domElement.getAttributeNode("module");
                ILink link = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)path, "struts.forward.link", fName));
                factory.addParam(link, "struts.paramScope", scope);
                if (contextRelative != null) {
                    String contextRelativeValue = contextRelative.getValue();
                    contextRelativeValue = contextRelativeValue.toLowerCase();
                    if ("yes".equals(contextRelativeValue = contextRelativeValue.trim()) || "true".equals(contextRelativeValue)) {
                        factory.addParam(link, "struts.param.contextrelative", "true");
                    } else {
                        factory.addParam(link, "struts.param.contextrelative", "false");
                    }
                }
                if (module != null) {
                    factory.addParam(link, "param.struts.module", module.getValue());
                }
                links.add(link);
                IDOMAttr extendsName = (IDOMAttr)domElement.getAttributeNode("extends");
                if (extendsName != null) {
                    ILink link2 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)extendsName, "struts.forwardextends.link", fName));
                    links.add(link2);
                    factory.addParam(link2, "struts.paramScope", scope);
                    factory.addParam(link2, "struts.link.subtype", "extends");
                }
                if ((className = (IDOMAttr)domElement.getAttributeNode("className")) != null) {
                    ILink link3 = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)className, "struts.javatype.link", null));
                    links.add(link3);
                    factory.addParam(link3, "struts.paramScope", scope);
                }
            }
            n = iter.nextSibling();
        }
        if (foundForward) {
            iter.parentNode();
        }
    }

    private void handleMessageResource(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter) {
        IDOMElement domElement;
        IDOMAttr parameter;
        Node n = iter.getCurrentNode();
        if ("message-resources".equals(n.getNodeName()) && (parameter = (IDOMAttr)(domElement = (IDOMElement)n).getAttributeNode("parameter")) != null) {
            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)parameter, "struts.javaproperties", null)));
        }
    }

    private void handlePlugin(ReferenceElementFactory factory, List<ILink> links, TreeWalker iter) {
        IDOMElement domElement;
        IDOMAttr className;
        Node n = iter.getCurrentNode();
        if ("plug-in".equals(n.getNodeName()) && (className = (IDOMAttr)(domElement = (IDOMElement)n).getAttributeNode("className")) != null) {
            links.add(AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)className, "struts.javatype.link", null)));
        }
    }
}

