/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.taglib;

import com.ibm.etools.references.web.javaee.taglib.NodeDataAccessor;
import com.ibm.etools.references.web.javaee.taglib.TaglibDirective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLTaglibDirectiveUtil {
    private static final String NODENAME_JSPROOT = "jsp:root";
    private static final String NODENAME_TAGLIB = "jsp:directive.taglib";
    private static final String ATTRNAME_PREFIX = "prefix";
    private static final String ATTRNAME_URI = "uri";
    private static final String[] reservedPrefix = new String[]{"jsp", "jspx", "java", "javax", "servlet", "sun", "sunw"};
    private static final String XMLNS = "xmlns:";

    public static NodeList getTaglibDirectives(IDOMModel model) {
        if (model == null) {
            return null;
        }
        NodeList nl = model.getDocument().getElementsByTagName(NODENAME_TAGLIB);
        return nl;
    }

    public static List<TaglibDirective> getTaglibDirectivesEx(IDOMModel model) {
        ArrayList<TaglibDirective> taglibs = new ArrayList<TaglibDirective>(1);
        if (model == null) {
            return Collections.emptyList();
        }
        if (HTMLTaglibDirectiveUtil.isJSPDocuments(model)) {
            List<Node> v = HTMLTaglibDirectiveUtil.getTaglibDirectiveXML(model);
            for (Node node : v) {
                TaglibDirective o = HTMLTaglibDirectiveUtil.getTaglibDirective(node);
                if (o == null) continue;
                taglibs.add(o);
            }
        } else {
            NodeList nl = HTMLTaglibDirectiveUtil.getTaglibDirectives(model);
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                TaglibDirective o = HTMLTaglibDirectiveUtil.getTaglibDirective(node);
                if (o != null) {
                    taglibs.add(o);
                }
                ++i;
            }
        }
        return taglibs;
    }

    public static TaglibDirective getTaglibDirective(Node node) {
        TaglibDirective td = null;
        if (node.getNodeType() == 2) {
            String nodeName = node.getNodeName();
            String prefix = HTMLTaglibDirectiveUtil.getTaglibPrefix(nodeName);
            if (prefix != null) {
                String uri = NodeDataAccessor.getAttribute((Attr)node);
                td = new TaglibDirective(prefix, uri);
            }
        } else if (node.getNodeName().equals(NODENAME_TAGLIB)) {
            String prefix = NodeDataAccessor.getAttribute((Element)node, ATTRNAME_PREFIX);
            String uri = NodeDataAccessor.getAttribute((Element)node, ATTRNAME_URI);
            td = new TaglibDirective(prefix, uri);
        }
        return td;
    }

    public static boolean isJSPDocuments(IDOMModel model) {
        return HTMLTaglibDirectiveUtil.getJSPRootElement(model) != null;
    }

    public static Element getJSPRootElement(IDOMModel model) {
        if (model == null) {
            return null;
        }
        Element element = model.getDocument().getDocumentElement();
        if (element == null) {
            return null;
        }
        return HTMLTaglibDirectiveUtil.isJSPRootElement(element) ? element : null;
    }

    public static List<Node> getTaglibDirectiveXML(IDOMModel model) {
        if (model == null) {
            return null;
        }
        ArrayList<Node> v = new ArrayList<Node>();
        Element e = model.getDocument().getDocumentElement();
        NamedNodeMap map = e.getAttributes();
        if (map != null) {
            int i = 0;
            while (i < map.getLength()) {
                Node attr = map.item(i);
                if (attr != null && attr.getNodeType() == 2 && HTMLTaglibDirectiveUtil.getTaglibPrefix(attr.getNodeName()) != null) {
                    v.add(attr);
                }
                ++i;
            }
        }
        return v;
    }

    public static String getTaglibPrefix(String attrName) {
        String prefix = null;
        if (!attrName.startsWith(XMLNS)) {
            return null;
        }
        prefix = attrName.substring(XMLNS.length());
        int i = 0;
        while (i < reservedPrefix.length) {
            if (prefix.equals(reservedPrefix[i])) {
                return null;
            }
            ++i;
        }
        return prefix;
    }

    private static boolean isJSPRootElement(Node node) {
        return node.getNodeName().equals(NODENAME_JSPROOT);
    }
}

