/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.providers.resolvers;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.web.javaee.internal.JDTLinkUtil;
import com.ibm.etools.references.web.javaee.internal.nls.Messages;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTUtils;
import com.ibm.etools.references.web.javaee.internal.providers.node.JavaNodeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class SearchUtil {
    private static final Object SYNC = new Object();
    public static final String JST_LINKPROVIDER_STRING = "jdt.link.passthrough";
    private static final int JDT_LINKPROVIDER_ID = InternalAPI.getLinkProviderId((String)"jdt.link.passthrough");

    private static ReferenceElementFactory getJDTFactory(LinkNode<IResource> resource) {
        return InternalAPI.getReferenceElementFactory((int)JDT_LINKPROVIDER_ID, (int)InternalAPI.getResolverProviderId((String)"jdtReferenceResolver"), resource);
    }

    public static Collection<ILink> findJDTLink(IJavaProject project, String typeName, IProgressMonitor monitor) {
        return SearchUtil.searchForTypeLink(project, typeName, false, monitor);
    }

    public static Collection<ILink> findJDTMethodLinks(IJavaProject project, String typeName, IProgressMonitor monitor) {
        return SearchUtil.searchForActualLinks(project, typeName, "*", false, monitor);
    }

    public static Collection<ILink> findAnyMethodLinks(IJavaProject project, String typeName, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Collection<ILink> matches = SearchUtil.searchForTypeLink(project, typeName, true, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
        if (matches.isEmpty()) {
            sub.worked(1);
            return Collections.emptyList();
        }
        return SearchUtil.searchForMergedLinks(matches.iterator().next(), project, typeName, "*", false, false, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
    }

    public static Collection<ILink> searchForTypeLink(IJavaProject project, String typeName, boolean localdbonly, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.beginTask("", 1);
        Set matches = Collections.emptySet();
        try {
            SearchPattern pattern = SearchPattern.createPattern((String)typeName, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            pattern = pattern.and(SearchPattern.createPattern((String)"javaee.javatype.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
            IClasspathEntry[] cp = project.getResolvedClasspath(true);
            ArrayList<IPath> paths = new ArrayList<IPath>(cp.length);
            IClasspathEntry[] iClasspathEntryArray = cp;
            int n = cp.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                IPath p = classpathEntry.getPath();
                p = classpathEntry.getEntryKind() == 3 && classpathEntry.getContentKind() == 1 ? p.addTrailingSeparator() : (classpathEntry.getEntryKind() == 1 ? p.append("|").append(String.valueOf(typeName.replace(".", "/")) + ".class") : p.addTrailingSeparator());
                if (p != null) {
                    paths.add(p);
                }
                ++n2;
            }
            SearchScope scope = SearchEngine.createSearchScope(paths);
            DefaultSearchRequestor requestor = new DefaultSearchRequestor();
            if (localdbonly) {
                new SearchEngine(localdbonly).search(pattern, scope, (SearchRequestor)requestor, SearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1, 7)));
            } else {
                new SearchEngine(localdbonly).search(pattern, scope, (SearchRequestor)requestor, SearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
            }
            matches = requestor.getMatches();
        }
        catch (Exception exception) {}
        return SearchUtil.removeQueuedLinks(matches);
    }

    public static ILink searchForExistingTypeLink(String typeName, IPath pathScope, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", 1);
        SearchPattern pattern = SearchPattern.createPattern((String)typeName, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        pattern = pattern.and(SearchPattern.createPattern((String)"javaee.javatype.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
        SearchScope scope = SearchEngine.createSearchScope((IPath[])new IPath[]{pathScope});
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine(true).search(pattern, scope, (SearchRequestor)requestor, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1, 7)));
        Collection<Object> matches = requestor.getMatches();
        matches = SearchUtil.removeQueuedLinks((Collection<ILink>)matches);
        if (matches.size() > 1) {
            throw new RuntimeException(Messages.errorMsg_found_more_than_one_type_link);
        }
        if (matches.size() == 0) {
            return null;
        }
        return (ILink)matches.iterator().next();
    }

    public static ILink searchForActualLink(IJavaProject project, String typeName, String methodName, IProgressMonitor monitor) {
        Collection<ILink> exact = SearchUtil.searchForActualLinks(project, typeName, methodName, true, monitor);
        if (!exact.isEmpty()) {
            return exact.iterator().next();
        }
        return null;
    }

    public static Collection<ILink> getSuperTypeLinks(IJavaProject project, ILink typeLink, IProgressMonitor monitor) {
        LinkedHashSet<ILink> superTypes = new LinkedHashSet<ILink>();
        String typeHandle = typeLink.getParameter("javaee.handle");
        try {
            IType type = (IType)JavaCore.create((String)typeHandle);
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            ITypeHierarchy heir = type.newSupertypeHierarchy(SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
            IType[] types = heir.getAllClasses();
            sub.setWorkRemaining(types.length * 2);
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType superType = iTypeArray[n2];
                if (superType.equals(type)) {
                    sub.worked(2);
                } else {
                    Collection<ILink> links = SearchUtil.searchForTypeLink(project, superType.getFullyQualifiedName(), true, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                    if (links.size() == 1) {
                        superTypes.add(links.iterator().next());
                        sub.worked(1);
                    } else if (links.isEmpty()) {
                        links = SearchUtil.searchForTypeLink(project, superType.getFullyQualifiedName(), false, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                        if (links.size() == 1) {
                            superTypes.add(links.iterator().next());
                        }
                        sub.worked(1);
                    } else {
                        sub.worked(1);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            if (e.getJavaModelStatus() != null && e.getJavaModelStatus().isDoesNotExist()) {
                return superTypes;
            }
            throw new RuntimeException(e);
        }
        return superTypes;
    }

    private static Collection<ILink> searchForMergedLinks(ILink typeLink, IJavaProject project, String typeName, String methodName, boolean exactMatch, boolean localdbonly, IProgressMonitor monitor) {
        if (typeLink == null) {
            return Collections.emptyList();
        }
        if (methodName != null) {
            ArrayList<ILink> allMethods = new ArrayList<ILink>();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            Collection<Object> superTypeLinks = new ArrayList<ILink>();
            try {
                superTypeLinks = SearchUtil.getSuperTypeLinks(project, typeLink, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
            }
            catch (RuntimeException runtimeException) {
                Logger.logException((String)"Could not get supertype links", (Exception)runtimeException);
            }
            superTypeLinks.add(typeLink);
            sub.setWorkRemaining(superTypeLinks.size());
            for (ILink iLink : superTypeLinks) {
                IType loopType = (IType)JavaCore.create((String)iLink.getParameter("javaee.handle"));
                IPath path = SearchUtil.extractPath(loopType);
                allMethods.addAll(SearchUtil.searchForExistingMethodLink(methodName, exactMatch, localdbonly, loopType, path, false, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1))));
            }
            ArrayList<ILink> arrayList = new ArrayList<ILink>();
            for (ILink methodLink : allMethods) {
                IJavaElement jE = JavaCore.create((String)methodLink.getParameter("javaee.handle"));
                if (jE.getElementType() != 9) continue;
                IMethod m1 = (IMethod)jE;
                boolean foundSimilar = false;
                for (ILink alreadyFiltered : arrayList) {
                    IMethod m2 = (IMethod)JavaCore.create((String)alreadyFiltered.getParameter("javaee.handle"));
                    if (!m1.isSimilar(m2)) continue;
                    foundSimilar = true;
                    break;
                }
                if (foundSimilar) continue;
                arrayList.add(methodLink);
            }
            return arrayList;
        }
        return Collections.singleton(typeLink);
    }

    private static Collection<ILink> searchForActualLinks(IJavaProject project, String typeName, String methodName, boolean exactMatch, IProgressMonitor monitor) {
        return SearchUtil.searchForActualLinks(null, project, typeName, methodName, exactMatch, monitor);
    }

    public static Collection<ILink> searchForActualLinks(ILink typeLink, IJavaProject project, String typeName, String methodName, boolean exactMatch, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (typeLink == null) {
            Collection<ILink> matches = SearchUtil.searchForTypeLink(project, typeName, true, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
            if (matches.isEmpty()) {
                sub.worked(1);
                return Collections.emptyList();
            }
            typeLink = matches.iterator().next();
        }
        return SearchUtil.searchForMergedLinks(typeLink, project, typeName, methodName, exactMatch, true, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<ILink> searchForExistingMethodLink(String methodName, boolean exactMatch, boolean localdbonly, IType type, IPath path, boolean includeSuper, IProgressMonitor monitor) {
        Object superType;
        SearchPattern methodPattern = null;
        if (methodName.equals("*")) {
            methodPattern = SearchPattern.createPattern((String)"javaee.jdt.publicmethod", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        } else {
            methodPattern = SearchPattern.createPattern((String)methodName, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            methodPattern = methodPattern.and(SearchPattern.createPattern((String)"javaee.jdt.publicmethod", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0));
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ArrayList<IPath> heirScope = new ArrayList<IPath>();
        try {
            if (includeSuper) {
                IType[] otherTypes;
                ITypeHierarchy heir = type.newSupertypeHierarchy(SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                IType[] iTypeArray = otherTypes = heir.getAllClasses();
                int n = otherTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    superType = iTypeArray[n2];
                    IPath superClass = SearchUtil.extractPath((IType)superType);
                    heirScope.add(superClass);
                    ++n2;
                }
            } else {
                IPath superClass = SearchUtil.extractPath(type);
                heirScope.add(superClass);
            }
        }
        catch (JavaModelException javaModelException) {}
        SearchScope methodScope = SearchEngine.createSearchScope(heirScope);
        DefaultSearchRequestor methodReq = new DefaultSearchRequestor();
        ReferenceManager.getReferenceManager().waitForIndexing(SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)), methodScope);
        superType = SYNC;
        synchronized (superType) {
            boolean methodsAreIndexed = JDTLinkUtil.areTypeMethodsIndexed(type.getHandleIdentifier());
            if (methodsAreIndexed || localdbonly) {
                new SearchEngine(true).search(methodPattern, methodScope, (SearchRequestor)methodReq, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1, 7)));
            } else {
                new SearchEngine(false).search(methodPattern, methodScope, (SearchRequestor)methodReq, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
            }
        }
        Collection<Object> methodMatches = methodReq.getMatches();
        methodMatches = SearchUtil.removeQueuedLinks(methodMatches);
        return methodMatches;
    }

    private static IPath extractPath(IType type) {
        IPath superClass;
        if (type.isBinary() || type.getResource() == null) {
            if (type.getResource() != null) {
                IJavaElement root = type.getAncestor(3);
                superClass = root.getPath().append("|").append(String.valueOf(type.getFullyQualifiedName().replace('.', '/')) + ".class");
            } else {
                superClass = type.getPath().append("|").append(String.valueOf(type.getFullyQualifiedName().replace('.', '/')) + ".class");
            }
        } else {
            superClass = type.getResource().getFullPath();
        }
        return superClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ILink addIfAbsentLink(ILink link, IProgressMonitor monitor) {
        Object object = SYNC;
        synchronized (object) {
            try {
                SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
                if (link.getSpecializedType().getId().equals("javaee.javatype.nodeid")) {
                    IType type = (IType)JavaCore.create((String)link.getParameter("javaee.handle"));
                    IPath path = SearchUtil.extractPath(type);
                    ILink typeLink = SearchUtil.searchForExistingTypeLink(link.getName(), path, monitor);
                    if (typeLink != null) {
                        if (Logger.SHOULD_TRACE_JDT_LINKS) {
                            Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("IType link SKIPPED: " + typeLink), (Throwable[])new Throwable[0]);
                        }
                        ILink iLink = typeLink;
                        return iLink;
                    }
                    InternalAPI.addLink((ILink)link);
                    if (Logger.SHOULD_TRACE_JDT_LINKS) {
                        Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("IType link ADDED: " + link), (Throwable[])new Throwable[0]);
                    }
                    ILink iLink = link;
                    return iLink;
                }
                if (link.getSpecializedType().getId().equals("javaee.jdt.publicmethod")) {
                    Collection<ILink> methodLinks;
                    String handle = link.getParameter("javaee.handle");
                    IMethod method = (IMethod)JavaCore.create((String)handle);
                    IType type = (IType)method.getParent();
                    IPath path = SearchUtil.extractPath(type);
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                    ILink typeLink = SearchUtil.searchForExistingTypeLink(type.getFullyQualifiedName(), path, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                    if (typeLink == null) {
                        typeLink = SearchUtil.createTypeLink(type);
                        InternalAPI.addLink((ILink)typeLink);
                        if (Logger.SHOULD_TRACE_JDT_LINKS) {
                            Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("IType link ADDED (by necessity): " + typeLink), (Throwable[])new Throwable[0]);
                        }
                    }
                    if ((methodLinks = SearchUtil.searchForExistingMethodLink(link.getName(), true, true, type, path, true, SearchUtil.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)))).isEmpty()) {
                        InternalAPI.addLink((ILink)link);
                        if (Logger.SHOULD_TRACE_JDT_LINKS) {
                            Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("IMethod link ADDED: " + link), (Throwable[])new Throwable[0]);
                        }
                        ILink iLink = link;
                        return iLink;
                    }
                    if (methodLinks.size() > 1) {
                        throw new RuntimeException(Messages.errorMsg_found_more_than_one_method_link);
                    }
                    Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("IMethod link SKIPPPED: " + methodLinks.iterator().next()), (Throwable[])new Throwable[0]);
                    ILink iLink = methodLinks.iterator().next();
                    return iLink;
                }
                throw new UnsupportedOperationException(Messages.errorMsg_can_not_add_this_link_type);
            }
            finally {
                SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            }
        }
    }

    public static ILink createTypeLink(IType type) {
        String linkName = type.getFullyQualifiedName();
        String linkType = "javaee.javatype.nodeid";
        TextRange linkRange = TextRange.EMPTY;
        TextRange contextRange = TextRange.EMPTY;
        IPath path = null;
        LinkNode container = null;
        if (type.isBinary() || type.getResource() == null) {
            path = SearchUtil.extractPath(type);
        } else {
            container = ReferenceManager.getReferenceManager().getLinkNode(type.getResource());
        }
        ReferenceElementFactory jdtFactory = SearchUtil.getJDTFactory(container);
        ILink link = jdtFactory.createLink(linkType, linkName, null, contextRange, null, linkRange, true);
        jdtFactory.addParam(link, "javaee.handle", type.getHandleIdentifier());
        if (type.getResource() == null) {
            jdtFactory.setCrossProjectAddressable(link, true);
        } else {
            jdtFactory.setCrossProjectAddressable(link, false);
        }
        InternalAPI.completeLink((IPath)path, (LinkNode)container, (ILink)link);
        return link;
    }

    public static ILink createOrUpdateMethodLink(ILink link, IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        String contextText = "";
        TextRange contextRange = TextRange.EMPTY;
        ISourceRange sr = method.getSourceRange();
        if (sr != null && sr.getOffset() != -1) {
            contextText = method.getSource();
            contextRange = new TextRange(sr.getOffset(), sr.getLength(), 0);
        }
        String returnType = method.getReturnType();
        String bareType = Signature.getElementType((String)returnType);
        String packageName = Signature.getSignatureQualifier((String)bareType);
        String typeName = Signature.getSignatureSimpleName((String)bareType);
        if (returnType != null && returnType.length() != 0) {
            if (JDTUtils.isPrimitive(returnType)) {
                returnType = Signature.toString((String)returnType);
            } else if ("void".equals(typeName)) {
                returnType = Signature.toString((String)returnType);
            } else if (packageName.startsWith("java") || packageName.startsWith("javax")) {
                returnType = Signature.toString((String)returnType);
            } else {
                int count = Signature.getArrayCount((String)returnType);
                returnType = Signature.getElementType((String)returnType);
                returnType = Signature.toString((String)returnType);
                String[][] resolvedTypes = null;
                try {
                    resolvedTypes = ((IType)method.getParent()).resolveType(returnType);
                }
                catch (RuntimeException runtimeException) {}
                if (resolvedTypes == null) {
                    Status s = new Status(2, "com.ibm.etools.references.web.javaee", "DEBUG: SearchUtil: Couldn't resolve return type for method: [" + method.getElementName() + " in " + ((IType)method.getParent()).getFullyQualifiedName() + "] Continuing using non-fully qualified return type: " + returnType);
                    Logger.log((Logger.Category)Logger.Category.DEBUG, (Logger.Severity)Logger.Severity.DEBUG, (Logger.Mode)Logger.Mode.DEV_MANDATORY, (IStatus)s);
                } else if (resolvedTypes.length <= 1) {
                    String qualified;
                    returnType = qualified = Signature.toQualifiedName((String[])resolvedTypes[0]);
                    returnType = Signature.createTypeSignature((String)qualified, (boolean)false);
                    returnType = Signature.createArraySignature((String)returnType, (int)count);
                    returnType = Signature.toString((String)returnType);
                }
            }
        }
        if (returnType == null) {
            returnType = "";
        }
        IPath path = null;
        LinkNode container = null;
        if (type.isBinary() || type.getResource() == null) {
            path = SearchUtil.extractPath(type);
        } else {
            container = ReferenceManager.getReferenceManager().getLinkNode(type.getResource());
        }
        ReferenceElementFactory jdtFactory = SearchUtil.getJDTFactory(container);
        TextRange linkRange = TextRange.EMPTY;
        String linkText = returnType;
        String linkType = "javaee.jdt.publicmethod";
        ILink realLink = null;
        realLink = link == null ? jdtFactory.createLink(linkType, method.getElementName(), contextText, contextRange, linkText, linkRange, false) : link;
        jdtFactory.addParam(realLink, "typeName.id", returnType);
        jdtFactory.addParam(realLink, "javaee.handle", method.getHandleIdentifier());
        if (link != null) {
            InternalAPI.updateLink((ILink)link, (String)linkType, (String)method.getElementName(), (String)contextText, (TextRange)contextRange, (String)linkText, (TextRange)linkRange, (boolean)true);
        }
        InternalAPI.completeLink((IPath)path, (LinkNode)container, (ILink)realLink);
        return realLink;
    }

    public static String getModelInstanceId(ICompilationUnit cu) {
        String name = JavaNodeProvider.getFullyQualifiedName(cu);
        return "jdt:" + name;
    }

    public static String getModelInstanceId(IMethod method) {
        return "jdt:" + ((IType)method.getParent()).getFullyQualifiedName() + ":" + method.getElementName();
    }

    private static String getMethodName(IMethod method) {
        return String.valueOf(((IType)method.getParent()).getFullyQualifiedName()) + "#" + method.getElementName();
    }

    public static List<InternalAPI.LinkDelta> syncIndexedTypeMethods(IType type) throws JavaModelException {
        boolean methodsAreIndexed = JDTLinkUtil.areTypeMethodsIndexed(type.getHandleIdentifier());
        ArrayList<InternalAPI.LinkDelta> deltas = new ArrayList<InternalAPI.LinkDelta>();
        if (!methodsAreIndexed) {
            IMethod[] method;
            String name = type.getFullyQualifiedName();
            if (name != null) {
                deltas.add(InternalAPI.newLinkDelta((String)name, (SpecializedType)ReferenceManager.getReferenceManager().getLinkType("javaee.javatype.nodeid"), (String)JST_LINKPROVIDER_STRING, (String)("jdt:" + name), (int)1));
            }
            IMethod[] iMethodArray = method = type.getMethods();
            int n = method.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (Flags.isPublic((int)m.getFlags())) {
                    deltas.add(InternalAPI.newLinkDelta((String)SearchUtil.getMethodName(m), (SpecializedType)ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod"), (String)JST_LINKPROVIDER_STRING, (String)SearchUtil.getModelInstanceId(m), (int)1));
                }
                ++n2;
            }
        } else {
            String typeHandle = type.getHandleIdentifier();
            IMethod[] methods = type.getMethods();
            Set<ILink> links = SearchUtil.getLinksForJavaElement((IJavaElement)type);
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n3 = 0;
            while (n3 < n) {
                IMethod method = iMethodArray[n3];
                if (Flags.isPublic((int)method.getFlags())) {
                    String id = method.getHandleIdentifier();
                    boolean found = false;
                    for (ILink link : links) {
                        String linkId = link.getParameter("javaee.handle");
                        if (!id.equals(linkId)) continue;
                        SearchUtil.createOrUpdateMethodLink(link, method);
                        InternalAPI.addLink((ILink)link);
                        deltas.add(InternalAPI.newLinkDelta((String)SearchUtil.getMethodName(method), (SpecializedType)ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod"), (String)JST_LINKPROVIDER_STRING, (String)SearchUtil.getModelInstanceId(method), (int)1));
                        found = true;
                        break;
                    }
                    if (!found && methodsAreIndexed) {
                        ILink newLink = SearchUtil.createOrUpdateMethodLink(null, method);
                        InternalAPI.addLink((ILink)newLink);
                        deltas.add(InternalAPI.newLinkDelta((String)SearchUtil.getMethodName(method), (SpecializedType)ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod"), (String)JST_LINKPROVIDER_STRING, (String)SearchUtil.getModelInstanceId(method), (int)1));
                    }
                }
                ++n3;
            }
            for (ILink link : links) {
                if (!"javaee.jdt.publicmethod".equals(link.getSpecializedType().getId())) continue;
                String linkId = link.getParameter("javaee.handle");
                IMethod methodLink = (IMethod)JavaCore.create((String)linkId);
                boolean found = false;
                if (methodLink.getParent().getHandleIdentifier().equals(typeHandle)) {
                    IMethod[] iMethodArray2 = methods;
                    int n4 = methods.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IMethod m = iMethodArray2[n5];
                        String mId = m.getHandleIdentifier();
                        if (linkId.equals(mId)) {
                            found = true;
                            break;
                        }
                        ++n5;
                    }
                }
                if (found) continue;
                deltas.add(InternalAPI.newLinkDelta((ILink)link, (int)2));
            }
        }
        return deltas;
    }

    private static Set<ILink> getLinksForJavaElement(IJavaElement element) {
        Set links;
        IResource r = element.getResource();
        if (r != null) {
            String path = "";
            path = r.getType() != 1 ? r.getFullPath().addTrailingSeparator().toString() : (element.getElementType() == 3 ? r.getFullPath().addTrailingSeparator().toString() : r.getFullPath().toString());
            links = InternalAPI.getLinksWithPrefixPath((String)path, null);
        } else {
            links = Collections.emptySet();
        }
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLinksForJavaElement(IJavaElement element) {
        Object object = SYNC;
        synchronized (object) {
            SearchUtil.removeLinks(SearchUtil.getLinksForJavaElement(element));
        }
    }

    public static void removeLinks(Set<ILink> links) {
        ArrayList<InternalAPI.LinkDelta> deltas = new ArrayList<InternalAPI.LinkDelta>();
        for (ILink link : links) {
            IMethod m;
            if (!link.getSpecializedType().getId().equals("javaee.javatype.nodeid") && !link.getSpecializedType().getId().equals("javaee.jdt.publicmethod")) continue;
            if ("javaee.javatype.nodeid".equals(link.getSpecializedType().getId())) {
                String tHandle = link.getParameter("javaee.handle");
                if (Logger.SHOULD_TRACE_JDT_LINKS) {
                    Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Clearing isMethodIndexed for: " + link), (Throwable[])new Throwable[0]);
                }
                InternalAPI.clearValue((String)"jdt", (String)tHandle);
            } else if ("javaee.jdt.publicmethod".equals(link.getSpecializedType().getId()) && (m = (IMethod)JavaCore.create((String)link.getParameter("javaee.handle"))) != null) {
                IType t = (IType)m.getParent();
                String tHandle = t.getHandleIdentifier();
                if (Logger.SHOULD_TRACE_JDT_LINKS) {
                    Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Clearing isMethodIndexed for: " + link), (Throwable[])new Throwable[0]);
                }
                InternalAPI.clearValue((String)"jdt", (String)tHandle);
            }
            deltas.add(InternalAPI.newLinkDelta((ILink)link, (int)2));
        }
        InternalAPI.processLinkDelta(deltas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILink addOrLocateMethodLink(IProject project, String typeName, String methodName, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ILink link = null;
        ILink typeLink = null;
        IJavaProject jp = JavaCore.create((IProject)project);
        Collection<ILink> typeMatches = SearchUtil.searchForTypeLink(jp, typeName, true, SearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        if (typeMatches.isEmpty()) {
            SubMonitor partA = mon.newChild(1);
            partA.setWorkRemaining(4);
            IType type = JDTUtils.searchType(jp, typeName, SearchUtil.monitorFor(monitor, (IProgressMonitor)partA.newChild(1)));
            if (type != null) {
                ILink theTypeLink = SearchUtil.createTypeLink(type);
                Object object = SYNC;
                synchronized (object) {
                    ILink existingLink;
                    typeLink = existingLink = SearchUtil.addIfAbsentLink(theTypeLink, SearchUtil.monitorFor(monitor, (IProgressMonitor)partA.newChild(1, 7)));
                    if (Logger.SHOULD_TRACE_JDT_LINKS && theTypeLink != existingLink) {
                        Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Weird: existing type found: " + type.getElementName()), (Throwable[])new Throwable[0]);
                    }
                    SearchUtil.addTypeHeirMethodsToIndex(jp, existingLink, SearchUtil.monitorFor(monitor, (IProgressMonitor)partA.newChild(1)));
                }
            } else {
                partA.newChild(2);
            }
        } else {
            SubMonitor partB = mon.newChild(1);
            partB.setWorkRemaining(2);
            typeLink = typeMatches.iterator().next();
            boolean typeMethodsIndexed = false;
            Object object = SYNC;
            synchronized (object) {
                typeMethodsIndexed = JDTLinkUtil.areTypeMethodsIndexed(typeLink.getParameter("javaee.handle"));
                if (!typeMethodsIndexed) {
                    Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Existing type found: " + typeLink.getName() + " but methods were NOT indexed"), (Throwable[])new Throwable[0]);
                    SearchUtil.addTypeHeirMethodsToIndex(jp, typeLink, SearchUtil.monitorFor(monitor, (IProgressMonitor)partB.newChild(1)));
                } else {
                    Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Existing type found: " + typeLink.getName() + " AND methods were indexed"), (Throwable[])new Throwable[0]);
                }
            }
        }
        Collection<ILink> reSearch = SearchUtil.searchForActualLinks(typeLink, jp, typeName, methodName, true, SearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        if (reSearch.size() == 1) {
            link = reSearch.iterator().next();
        }
        return link;
    }

    private static void addTypeHeirMethodsToIndex(IJavaProject jp, ILink typeLink, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SubMonitor partA = sub.newChild(1);
        Collection<Object> superTypeLinks = new ArrayList<ILink>();
        try {
            superTypeLinks = SearchUtil.getSuperTypeLinks(jp, typeLink, SearchUtil.monitorFor(monitor, (IProgressMonitor)partA));
        }
        catch (RuntimeException e) {
            Logger.logException((String)"Could not get supertype links ", (Exception)e);
        }
        superTypeLinks.add(typeLink);
        SubMonitor partB = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        partB.beginTask("", superTypeLinks.size());
        for (ILink iLink : superTypeLinks) {
            SubMonitor partC = partB.newChild(2);
            ILink existingLink = SearchUtil.addIfAbsentLink(iLink, SearchUtil.monitorFor(monitor, (IProgressMonitor)partC.newChild(1)));
            String tHandle = iLink.getParameter("javaee.handle");
            boolean methodsIndexed = JDTLinkUtil.areTypeMethodsIndexed(tHandle);
            if (iLink == existingLink) {
                if (!methodsIndexed) {
                    IType type = (IType)JavaCore.create((String)tHandle);
                    try {
                        IMethod[] methods = type.getMethods();
                        partC.setWorkRemaining(methods.length);
                        IMethod[] iMethodArray = methods;
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod m = iMethodArray[n2];
                            try {
                                if (Flags.isPublic((int)m.getFlags())) {
                                    ILink methodLink = SearchUtil.createOrUpdateMethodLink(null, m);
                                    SearchUtil.addIfAbsentLink(methodLink, (IProgressMonitor)partC.newChild(1));
                                } else {
                                    partC.worked(1);
                                }
                            }
                            catch (JavaModelException e) {
                                Logger.logException((String)"Error iterating IType methods, continuing...", (Exception)((Object)e));
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException e) {
                        Logger.logException((String)"Error retrieving IType methods", (Exception)((Object)e));
                    }
                    if (Logger.SHOULD_TRACE_JDT_LINKS) {
                        Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Type methods are indexed: " + iLink), (Throwable[])new Throwable[0]);
                    }
                    JDTLinkUtil.setTypeMethodsAreIndexed(tHandle, true);
                    continue;
                }
                if (!Logger.SHOULD_TRACE_JDT_LINKS) continue;
                Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("SKIP: Existing type with indexed methods: " + iLink), (Throwable[])new Throwable[0]);
                continue;
            }
            if (Logger.SHOULD_TRACE_JDT_LINKS) {
                Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Type already present: " + iLink), (Throwable[])new Throwable[0]);
            }
            if (methodsIndexed || !Logger.SHOULD_TRACE_JDT_LINKS) continue;
            Logger.trace((Logger.Category)Logger.Category.JDT_LINKS, (String)("Existing type detected: " + iLink + ", but methods were NOT indexed!"), (Throwable[])new Throwable[0]);
        }
    }

    private static Collection<ILink> removeQueuedLinks(Collection<ILink> links) {
        Iterator<ILink> iterator = links.iterator();
        while (iterator.hasNext()) {
            ILink link = iterator.next();
            if (!SearchUtil.isRemovePending(link)) continue;
            iterator.remove();
        }
        return links;
    }

    private static boolean isRemovePending(ILink link) {
        InternalAPI.LinkDelta delta = InternalAPI.getQueuedLinkDelta((ILink)link);
        return delta != null && delta.kind == 2;
    }

    private static IProgressMonitor monitorFor(IProgressMonitor rootMonitor, IProgressMonitor subMonitor) {
        if (rootMonitor == null || rootMonitor instanceof NullProgressMonitor) {
            return rootMonitor;
        }
        return subMonitor;
    }
}

