/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.refactoring;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.javaee.internal.nls.Messages;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTLink;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTUtils;
import com.ibm.etools.references.web.javaee.internal.refactoring.JavaRefactoringSupport;
import java.util.EnumSet;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class JavaReferenceRenameRefactoringParticipant
extends RenameParticipant {
    private Object elementToBeMoved;
    private JavaRefactoringSupport refactoringSupport;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (!this.getArguments().getUpdateReferences()) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        try {
            IJavaElement r = (IJavaElement)this.elementToBeMoved;
            if (r instanceof IType) {
                IType type = (IType)r;
                JDTLink link = JDTUtils.createTypeLink(type);
                String newName = String.valueOf(type.getPackageFragment().getElementName()) + "." + this.getArguments().getNewName();
                this.renameType(pm, link, newName);
            } else if (r instanceof IMethod) {
                IMethod method = (IMethod)r;
                JDTLink link = JDTUtils.createMethodLink(method);
                String newMethodName = this.getArguments().getNewName();
                IType type = (IType)method.getParent();
                String typeName = type.getFullyQualifiedName();
                this.renameMethod(pm, link, typeName, newMethodName);
            } else if (r instanceof IPackageFragment) {
                IPackageFragment frag = (IPackageFragment)r;
                String newName = this.getArguments().getNewName();
                IJavaElement[] javaChildren = frag.getChildren();
                Object[] nonJava = frag.getNonJavaResources();
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)pm, (int)(javaChildren.length + nonJava.length));
                Object[] objectArray = javaChildren;
                int n = javaChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement javaElement = objectArray[n2];
                    if (javaElement.getElementType() == 5) {
                        ICompilationUnit cu = (ICompilationUnit)javaElement;
                        IType t = cu.findPrimaryType();
                        if (t != null) {
                            JDTLink link = JDTUtils.createTypeLink(t);
                            String newTypeName = String.valueOf(newName) + "." + t.getElementName();
                            this.renameType((IProgressMonitor)mon.newChild(1), link, newTypeName);
                        } else {
                            mon.worked(1);
                        }
                    } else {
                        mon.worked(1);
                    }
                    ++n2;
                }
                objectArray = nonJava;
                n = nonJava.length;
                n2 = 0;
                while (n2 < n) {
                    IJavaElement object = objectArray[n2];
                    if (object instanceof IResource) {
                        IResource res = (IResource)object;
                        if (res.getType() == 1) {
                            IFile file = (IFile)res;
                            if ("properties".equals(file.getFileExtension())) {
                                String newPropertiesName = String.valueOf(newName) + "." + file.getFullPath().removeFileExtension().lastSegment();
                                this.renameFile((IProgressMonitor)mon.newChild(1), file, newPropertiesName);
                            } else {
                                mon.worked(1);
                            }
                        } else {
                            mon.worked(1);
                        }
                    } else {
                        mon.worked(1);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            return RefactoringStatus.create((IStatus)e.getStatus());
        }
        return this.refactoringSupport.getStatus();
    }

    private void renameMethod(IProgressMonitor monitor, JDTLink sourceLink, String typeName, String newMethodName) {
        HashMap<String, String> targetDescription = new HashMap<String, String>();
        targetDescription.put("typeName.id", typeName);
        targetDescription.put("methodName.id", newMethodName);
        this.refactoringSupport.createEdits(sourceLink, targetDescription, EnumSet.of(ProviderArguments.LINKSTYLE_PRESERVE), monitor);
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.refactoringSupport.createMergedChange(Messages.refactoring_keep_links_uptodate, (RefactoringParticipant)this, pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    protected void renameType(IProgressMonitor monitor, JDTLink sourceLink, String typeName) {
        HashMap<String, String> targetDescription = new HashMap<String, String>();
        targetDescription.put("typeName.id", typeName);
        this.refactoringSupport.createEdits(sourceLink, targetDescription, EnumSet.of(ProviderArguments.LINKSTYLE_PRESERVE), monitor);
    }

    private void renameFile(IProgressMonitor monitor, IFile sourcefile, String newName) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        LinkNode linkNode = ReferenceManager.getReferenceManager().getLinkNode(sourcefile);
        ILink link = this.refactoringSupport.getNodeIdLink(linkNode, (IProgressMonitor)mon.newChild(1));
        if (mon.isCanceled()) {
            return;
        }
        HashMap<String, String> targetDescription = new HashMap<String, String>();
        targetDescription.put("propertiesFile.id", newName);
        this.refactoringSupport.createEdits(link, targetDescription, EnumSet.of(ProviderArguments.LINKSTYLE_PRESERVE), (IProgressMonitor)mon.newChild(1));
    }

    public String getName() {
        return Messages.refactoring_update_links_to_java;
    }

    protected boolean initialize(Object element) {
        this.elementToBeMoved = element;
        this.refactoringSupport = new JavaRefactoringSupport();
        return true;
    }
}

