/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.refactoring;

import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.javaee.internal.nls.Messages;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTLink;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTUtils;
import com.ibm.etools.references.web.javaee.internal.refactoring.JavaRefactoringSupport;
import java.util.EnumSet;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;

public class JavaReferenceMoveRefactoringParticipant
extends MoveParticipant {
    private Object elementToBeMoved;
    private JavaRefactoringSupport refactoringSupport;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (!this.getArguments().getUpdateReferences()) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        IJavaElement r = (IJavaElement)this.elementToBeMoved;
        try {
            if (r instanceof IType) {
                IType type = (IType)r;
                JDTLink link = JDTUtils.createTypeLink(type);
                IPackageFragment newPackage = (IPackageFragment)this.getArguments().getDestination();
                String newType = String.valueOf(newPackage.getElementName()) + "." + type.getElementName();
                this.moveType(pm, link, newType, null);
            }
        }
        catch (ReferenceException e) {
            Status error = new Status(4, "com.ibm.etools.references.web.javaee", e.getMessage(), (Throwable)e);
            return RefactoringStatus.create((IStatus)error);
        }
        return this.refactoringSupport.getStatus();
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.refactoringSupport.createMergedChange(Messages.refactoring_keep_links_uptodate, (RefactoringParticipant)this, pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private void moveType(IProgressMonitor monitor, JDTLink sourceLink, String targetType, String targetMethod) throws ReferenceException {
        HashMap<String, String> targetDescription = new HashMap<String, String>();
        targetDescription.put("methodName.id", targetMethod);
        targetDescription.put("typeName.id", targetType);
        this.refactoringSupport.createEdits(sourceLink, targetDescription, EnumSet.of(ProviderArguments.LINKSTYLE_PRESERVE), monitor);
    }

    public String getName() {
        return Messages.refactoring_update_links_to_java;
    }

    protected boolean initialize(Object element) {
        this.elementToBeMoved = element;
        this.refactoringSupport = new JavaRefactoringSupport();
        return true;
    }
}

