/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.jdt;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.web.javaee.internal.nls.Messages;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.core.search.TypeNameRequestor;

public class JDTUtils {
    private static boolean USE_SEARCH_ENGINE = false;

    public static IType searchSystemType(String typeName) {
        IJavaModel root = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root}, (int)6);
        SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)0, (int)0, (int)0);
        MySearchRequestor requestor = new MySearchRequestor();
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(Messages.errorMsg_error_searching_for_type, e);
        }
        if (requestor.getMatches().isEmpty()) {
            return null;
        }
        return (IType)requestor.getMatches().iterator().next().getElement();
    }

    public static IType searchType(IJavaProject project, String typeName, IProgressMonitor monitor) {
        long start;
        block8: {
            IType iType;
            if (typeName == null || typeName.trim().length() == 0) {
                return null;
            }
            if (project == null || !project.exists()) {
                return null;
            }
            start = System.currentTimeMillis();
            try {
                if (!USE_SEARCH_ENGINE) break block8;
                iType = JDTUtils.findTypeUsingEngine(project, typeName, monitor);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                if (Logger.SHOULD_TRACE_TIMING) {
                    Logger.trace((Logger.Category)Logger.Category.TIMING, (String)("Lookup " + typeName + " " + (float)(end - start) / 1000.0f + "s"), (Throwable[])new Throwable[]{null});
                }
                throw throwable;
            }
            long end = System.currentTimeMillis();
            if (Logger.SHOULD_TRACE_TIMING) {
                Logger.trace((Logger.Category)Logger.Category.TIMING, (String)("Lookup " + typeName + " " + (float)(end - start) / 1000.0f + "s"), (Throwable[])new Throwable[]{null});
            }
            return iType;
        }
        IType iType = JDTUtils.findTypeUsingProject(project, typeName, monitor);
        long end = System.currentTimeMillis();
        if (Logger.SHOULD_TRACE_TIMING) {
            Logger.trace((Logger.Category)Logger.Category.TIMING, (String)("Lookup " + typeName + " " + (float)(end - start) / 1000.0f + "s"), (Throwable[])new Throwable[]{null});
        }
        return iType;
    }

    private static IType findTypeUsingProject(IJavaProject project, String typeName, IProgressMonitor m) {
        try {
            return project.findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static IType findTypeUsingEngine(IJavaProject project, String typeName, IProgressMonitor monitor) {
        String nonQualified = Signature.getSimpleName((String)typeName);
        String packName = Signature.getQualifier((String)typeName);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (int)15);
        MyTypeNameMatchRequestor typeNameReq = new MyTypeNameMatchRequestor();
        try {
            new SearchEngine().searchAllTypeNames(packName.toCharArray(), 0, nonQualified.toCharArray(), 0, 0, scope, (TypeNameMatchRequestor)typeNameReq, 3, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IType foundType = null;
        List<IType> matches = typeNameReq.getMatches();
        if (!matches.isEmpty()) {
            foundType = matches.iterator().next();
        }
        return foundType;
    }

    public static JDTLink createJDTTypeLink(IJavaProject p, String typeName, IProgressMonitor monitor) {
        IType type = JDTUtils.searchType(p, typeName, monitor);
        if (type == null) {
            return null;
        }
        return JDTUtils.createTypeLink(type);
    }

    public static JDTLink createTypeLink(IType type) {
        JDTLink link = new JDTLink(type.getHandleIdentifier());
        link.name = type.getFullyQualifiedName();
        link.specializedType = ReferenceManager.getReferenceManager().getLinkType("javaee.javatype.nodeid");
        try {
            if (type.exists()) {
                if (type.getUnderlyingResource() == null) {
                    link.extPath = type.getPath().toString();
                } else {
                    link.container = ReferenceManager.getReferenceManager().getLinkNode(type.getUnderlyingResource());
                }
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(Messages.errorMsg_error_creating_type_link, e);
        }
        return link;
    }

    public static JDTLink createMethodLink(IMethod method) {
        JDTLink link = new JDTLink(method.getHandleIdentifier());
        link.name = method.getElementName();
        try {
            IResource underlying = method.getUnderlyingResource();
            if (underlying == null) {
                link.extPath = method.getPath().toString();
            } else {
                link.container = ReferenceManager.getReferenceManager().getLinkNode((IFile)underlying);
            }
            ISourceRange sr = method.getSourceRange();
            link.contextLocation = new TextRange(sr.getOffset(), sr.getLength(), 0);
            link.location = new TextRange(sr.getOffset(), sr.getLength(), 0);
            link.contextText = method.getCompilationUnit() == null ? "binaryType" : method.getCompilationUnit().getBuffer().getText(sr.getOffset(), sr.getLength());
            String returnType = Signature.toString((String)method.getReturnType());
            if (JDTUtils.isPrimitive(method.getReturnType())) {
                link.text = returnType;
                link.specializedType = ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod");
            } else if ("void".equals(returnType)) {
                link.text = returnType;
                link.specializedType = ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod");
            } else if (returnType != null && returnType.startsWith("java.lang.")) {
                link.text = returnType;
                link.specializedType = ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod");
            } else {
                String[][] resolvedTypes = ((IType)method.getParent()).resolveType(returnType);
                if (resolvedTypes == null) {
                    link.text = returnType;
                    link.specializedType = ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod");
                } else if (resolvedTypes.length <= 1) {
                    String qualified;
                    link.text = qualified = Signature.toQualifiedName((String[])resolvedTypes[0]);
                    link.specializedType = ReferenceManager.getReferenceManager().getLinkType("javaee.jdt.publicmethod");
                }
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(Messages.errorMsg_error_creating_method_link, e);
        }
        return link;
    }

    public static final boolean isPrimitive(String typeSignature) {
        int kind;
        typeSignature = Signature.getElementType((String)typeSignature);
        String packageName = Signature.getSignatureQualifier((String)typeSignature);
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        if (typeName == null || typeName.length() == 0) {
            return false;
        }
        if (packageName != null && !packageName.equals("")) {
            typeName = String.valueOf(packageName) + '.' + typeName;
        }
        boolean isPrimitive = false;
        if (typeName.equals("java.lang.String") || typeName.equals("String")) {
            isPrimitive = true;
        }
        isPrimitive = (kind = Signature.getTypeSignatureKind((String)typeSignature)) == 2;
        return isPrimitive;
    }

    public static final class MySearchRequestor
    extends SearchRequestor {
        private final List<SearchMatch> matches = new ArrayList<SearchMatch>();

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.matches.add(match);
        }

        public void beginReporting() {
            this.matches.clear();
        }

        public void endReporting() {
        }

        public List<SearchMatch> getMatches() {
            return Collections.unmodifiableList(this.matches);
        }
    }

    public static class MyTypeNameMatchRequestor
    extends TypeNameMatchRequestor {
        private final List<IType> matches = new ArrayList<IType>();

        public void acceptTypeNameMatch(TypeNameMatch match) {
            this.matches.add(match.getType());
        }

        public List<IType> getMatches() {
            return this.matches;
        }
    }

    public static class MyTypeNameRequestor
    extends TypeNameRequestor {
        private final List<String> matches = new ArrayList<String>();

        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            String name = new String(packageName);
            name = String.valueOf(name) + "." + new String(simpleTypeName);
            this.matches.add(name);
        }

        public List<String> getMatches() {
            return this.matches;
        }
    }
}

