/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.javaee.providers.resolvers.JDTReferenceResolver;
import com.ibm.etools.references.web.providers.generators.WebLinkFullWebAppRelativeGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WebXMLReferenceGeneratorProvider
extends WebLinkFullWebAppRelativeGeneratorProvider
implements IReferenceGeneratorProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        transformResult = AbstractWebProvider.trimQuotes((String)transformResult);
        Reference reference = null;
        if ("javaee.javatype.nodeid".equals(referenceType)) {
            String type = link.getParameter("javaee.param.servlettype");
            if (!"class".equals(type)) return Collections.emptyList();
            reference = JDTReferenceResolver.createReference(link, transformResult, null);
        } else if ("web.reference.workspacePath".equals(referenceType)) {
            String type = link.getParameter("javaee.param.servlettype");
            if (!"jsp".equals(type)) return Collections.emptyList();
            reference = this.createReference(link, transformResult, referenceType);
        } else if ("javaee.webxml.servlet.name.reference".equals(referenceType)) {
            reference = new Reference(link, referenceType);
            reference.addParameter("javaee.webxml.servlet.name.id", transformResult);
            reference.setFragmentLocation(AbstractWebProvider.createTrimmedRange((ILink)link));
        }
        if (reference != null) return Collections.singletonList(reference);
        return Collections.emptyList();
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if ("javaee.javatype.nodeid".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("typeName.id");
        }
        if ("javaee.webxml.servlet.name.reference".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("javaee.webxml.servlet.name.id");
        }
        if ("javaee.servletmapping.ref".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("javaee.param.servleturlpattern.id");
        }
        return super.renameReference(params);
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        if ("javaee.javatype.nodeid".equals(params.reference.getReferenceType()) || "javaee.webxml.servlet.name.reference".equals(params.reference.getReferenceType()) || "javaee.servletmapping.ref".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        return super.checkRenameReference(params);
    }
}

